/*
 * Decompiled with CFR 0.152.
 */
package spray.can.websocket.frame;

import akka.util.ByteString;
import akka.util.ByteString$;
import akka.util.ByteStringBuilder;
import scala.Array$;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Stream$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import spray.can.websocket.frame.BinaryFrame;
import spray.can.websocket.frame.BinaryFrame$;
import spray.can.websocket.frame.BinaryFrameStream;
import spray.can.websocket.frame.ContinuationFrame;
import spray.can.websocket.frame.ContinuationFrame$;
import spray.can.websocket.frame.Frame;
import spray.can.websocket.frame.Frame$;
import spray.can.websocket.frame.FrameStream;
import spray.can.websocket.frame.TextFrame;
import spray.can.websocket.frame.TextFrame$;
import spray.can.websocket.frame.TextFrameStream;

public final class FrameRender$ {
    public static final FrameRender$ MODULE$;

    static {
        new FrameRender$();
    }

    public ByteString apply(Frame frame, byte[] maskingKey2) {
        return this.render(frame, maskingKey2);
    }

    public byte[] apply$default$2() {
        return (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte());
    }

    public ByteString render(Frame frame, byte[] maskingKey2) {
        ByteStringBuilder byteStringBuilder;
        ByteStringBuilder builder = ByteString$.MODULE$.newBuilder();
        byte b0 = frame.finRsvOp();
        builder.putByte(b0);
        int masked = maskingKey2.length > 0 ? 1 : 0;
        int payloadLen = frame.payload().length();
        int payloadLenBits = payloadLen <= 125 ? payloadLen : (payloadLen <= 65535 ? 126 : 127);
        int b1 = masked << 7 | payloadLenBits;
        builder.putByte((byte)b1);
        int n = b1 & 0x7F;
        switch (n) {
            default: {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                break;
            }
            case 127: {
                BoxedUnit boxedUnit = builder.putLong((long)payloadLen, Frame$.MODULE$.byteOrder());
                break;
            }
            case 126: {
                BoxedUnit boxedUnit = builder.putShort(payloadLen, Frame$.MODULE$.byteOrder());
            }
        }
        if (masked == 1) {
            builder.putBytes(maskingKey2);
            byteStringBuilder = builder.append(Frame$.MODULE$.maskData(frame.payload(), maskingKey2));
        } else {
            byteStringBuilder = builder.append(frame.payload());
        }
        return builder.result();
    }

    public byte[] render$default$2() {
        return (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte());
    }

    public Stream<Frame> streamingRender(FrameStream frame) {
        return this.spray$can$websocket$frame$FrameRender$$fromFrameStream$1(true, frame);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Frame buildFrame$1(boolean first, FrameStream frame, ByteString payload) {
        ContinuationFrame continuationFrame;
        if (first) {
            void var5_7;
            FrameStream frameStream = frame;
            if (frameStream instanceof TextFrameStream) {
                TextFrame textFrame = TextFrame$.MODULE$.apply(false, payload);
            } else {
                if (!(frameStream instanceof BinaryFrameStream)) throw new MatchError((Object)frameStream);
                BinaryFrame binaryFrame = BinaryFrame$.MODULE$.apply(false, payload);
            }
            continuationFrame = var5_7;
            return continuationFrame;
        } else {
            continuationFrame = ContinuationFrame$.MODULE$.apply(payload);
        }
        return continuationFrame;
    }

    public final Stream spray$can$websocket$frame$FrameRender$$fromFrameStream$1(boolean first, FrameStream frame) {
        Stream stream;
        byte[] buffer = new byte[frame.chunkSize()];
        try {
            int n = frame.payload().read(buffer);
            switch (n) {
                default: {
                    Frame frame2 = this.buildFrame$1(first, frame, ByteString$.MODULE$.apply((byte[])Predef$.MODULE$.byteArrayOps(buffer).slice(0, n)));
                    stream = Stream$.MODULE$.consWrapper((Function0)new Serializable(frame){
                        public static final long serialVersionUID = 0L;
                        private final FrameStream frame$1;

                        public final Stream<Frame> apply() {
                            return FrameRender$.MODULE$.spray$can$websocket$frame$FrameRender$$fromFrameStream$1(false, this.frame$1);
                        }
                        {
                            this.frame$1 = frame$1;
                        }
                    }).$hash$colon$colon((Object)frame2);
                    break;
                }
                case -1: {
                    if (first) {
                        stream = package$.MODULE$.Stream().empty();
                        break;
                    }
                    stream = package$.MODULE$.Stream().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ContinuationFrame[]{ContinuationFrame$.MODULE$.apply(true, ByteString$.MODULE$.empty())}));
                    break;
                }
            }
        }
        catch (Throwable throwable) {
            stream = package$.MODULE$.Stream().empty();
        }
        return stream;
    }

    private FrameRender$() {
        MODULE$ = this;
    }
}

