/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.boot;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.multibindings.MapBinder;
import com.google.inject.name.Names;
import io.netty.channel.ChannelHandler;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Set;
import org.summerboot.jexpress.boot.config.ConfigChangeListener;
import org.summerboot.jexpress.boot.config.ConfigChangeListenerImpl;
import org.summerboot.jexpress.boot.instrumentation.BootHealthInspectorImpl;
import org.summerboot.jexpress.boot.instrumentation.HTTPClientStatusListener;
import org.summerboot.jexpress.boot.instrumentation.HealthInspector;
import org.summerboot.jexpress.boot.instrumentation.NIOStatusListener;
import org.summerboot.jexpress.boot.instrumentation.jmx.InstrumentationMgr;
import org.summerboot.jexpress.boot.instrumentation.jmx.InstrumentationMgrImpl;
import org.summerboot.jexpress.boot.instrumentation.jmx.ServerStatus;
import org.summerboot.jexpress.boot.instrumentation.jmx.ServerStatusMBean;
import org.summerboot.jexpress.integration.smtp.BootPostOfficeImpl;
import org.summerboot.jexpress.integration.smtp.PostOffice;
import org.summerboot.jexpress.nio.server.BootHttpPingHandler;
import org.summerboot.jexpress.nio.server.BootHttpRequestHandler;
import org.summerboot.jexpress.nio.server.annotation.Controller;
import org.summerboot.jexpress.util.ReflectionUtil;

class BootGuiceModule
extends AbstractModule {
    private final Object caller;
    private final Class callerClass;
    private final boolean startNIO;
    private final String callerRootPackageName;

    public BootGuiceModule(Object caller, Class callerClass, boolean startNIO) {
        this.caller = caller;
        this.callerClass = callerClass == null ? caller.getClass() : callerClass;
        this.startNIO = startNIO;
        this.callerRootPackageName = ReflectionUtil.getRootPackageName(this.callerClass);
    }

    public void configure() {
        this.bind(NIOStatusListener.class).to(ServerStatus.class);
        this.bind(HTTPClientStatusListener.class).to(ServerStatus.class);
        this.bind(ServerStatusMBean.class).to(ServerStatus.class);
        this.bind(InstrumentationMgr.class).to(InstrumentationMgrImpl.class);
        this.bind(HealthInspector.class).to(BootHealthInspectorImpl.class);
        this.bind(ConfigChangeListener.class).to(ConfigChangeListenerImpl.class);
        this.bind(PostOffice.class).to(BootPostOfficeImpl.class);
        if (this.startNIO) {
            this.bind(ChannelHandler.class).annotatedWith((Annotation)Names.named((String)BootHttpPingHandler.class.getName())).to(BootHttpPingHandler.class);
            this.bind(ChannelHandler.class).annotatedWith((Annotation)Names.named((String)BootHttpRequestHandler.class.getName())).to(BootHttpRequestHandler.class);
            this.bindControllers(this.binder(), this.callerRootPackageName);
        }
        if (this.caller != null) {
            this.requestInjection(this.caller);
        }
    }

    private void bindControllers(Binder binder, String ... rootPackageNames) {
        this.bindControllers(binder, Controller.class, rootPackageNames);
    }

    private void bindControllers(Binder binder, Class<? extends Annotation> annotation, String ... rootPackageNames) {
        MapBinder mapbinder = MapBinder.newMapBinder((Binder)binder, String.class, Object.class, annotation);
        HashSet classesAll = new HashSet();
        for (String rootPackageName : rootPackageNames) {
            Set<Class<?>> classes = ReflectionUtil.getAllImplementationsByAnnotation(annotation, rootPackageName);
            classesAll.addAll(classes);
        }
        classesAll.forEach(c -> mapbinder.addBinding((Object)c.getName()).to(c));
    }
}

