/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.boot;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.name.Names;
import com.google.inject.util.Modules;
import io.netty.channel.ChannelHandler;
import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.management.ManagementFactory;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.summerboot.jexpress.boot.BootConstant;
import org.summerboot.jexpress.boot.BootGuiceModule;
import org.summerboot.jexpress.boot.cli.BootCLI;
import org.summerboot.jexpress.boot.config.BootConfig;
import org.summerboot.jexpress.boot.config.ConfigChangeListener;
import org.summerboot.jexpress.boot.config.ConfigUtil;
import org.summerboot.jexpress.boot.config.JExpressConfig;
import org.summerboot.jexpress.boot.instrumentation.HealthInspector;
import org.summerboot.jexpress.boot.instrumentation.HealthMonitor;
import org.summerboot.jexpress.boot.instrumentation.jmx.InstrumentationMgr;
import org.summerboot.jexpress.i18n.I18n;
import org.summerboot.jexpress.integration.smtp.BootPostOfficeImpl;
import org.summerboot.jexpress.integration.smtp.PostOffice;
import org.summerboot.jexpress.integration.smtp.SMTPConfig;
import org.summerboot.jexpress.nio.server.BootHttpPingHandler;
import org.summerboot.jexpress.nio.server.BootHttpRequestHandler;
import org.summerboot.jexpress.nio.server.HttpConfig;
import org.summerboot.jexpress.nio.server.NioConfig;
import org.summerboot.jexpress.nio.server.NioServer;
import org.summerboot.jexpress.nio.server.NioServerContext;
import org.summerboot.jexpress.nio.server.domain.Err;
import org.summerboot.jexpress.security.auth.AuthConfig;
import org.summerboot.jexpress.util.ApplicationUtil;
import org.summerboot.jexpress.util.BeanUtil;
import org.summerboot.jexpress.util.FormatterUtil;
import org.summerboot.jexpress.util.ReflectionUtil;

public abstract class SummerApplication
extends BootCLI {
    protected static Logger log;
    private static final String CFG_MONITOR_INTERVAL = "cmi";
    private static final String CLI_MOCKMODE = "mock";
    private static final String CLI_ERROR_CODE = "errorcode";
    private static final String CLI_POI_LIST = "poi";
    private static final String CLI_SHOW_CONFIG = "sample";
    private static final String CLI_I8N = "i18n";
    private static String callerRootPackageName;
    private static final Set<String> appMockOptions;
    private Locale cfgDefaultRB;
    private String envName;
    private Path cfgConfigDir;
    private int CfgMonitorInterval;
    private Injector iocInjector;
    private String cfgEnvFolderPrefix;
    private final Class controllerScanRootClass;
    private Class<? extends PostOffice> bindingPostOfficeClass = BootPostOfficeImpl.class;
    private AbstractModule bindingAppModule;
    private Class<? extends ChannelHandler> bindingChannelHandlerClass;
    private String bindingChannelHandlerBindingName;
    private Class enable_cli_errorCodeClass;
    private Class enable_cli_poiNameClass;
    private Set<String> enable_cli_validMockValues = null;
    private Class<? extends HealthInspector> enable_ping_healthInspectorClass;
    private final Map<String, Class> enable_cli_validConfigs = new LinkedHashMap<String, Class>();
    @Inject
    private PostOffice postOffice;
    @Inject
    private HealthInspector healthInspector;
    @Inject
    private ConfigChangeListener configChangeListener;
    @Inject
    private InstrumentationMgr instrumentationMgr;
    private List<RegisteredAppConfig> registeredAppConfigs;
    private Boolean jmxRequired;
    private static final String SUN_JAVA_COMMAND = "sun.java.command";

    public static SummerApplication bind(Class controllerScanRootClass) {
        return new SummerApplication(controllerScanRootClass){

            @Override
            protected void locadCustomizedConfigs(Path configFolder) {
            }

            @Override
            protected void beforeStart(CommandLine cli) {
            }
        };
    }

    public static Module buildModule(AbstractModule appModule, Class callerClass) {
        BootGuiceModule frameworkModule = new BootGuiceModule(null, callerClass, true);
        BootGuiceModule finalModule = appModule == null ? frameworkModule : Modules.override((Module[])new Module[]{frameworkModule}).with(new Module[]{appModule});
        return finalModule;
    }

    public static boolean isMockMode(String mockItemName) {
        return appMockOptions.contains(mockItemName);
    }

    public static Set<String> getAppMockOptions() {
        return Set.copyOf(appMockOptions);
    }

    public static String getCallerRootPackageName() {
        return callerRootPackageName;
    }

    protected SummerApplication() {
        this.enable_cli_validConfigs.put(NioConfig.class.getSimpleName(), NioConfig.class);
        this.enable_cli_validConfigs.put(HttpConfig.class.getSimpleName(), HttpConfig.class);
        this.enable_cli_validConfigs.put(SMTPConfig.class.getSimpleName(), SMTPConfig.class);
        this.enable_cli_validConfigs.put(AuthConfig.class.getSimpleName(), AuthConfig.class);
        this.registeredAppConfigs = null;
        this.controllerScanRootClass = this.getClass();
    }

    private SummerApplication(Class controllerScanRootClass) {
        this.enable_cli_validConfigs.put(NioConfig.class.getSimpleName(), NioConfig.class);
        this.enable_cli_validConfigs.put(HttpConfig.class.getSimpleName(), HttpConfig.class);
        this.enable_cli_validConfigs.put(SMTPConfig.class.getSimpleName(), SMTPConfig.class);
        this.enable_cli_validConfigs.put(AuthConfig.class.getSimpleName(), AuthConfig.class);
        this.registeredAppConfigs = null;
        this.controllerScanRootClass = controllerScanRootClass;
    }

    public Locale getCfgDefaultRB() {
        return this.cfgDefaultRB;
    }

    public String getEnvName() {
        return this.envName;
    }

    public Path getCfgConfigDir() {
        return this.cfgConfigDir;
    }

    public String getCfgEnvFolderPrefix() {
        return this.cfgEnvFolderPrefix;
    }

    public Injector getIocInjector() {
        return this.iocInjector;
    }

    public <T extends SummerApplication> T bind_AlertMessenger(Class<? extends PostOffice> postOfficeClass) {
        this.bindingPostOfficeClass = postOfficeClass;
        return (T)this;
    }

    public <T extends SummerApplication> T bind_GuiceModule(AbstractModule appModule) {
        this.bindingAppModule = appModule;
        return (T)this;
    }

    public <T extends SummerApplication> T bind_NIOHandler(Class<? extends ChannelHandler> channelHandlerClass) {
        return this.bind_NIOHandler(channelHandlerClass, null);
    }

    public <T extends SummerApplication> T bind_NIOHandler(Class<? extends ChannelHandler> channelHandlerClass, String channelHandlerBindingName) {
        if (StringUtils.isBlank((CharSequence)channelHandlerBindingName)) {
            channelHandlerBindingName = channelHandlerClass.getName();
        }
        if (BootHttpRequestHandler.class.getName().equals(channelHandlerBindingName) || BootHttpPingHandler.class.getName().equals(channelHandlerBindingName)) {
            throw new UnsupportedOperationException("binding name is reserved by SummerBoot Framework");
        }
        this.bindingChannelHandlerClass = channelHandlerClass;
        this.bindingChannelHandlerBindingName = channelHandlerBindingName;
        return (T)this;
    }

    public <T extends SummerApplication> T bind_BootConfig(String configFileName, JExpressConfig config) {
        return this.bind_BootConfig(configFileName, config, null, false);
    }

    public <T extends SummerApplication> T bind_BootConfig(String configFileName, JExpressConfig config, String mockName, boolean registerWhenMockIsEnabled) {
        if (this.registeredAppConfigs == null) {
            this.registeredAppConfigs = new ArrayList<RegisteredAppConfig>();
        }
        this.registeredAppConfigs.add(new RegisteredAppConfig(configFileName, config, mockName, registerWhenMockIsEnabled));
        return (T)this;
    }

    public <T extends SummerApplication> T enable_CLI_ListErrorCodes(Class errorCodeClass, boolean checkDuplicated) throws IllegalArgumentException, IllegalAccessException, JsonProcessingException {
        Map<Object, Set<String>> duplicated;
        this.enable_cli_errorCodeClass = errorCodeClass;
        if (errorCodeClass != null && checkDuplicated && !(duplicated = ApplicationUtil.checkDuplicateFields(errorCodeClass, Integer.TYPE)).isEmpty()) {
            String report = BeanUtil.toJson(duplicated, true, false);
            System.err.println("duplicated.AppErrorCode=" + report);
            System.exit(1);
        }
        return (T)this;
    }

    public <T extends SummerApplication> T enable_CLI_ListPOIs(Class poiNameClass, boolean checkDuplicated) throws IllegalArgumentException, IllegalAccessException, JsonProcessingException {
        Map<Object, Set<String>> duplicated;
        this.enable_cli_poiNameClass = poiNameClass;
        if (this.enable_cli_errorCodeClass != null && checkDuplicated && !(duplicated = ApplicationUtil.checkDuplicateFields(poiNameClass, String.class)).isEmpty()) {
            String report = BeanUtil.toJson(duplicated, true, false);
            System.err.println("duplicated.ServicePOI=" + report);
            System.exit(1);
        }
        return (T)this;
    }

    public <T extends SummerApplication> T enable_CLI_MockMode(Class<? extends Enum<?>> enumClass) {
        return this.enable_CLI_MockMode(FormatterUtil.getEnumNames(enumClass));
    }

    public <T extends SummerApplication> T enable_CLI_MockMode(String ... mockItemNames) {
        if (mockItemNames == null || mockItemNames.length < 1) {
            return (T)this;
        }
        this.enable_cli_validMockValues = Set.of(mockItemNames);
        return (T)this;
    }

    public <T extends SummerApplication> T enable_CLI_ViewConfig(Class ... cs) {
        for (Class c : cs) {
            this.enable_cli_validConfigs.put(c.getSimpleName(), c);
        }
        return (T)this;
    }

    public <T extends SummerApplication> T enable_Ping_HealthCheck(String contextRoot, String pingPath) {
        return this.enable_Ping_HealthCheck(contextRoot, pingPath, null);
    }

    public <T extends SummerApplication> T enable_Ping_HealthCheck(String contextRoot, String pingPath, Class<? extends HealthInspector> healthInspectorClass) {
        this.enable_ping_healthInspectorClass = healthInspectorClass;
        NioServerContext.setWebApiContextRoot(contextRoot);
        NioServerContext.setLoadBalancerHealthCheckPath(pingPath);
        return (T)this;
    }

    public void run(String[] args, String version) throws Exception {
        this.run(args, version, true);
    }

    public void run(String[] args, String version, boolean startNIO) throws Exception {
        this.init(args, version, startNIO);
        this.start(version, startNIO);
    }

    private void init(String[] args, String version, boolean startNIO) throws Exception {
        BootGuiceModule overrideModule;
        this.version = version;
        callerRootPackageName = ReflectionUtil.getRootPackageName(this.controllerScanRootClass);
        this.runCLI(args, "env", "configuration");
        this.loadBootConfigs();
        this.locadCustomizedConfigs(this.cfgConfigDir);
        BootGuiceModule frameworkModule = new BootGuiceModule(this, this.controllerScanRootClass, startNIO);
        BootGuiceModule bootGuiceModule = overrideModule = this.bindingAppModule == null ? frameworkModule : Modules.override((Module[])new Module[]{frameworkModule}).with(new Module[]{this.bindingAppModule});
        if (this.enable_ping_healthInspectorClass != null || this.bindingChannelHandlerClass != null || this.bindingPostOfficeClass != null) {
            AbstractModule enabledModule = new AbstractModule(){

                protected void configure() {
                    if (SummerApplication.this.enable_ping_healthInspectorClass != null) {
                        this.bind(HealthInspector.class).to(SummerApplication.this.enable_ping_healthInspectorClass);
                    }
                    if (SummerApplication.this.bindingChannelHandlerClass != null) {
                        this.bind(ChannelHandler.class).annotatedWith((Annotation)Names.named((String)SummerApplication.this.bindingChannelHandlerBindingName)).to(SummerApplication.this.bindingChannelHandlerClass);
                    }
                    if (SummerApplication.this.bindingPostOfficeClass != null) {
                        this.bind(PostOffice.class).to(SummerApplication.this.bindingPostOfficeClass);
                    }
                }
            };
            overrideModule = Modules.override((Module[])new Module[]{overrideModule}).with(new Module[]{enabledModule});
        }
        this.iocInjector = Guice.createInjector((Module[])new Module[]{overrideModule});
        NioConfig.setGuiceInjector(this.iocInjector);
        if (this.configChangeListener != null) {
            ConfigUtil.setConfigChangeListener(this.configChangeListener);
        }
    }

    private Path runCLI(String[] args, String envFolderPrefix, String configDirName) throws Exception {
        File folder;
        this.cfgEnvFolderPrefix = envFolderPrefix;
        this.initCLIs_BootApp();
        this.initCLIs_App(this.options);
        this.initCLIs_BootDefault(args);
        this.processCLIs_BootDefault();
        if (this.cli.hasOption(CLI_SHOW_CONFIG)) {
            String cfgName = this.cli.getOptionValue(CLI_SHOW_CONFIG);
            Class c = this.enable_cli_validConfigs.get(cfgName);
            if (c == null) {
                System.err.println(cfgName + "is invalid config option");
                System.exit(1);
            } else {
                String t = BootConfig.generateTemplate(c);
                System.out.println(t);
                System.exit(0);
            }
        }
        I18n.init(this.getAddtionalI18n());
        if (this.cli.hasOption(CLI_I8N)) {
            String language = this.cli.getOptionValue(CLI_I8N);
            this.cfgDefaultRB = Locale.forLanguageTag(language);
        } else {
            this.cfgDefaultRB = null;
        }
        if (this.cli.hasOption(CFG_MONITOR_INTERVAL)) {
            String cmi = this.cli.getOptionValue(CFG_MONITOR_INTERVAL);
            this.CfgMonitorInterval = Integer.parseInt(cmi);
        } else {
            this.CfgMonitorInterval = 5;
        }
        if (this.cli.hasOption("env")) {
            this.envName = this.cli.getOptionValue("env").trim();
            this.cfgConfigDir = ConfigUtil.cfgRoot(this.cfgEnvFolderPrefix, this.envName, configDirName);
            folder = this.cfgConfigDir.toFile();
            if (!folder.isDirectory() || !folder.exists()) {
                System.out.println("Could not find env: " + this.cfgConfigDir.getParent());
                System.exit(1);
            }
        } else if (this.cli.hasOption("domain")) {
            this.cfgEnvFolderPrefix = "standalone";
            this.envName = this.cli.getOptionValue("domain").trim();
            this.cfgConfigDir = ConfigUtil.cfgRoot(this.cfgEnvFolderPrefix, this.envName, configDirName);
            folder = this.cfgConfigDir.toFile();
            if (!folder.isDirectory() || !folder.exists()) {
                System.out.println("Could not find env: " + this.cfgConfigDir.getParent());
                System.exit(1);
            }
        } else {
            this.envName = "prod";
            this.cfgConfigDir = ConfigUtil.cfgRoot(this.cfgEnvFolderPrefix, this.envName, configDirName);
            folder = this.cfgConfigDir.toFile();
            if (!folder.isDirectory() || !folder.exists()) {
                this.cfgEnvFolderPrefix = "standalone";
                this.envName = "release";
                this.cfgConfigDir = ConfigUtil.cfgRoot(this.cfgEnvFolderPrefix, this.envName, configDirName);
                folder = this.cfgConfigDir.toFile();
                if (!folder.isDirectory() || !folder.exists()) {
                    System.out.println("Could not find env: " + this.cfgConfigDir.getParent());
                    System.exit(1);
                }
            }
        }
        System.setProperty("envName", this.envName);
        System.setProperty("domainName", this.envName);
        String log4j2ConfigFile = Paths.get(this.cfgConfigDir.toString(), "log4j2.xml").toString();
        System.setProperty("log4j.configurationFile", log4j2ConfigFile);
        System.out.println(I18n.info.launchingLog.format(this.cfgDefaultRB, System.getProperty("log4j.configurationFile")));
        log = LogManager.getLogger(SummerApplication.class);
        if (this.cli.hasOption(CLI_MOCKMODE)) {
            appMockOptions.clear();
            String[] mockItemList = this.cli.getOptionValues(CLI_MOCKMODE);
            Set<String> mockInputValues = Set.of(mockItemList);
            if (this.enable_cli_validMockValues.containsAll(mockInputValues)) {
                appMockOptions.addAll(mockInputValues);
            } else {
                HashSet<String> invalidOptions = new HashSet<String>(mockInputValues);
                invalidOptions.removeAll(this.enable_cli_validMockValues);
                log.fatal("invalid -mock value: " + FormatterUtil.toCSV(invalidOptions) + ", valid -mock values: " + FormatterUtil.toCSV(this.enable_cli_validMockValues));
                System.exit(1);
            }
        }
        this.processCLIs_BootApp(this.cli);
        this.processCLIs_App(this.cli);
        log.info(() -> I18n.info.launching.format(this.cfgDefaultRB, new String[0]) + ", cmi=" + this.CfgMonitorInterval + ", StartCommand>" + this.getStartCommand());
        return this.cfgConfigDir;
    }

    protected void initCLIs_App(Options options) {
    }

    protected void processCLIs_App(CommandLine cli) {
    }

    private void initCLIs_BootApp() {
        Option arg;
        if (this.enable_cli_errorCodeClass != null) {
            arg = new Option(CLI_ERROR_CODE, false, "list application error code");
            arg.setRequired(false);
            this.options.addOption(arg);
        }
        if (this.enable_cli_poiNameClass != null) {
            arg = new Option(CLI_POI_LIST, false, "list POI names");
            arg.setRequired(false);
            this.options.addOption(arg);
        }
        if (this.enable_cli_validMockValues != null && !this.enable_cli_validMockValues.isEmpty()) {
            String validOptions = FormatterUtil.toCSV(this.enable_cli_validMockValues);
            Option arg2 = Option.builder((String)CLI_MOCKMODE).desc("launch application in mock mode, valid values <" + validOptions + ">").hasArgs().argName("items").build();
            arg2.setArgs(-2);
            arg2.setRequired(false);
            this.options.addOption(arg2);
        }
        arg = Option.builder((String)"env").desc("Start server from " + this.cfgEnvFolderPrefix + "_<name>" + System.lineSeparator() + System.lineSeparator() + "The -env option enables multiple env folders, this is also useful with docker, this -env option tells the application which env to use." + System.lineSeparator() + System.lineSeparator() + "The <env name>: under the application folder there will be one or more folders in the format of env_<env name>, by default there will be env_prod folder, so prod is the env name of this configuration env.").hasArg().argName("name").build();
        this.options.addOption(arg);
        arg = Option.builder((String)"domain").desc("(deprecated, replaced by -env) Start server from standalone_<name>" + System.lineSeparator() + System.lineSeparator() + "The -domain option enables multiple env folders, this is also useful with docker, this -domian option tells the application which env to use." + System.lineSeparator() + System.lineSeparator() + "The <domain name>: under the application folder there will be one or more folders in the format of standalone_<domain name>, by default there will be standalone_release folder only when env_prod folder does not exist, so prod is the env name of this configuration env.").hasArg().argName("name").build();
        this.options.addOption(arg);
        arg = Option.builder((String)CFG_MONITOR_INTERVAL).desc("configuration monitoring interval in second (default 5)").hasArg().argName("interval").build();
        this.options.addOption(arg);
        arg = new Option(CLI_I8N, true, "language <en | fr-CA>");
        arg.setRequired(false);
        this.options.addOption(arg);
        if (this.enable_cli_validConfigs != null && !this.enable_cli_validConfigs.isEmpty()) {
            String validOptions = FormatterUtil.toCSV(this.enable_cli_validConfigs.keySet());
            arg = Option.builder((String)CLI_SHOW_CONFIG).desc("view config sample, valid values <" + validOptions + ">").hasArg().argName("config").build();
            this.options.addOption(arg);
        }
    }

    protected Class getAddtionalI18n() {
        return null;
    }

    private void processCLIs_BootApp(CommandLine cli) throws Exception {
        if (cli.hasOption("encrypt") && cli.hasOption("env")) {
            int updated;
            boolean encrypt = Boolean.parseBoolean(cli.getOptionValue("encrypt"));
            if (!encrypt && cli.hasOption("authfile")) {
                System.err.println(System.lineSeparator() + "\t error: please private password with -auth option when decrypt data");
                System.exit(1);
            }
            if ((updated = this.loadBootConfigs(encrypt ? ConfigUtil.ConfigLoadMode.cli_encrypt : ConfigUtil.ConfigLoadMode.cli_decrypt, null)) > 0) {
                String runtimeEnv = cli.getOptionValue("env").trim();
                System.out.println(System.lineSeparator() + "\t success: config files in env_" + runtimeEnv + " have been " + (encrypt ? "encrypted" : "decrypted"));
            } else {
                System.err.println(System.lineSeparator() + "\t ignored: no config file has been changed");
            }
            System.exit(0);
        }
        try {
            Map sorted;
            if (cli.hasOption(CLI_ERROR_CODE)) {
                Map<Object, Set<String>> duplicated = ApplicationUtil.checkDuplicateFields(this.enable_cli_errorCodeClass, Integer.TYPE);
                if (duplicated.isEmpty()) {
                    HashMap results = new HashMap();
                    ReflectionUtil.loadFields(this.enable_cli_errorCodeClass, Integer.TYPE, results, false);
                    sorted = results.entrySet().stream().sorted(Map.Entry.comparingByValue()).collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey, (e1, e2) -> e1, LinkedHashMap::new));
                    String json = BeanUtil.toJson(sorted, true, false);
                    System.out.println(json);
                } else {
                    String report = BeanUtil.toJson(duplicated, true, false);
                    System.out.println("duplicated.AppErrorCode=" + report);
                }
                System.exit(0);
            } else if (cli.hasOption(CLI_POI_LIST)) {
                Map<Object, Set<String>> duplicated = ApplicationUtil.checkDuplicateFields(this.enable_cli_poiNameClass, String.class);
                if (duplicated.isEmpty()) {
                    HashMap results = new HashMap();
                    ReflectionUtil.loadFields(this.enable_cli_poiNameClass, String.class, results, false);
                    sorted = results.entrySet().stream().sorted(Map.Entry.comparingByValue()).collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey, (e1, e2) -> e1, LinkedHashMap::new));
                    String json = BeanUtil.toJson(sorted, true, false);
                    System.out.println(json);
                } else {
                    String report = BeanUtil.toJson(duplicated, true, false);
                    System.out.println("duplicated.ServicePOI=" + report);
                }
                System.exit(0);
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace(System.err);
        }
    }

    private int loadBootConfigs() throws Exception {
        return this.loadBootConfigs(ConfigUtil.ConfigLoadMode.app_run, this.configChangeListener);
    }

    private int loadBootConfigs(ConfigUtil.ConfigLoadMode mode, ConfigChangeListener cfgChangeListener) throws Exception {
        LinkedHashMap<String, JExpressConfig> configs = new LinkedHashMap<String, JExpressConfig>();
        configs.put("cfg_auth.properties", AuthConfig.CFG);
        configs.put("cfg_http.properties", HttpConfig.CFG);
        configs.put("cfg_nio.properties", NioConfig.CFG);
        configs.put("cfg_smtp.properties", SMTPConfig.CFG);
        int updated = 0;
        try {
            if (this.registeredAppConfigs != null) {
                for (RegisteredAppConfig registeredAppConfig : this.registeredAppConfigs) {
                    if (SummerApplication.isMockMode(registeredAppConfig.mockName) != registeredAppConfig.registerWhenMockIsEnabled) continue;
                    configs.put(registeredAppConfig.configFileName, registeredAppConfig.config);
                }
            }
            updated = ConfigUtil.loadConfigs(mode, log, this.cfgDefaultRB, this.cfgConfigDir, configs, this.CfgMonitorInterval);
            if (cfgChangeListener != null) {
                ConfigUtil.setConfigChangeListener(cfgChangeListener);
            }
        }
        catch (Throwable ex) {
            log.fatal(I18n.info.unlaunched.format(this.cfgDefaultRB, new String[0]), ex);
            System.exit(1);
        }
        return updated;
    }

    protected void locadCustomizedConfigs(Path configFolder) throws Exception {
    }

    private void start(String version, boolean startNIO) throws Exception {
        if (this.postOffice != null) {
            this.postOffice.setAppVersion(version);
        }
        try {
            this.beforeStart(this.cli);
            DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyy-MM-dd E HH:mm:ss");
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                if (this.postOffice != null) {
                    this.postOffice.sendAlertSync(SMTPConfig.CFG.getEmailToAppSupport(), "Shutdown at " + dtf.format(LocalDateTime.now()) + " - " + version, "EOM", null, false);
                }
            }, "ShutdownHook.BootApp"));
            if (this.instrumentationMgr != null) {
                this.instrumentationMgr.start(BootConstant.VERSION);
            }
            StringBuilder sb = new StringBuilder();
            sb.append(System.lineSeparator()).append("Self Inspection Result: ");
            if (this.healthInspector != null) {
                List<Err> errors = this.healthInspector.ping(log);
                if (errors == null || errors.isEmpty()) {
                    sb.append("passed");
                    log.info((CharSequence)sb);
                } else {
                    Object inspectionReport;
                    try {
                        inspectionReport = BeanUtil.toJson(errors, true, true);
                    }
                    catch (Throwable ex) {
                        inspectionReport = "total " + errors.size();
                    }
                    sb.append((String)inspectionReport);
                    if (startNIO) {
                        HealthMonitor.setHealthStatus(false, sb.toString(), this.healthInspector);
                    } else {
                        log.warn((CharSequence)sb);
                    }
                }
            } else {
                sb.append("skipped");
                log.warn((CharSequence)sb);
            }
            if (startNIO) {
                NioServer.bind();
            }
            log.info(() -> I18n.info.launched.format(this.cfgDefaultRB, version + " pid#" + BootConstant.PID));
            String fullConfigInfo = sb.toString();
            if (this.postOffice != null) {
                this.postOffice.sendAlertAsync(SMTPConfig.CFG.getEmailToAppSupport(), "Started at " + dtf.format(LocalDateTime.now()), fullConfigInfo, null, false);
            }
        }
        catch (Throwable ex) {
            log.fatal(I18n.info.unlaunched.format(this.cfgDefaultRB, new String[0]), ex);
            System.exit(1);
        }
    }

    protected abstract void beforeStart(CommandLine var1) throws Exception;

    protected boolean isJMXRequired() {
        if (this.jmxRequired != null) {
            return this.jmxRequired;
        }
        this.jmxRequired = false;
        List<String> vmArguments = ManagementFactory.getRuntimeMXBean().getInputArguments();
        for (String arg : vmArguments) {
            if (!arg.contains("com.sun.management.jmxremote.port")) continue;
            this.jmxRequired = true;
            break;
        }
        return this.jmxRequired;
    }

    private String getStartCommand() {
        String OS = System.getProperty("os.name").toLowerCase();
        boolean isWindows = OS.contains("win");
        String java = System.getProperty("java.home") + "/bin/java";
        List<String> vmArguments = ManagementFactory.getRuntimeMXBean().getInputArguments();
        StringBuffer vmArgsOneLine = new StringBuffer();
        for (String arg : vmArguments) {
            if (!arg.contains("-agentlib")) {
                vmArgsOneLine.append(arg);
                vmArgsOneLine.append(" ");
            }
            if (!arg.contains("com.sun.management.jmxremote.port")) continue;
            this.jmxRequired = true;
        }
        StringBuilder cmd = isWindows ? new StringBuilder("\"" + java + "\" " + vmArgsOneLine) : new StringBuilder(java + " " + vmArgsOneLine);
        String[] mainCommand = System.getProperty(SUN_JAVA_COMMAND).split(" ");
        if (mainCommand[0].endsWith(".jar")) {
            cmd.append("-jar ").append(new File(mainCommand[0]).getPath());
        } else {
            cmd.append("-cp \"").append(System.getProperty("java.class.path")).append("\" ").append(mainCommand[0]);
        }
        for (int i = 1; i < mainCommand.length; ++i) {
            cmd.append(" ");
            cmd.append(mainCommand[i]);
        }
        return cmd.toString();
    }

    static {
        appMockOptions = new HashSet<String>();
    }

    private class RegisteredAppConfig {
        final String configFileName;
        final JExpressConfig config;
        final String mockName;
        final boolean registerWhenMockIsEnabled;

        public RegisteredAppConfig(String configFileName, JExpressConfig config, String mockName, boolean registerWhenMockIsEnabled) {
            this.configFileName = configFileName;
            this.config = config;
            this.mockName = mockName;
            this.registerWhenMockIsEnabled = registerWhenMockIsEnabled;
        }
    }
}

