/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.boot.cli;

import io.jsonwebtoken.SignatureAlgorithm;
import java.io.FileInputStream;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.summerboot.jexpress.boot.BootConstant;
import org.summerboot.jexpress.security.EncryptorUtil;
import org.summerboot.jexpress.security.JwtUtil;
import org.summerboot.jexpress.security.SecurityUtil;

public abstract class BootCLI {
    protected static final String USAGE = "?";
    protected static final String VERSION = "version";
    protected static final String ADMIN_PWD_FILE = "authfile";
    protected static final String ADMIN_PWD = "auth";
    protected static final String JWT = "jwt";
    protected static final String ENCRYPT = "encrypt";
    protected static final String DOMAIN = "domain";
    protected static final String ENV = "env";
    protected CommandLine cli;
    protected final HelpFormatter formatter = new HelpFormatter();
    protected final Options options = new Options();
    protected String version = BootConstant.VERSION;

    protected final CommandLine initCLIs_BootDefault(String[] args) {
        Option arg = Option.builder((String)USAGE).desc("Usage/Help").build();
        this.options.addOption(arg);
        arg = Option.builder((String)VERSION).desc("check framework version").build();
        this.options.addOption(arg);
        arg = Option.builder((String)ADMIN_PWD_FILE).desc("Specify an application config password in a file instead of the default one." + System.lineSeparator() + "Note: Unlike the -auth opton, this option protects the app config password from being exposed via ps command." + System.lineSeparator() + "The file should contains a line with the format as: APP_ROOT_PASSWORD=<my app config password>").hasArg().argName("file").build();
        this.options.addOption(arg);
        arg = Option.builder((String)ADMIN_PWD).desc("Specify an application config password instead of the default one." + System.lineSeparator() + "Note: This option exposes the app config password via ps command").hasArg().argName("password").build();
        this.options.addOption(arg);
        arg = Option.builder((String)JWT).desc("generate JWT root signing key with the specified algorithm <HS256, HS384, HS512>").hasArg().argName("algorithm").build();
        this.options.addOption(arg);
        arg = Option.builder((String)ENCRYPT).desc("Encrypt the given password via application config password." + System.lineSeparator() + System.lineSeparator() + "1. Manual Batch Encrypt mode - the commands below encrypt all values in the format of \"DEC(plain text)\" in the specified configuration env:" + System.lineSeparator() + System.lineSeparator() + "\t -env <env name> -encrypt true -authfile <path to a file which contains config password>" + System.lineSeparator() + System.lineSeparator() + "\t java -jar app.jar -env <env name>  -encrypt true -auth <my app config password>" + System.lineSeparator() + System.lineSeparator() + "2. Manual Batch Decrypt mode - the command below decrypts all values in the format of \"ENC(encrypted text)\" in the specified configuration env:" + System.lineSeparator() + System.lineSeparator() + "t java -jar app.jar  -env <env name>  -encrypt false -auth <my app config password>" + System.lineSeparator() + System.lineSeparator() + "3. Manual Encrypt mode - In case you want to manually verify an encrypted sensitive data,  use the command below, compare the output with the encrypted value in the config file:" + System.lineSeparator() + System.lineSeparator() + "\t  -encrypt <plain text> -auth <my app config password>").hasArg().build();
        this.options.addOption(arg);
        try {
            DefaultParser parser = new DefaultParser();
            this.cli = parser.parse(this.options, args);
        }
        catch (ParseException ex) {
            System.out.println(ex.getMessage());
            this.formatter.printHelp(this.version, this.options);
            System.exit(1);
        }
        return this.cli;
    }

    protected final void processCLIs_BootDefault() {
        if (this.cli.hasOption(USAGE)) {
            this.formatter.printHelp(this.version, this.options);
            System.exit(0);
        }
        if (this.cli.hasOption(VERSION)) {
            System.out.println(this.version);
            System.exit(0);
        }
        if (this.cli.hasOption(ADMIN_PWD_FILE)) {
            String adminPwdFile = this.cli.getOptionValue(ADMIN_PWD_FILE);
            Properties props = new Properties();
            try (FileInputStream is = new FileInputStream(adminPwdFile);){
                props.load(is);
            }
            catch (Throwable ex) {
                throw new RuntimeException("failed to load " + adminPwdFile, ex);
            }
            String adminPwd = props.getProperty("APP_ROOT_PASSWORD");
            adminPwd = SecurityUtil.base64Decode(adminPwd);
            EncryptorUtil.init(adminPwd);
        } else if (this.cli.hasOption(ADMIN_PWD)) {
            String adminPwd = this.cli.getOptionValue(ADMIN_PWD);
            EncryptorUtil.init(adminPwd);
        }
        if (this.cli.hasOption(JWT)) {
            String algorithm = this.cli.getOptionValue(JWT);
            SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.forName((String)algorithm);
            String jwt = JwtUtil.buildSigningKey(signatureAlgorithm);
            System.out.println(jwt);
            System.exit(0);
        }
        try {
            if (this.cli.hasOption(ENCRYPT) && !this.cli.hasOption(ENV)) {
                String plainPwd = this.cli.getOptionValue(ENCRYPT);
                String encryptedPwd = SecurityUtil.encrypt(plainPwd, false);
                System.out.println(encryptedPwd);
                System.exit(0);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(-1);
        }
    }
}

