/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.boot.config;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.tika.utils.ExceptionUtils;
import org.summerboot.jexpress.boot.config.ConfigUtil;
import org.summerboot.jexpress.boot.config.JExpressConfig;
import org.summerboot.jexpress.boot.config.annotation.Config;
import org.summerboot.jexpress.boot.config.annotation.Memo;
import org.summerboot.jexpress.security.SecurityUtil;
import org.summerboot.jexpress.util.BeanUtil;
import org.summerboot.jexpress.util.ReflectionUtil;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
public abstract class BootConfig
implements JExpressConfig {
    @JsonIgnore
    protected volatile Logger log = null;
    protected File cfgFile;
    protected String configName = this.getClass().getSimpleName();

    @Override
    public String name() {
        return this.configName;
    }

    @Override
    public File getCfgFile() {
        return this.cfgFile;
    }

    @Override
    public JExpressConfig temp() {
        Constructor<?>[] css;
        JExpressConfig ret = null;
        Class<?> c = this.getClass();
        for (Constructor<?> cs : css = c.getDeclaredConstructors()) {
            cs.setAccessible(true);
            int pc = cs.getParameterCount();
            if (pc == 0) {
                try {
                    ret = (JExpressConfig)cs.newInstance(new Object[0]);
                    return ret;
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                    continue;
                }
            }
            Object[] params = new Object[pc];
            try {
                ret = (JExpressConfig)cs.newInstance(params);
                return ret;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return ret;
    }

    @Override
    public String info() {
        try {
            return BeanUtil.toJson(this, true, false);
        }
        catch (JsonProcessingException ex) {
            return ex.toString();
        }
    }

    @Override
    public void load(File cfgFile, boolean isReal) throws IOException {
        if (this.log == null) {
            this.log = LogManager.getLogger(this.getClass());
        }
        String configFolder = cfgFile.getParent();
        this.cfgFile = cfgFile.getAbsoluteFile();
        if (this.configName == null) {
            this.configName = cfgFile.getName();
        }
        Properties props = new Properties();
        try (FileInputStream is = new FileInputStream(cfgFile);
             InputStreamReader isr = new InputStreamReader((InputStream)is, StandardCharsets.UTF_8);){
            props.load(isr);
        }
        ConfigUtil helper = new ConfigUtil(this.cfgFile.getAbsolutePath());
        Class<?> c = this.getClass();
        Field[] fields = c.getDeclaredFields();
        boolean autoDecrypt = true;
        for (Field field : fields) {
            try {
                this.loadField(field, configFolder, helper, props, autoDecrypt);
            }
            catch (NullPointerException ex) {
                ex.printStackTrace();
            }
            catch (Throwable ex) {
                String key = field.getAnnotation(Config.class).key();
                Class<?> expectedType = field.getType();
                helper.addError("invalid \"" + key + "\" - " + expectedType + ", error=" + ex);
            }
        }
        try {
            this.loadCustomizedConfigs(cfgFile, isReal, helper, props);
        }
        catch (Throwable ex) {
            helper.addError("failed to init customized configs:" + ExceptionUtils.getStackTrace((Throwable)ex));
        }
        String error2 = helper.getError();
        if (error2 != null) {
            throw new IllegalArgumentException(error2);
        }
    }

    protected abstract void loadCustomizedConfigs(File var1, boolean var2, ConfigUtil var3, Properties var4) throws Exception;

    protected void loadField(Field field, String configFolder, ConfigUtil helper, Properties props, boolean autoDecrypt) throws IllegalAccessException {
        Config.Validate validate;
        boolean isEncrypted;
        Config configSettings = field.getAnnotation(Config.class);
        if (configSettings == null) {
            return;
        }
        String key = configSettings.key();
        Object value = props.getProperty(key);
        field.setAccessible(true);
        if (StringUtils.isBlank((CharSequence)value)) {
            String defaultValue = configSettings.defaultValue();
            boolean hasDefaultValue = StringUtils.isNotBlank((CharSequence)defaultValue);
            if (hasDefaultValue) {
                value = defaultValue;
            } else {
                if (configSettings.required()) {
                    helper.addError("missing \"" + key + "\"");
                } else {
                    Object nullValue = ReflectionUtil.toStandardJavaType(null, field.getType(), false, false, null);
                    field.set(this, nullValue);
                }
                return;
            }
        }
        if (isEncrypted = (validate = configSettings.validate()).equals((Object)Config.Validate.Encrypted)) {
            if (((String)value).startsWith("ENC(") && ((String)value).endsWith(")")) {
                try {
                    value = SecurityUtil.decrypt((String)value, true);
                }
                catch (GeneralSecurityException ex) {
                    throw new IllegalArgumentException("Failed to decrypt", ex);
                }
            } else {
                helper.addError("invalid \"" + key + "\" - require encrypted format, missing warpper: ENC(encrypted value)");
                return;
            }
        }
        boolean isEmailRecipients = validate.equals((Object)Config.Validate.EmailRecipients);
        Class<?> fieldClass = field.getType();
        if (fieldClass.equals(KeyManagerFactory.class)) {
            String key_storeFile = key;
            String key_storePwd = configSettings.StorePwdKey();
            String key_keyAlias = configSettings.AliasKey();
            String key_keyPwd = configSettings.AliasPwdKey();
            KeyManagerFactory kmf = helper.getAsKeyManagerFactory(props, configFolder, key_storeFile, key_storePwd, key_keyAlias, key_keyPwd);
            field.set(this, kmf);
        } else if (fieldClass.equals(TrustManagerFactory.class)) {
            String key_storeFile = key;
            String key_storePwd = configSettings.StorePwdKey();
            TrustManagerFactory tmf = helper.getAsTrustManagerFactory(props, configFolder, key_storeFile, key_storePwd);
            field.set(this, tmf);
        } else {
            File file;
            if (value != null && (fieldClass.equals(File.class) || fieldClass.equals(Path.class)) && !(file = new File((String)value)).isAbsolute()) {
                value = configFolder + File.separator + (String)value;
            }
            ReflectionUtil.loadField(this, field, (String)value, autoDecrypt, isEmailRecipients);
        }
    }

    protected String updateFilePath(File domainDir, String fileName) {
        if (StringUtils.isBlank((CharSequence)fileName)) {
            return fileName;
        }
        if (fileName.startsWith(File.separator)) {
            return new File(fileName).getAbsolutePath();
        }
        return new File(domainDir.getAbsolutePath() + File.separator + fileName).getAbsolutePath();
    }

    public void updateConfigFile(Map<String, String> updatedCfgs) throws IOException {
        if (updatedCfgs == null || updatedCfgs.isEmpty()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        LineIterator iterator = FileUtils.lineIterator((File)new File(this.cfgFile.getAbsolutePath()), (String)"UTf-8");
        while (iterator.hasNext()) {
            String key;
            int i;
            Object line = iterator.nextLine().trim();
            if (!((String)line).startsWith("#") && (i = ((String)line).indexOf("=")) > 0 && updatedCfgs.containsKey(key = ((String)line).substring(0, i).trim())) {
                line = key + "=" + updatedCfgs.get(key);
            }
            sb.append((String)line).append(System.lineSeparator());
        }
        try (FileOutputStream output = new FileOutputStream(this.cfgFile);
             FileChannel foc = output.getChannel();){
            foc.write(ByteBuffer.wrap(sb.toString().getBytes(StandardCharsets.UTF_8)));
        }
    }

    public static String generateTemplate(Class c) {
        Field[] fields;
        StringBuilder sb = new StringBuilder();
        for (Field field : fields = c.getDeclaredFields()) {
            String[] keys;
            Config cfg;
            Memo memo = field.getAnnotation(Memo.class);
            if (memo != null) {
                List<String> list = BootConfig.parse(memo);
                int maxSize = 0;
                for (String s : list) {
                    maxSize = Math.max(maxSize, BootConfig.getLength(s));
                }
                maxSize += 2;
                sb.append("\n\n");
                for (int i = 0; i < maxSize; ++i) {
                    sb.append("#");
                }
                sb.append("\n");
                for (String s : list) {
                    sb.append(s);
                    int size = maxSize - s.length() - 1;
                    for (int i = 0; i < size; ++i) {
                        sb.append(" ");
                    }
                    sb.append("#").append("\n");
                }
                for (int i = 0; i < maxSize; ++i) {
                    sb.append("#");
                }
                sb.append("\n");
            }
            if ((cfg = field.getAnnotation(Config.class)) == null) continue;
            boolean isEncrypted = cfg.validate().equals((Object)Config.Validate.Encrypted);
            String cm = cfg.desc();
            if (StringUtils.isNotBlank((CharSequence)cm)) {
                ArrayList<String> memoList = new ArrayList<String>();
                BootConfig.lineBreak(cm, null, memoList);
                for (String s : memoList) {
                    sb.append("#").append(s).append("\n");
                }
            }
            boolean isRequired = cfg.required();
            boolean hasDefaultValue = false;
            String dv = cfg.defaultValue();
            if (StringUtils.isNotBlank((CharSequence)dv)) {
                hasDefaultValue = true;
            }
            if (!isRequired || hasDefaultValue) {
                sb.append("#");
            }
            String key = cfg.key();
            sb.append(key).append("=");
            if (isEncrypted) {
                sb.append("DEC(");
            }
            if (hasDefaultValue) {
                sb.append(dv);
            }
            if (isEncrypted) {
                sb.append(")");
            }
            sb.append("\n");
            int i = 0;
            for (String skey : keys = new String[]{cfg.StorePwdKey(), cfg.AliasKey(), cfg.AliasPwdKey()}) {
                if (StringUtils.isNotBlank((CharSequence)skey)) {
                    if (!isRequired) {
                        sb.append("#");
                    }
                    sb.append(skey).append("=");
                    if (i == 0 || i == 2) {
                        sb.append("DEC()");
                    }
                    sb.append("\n");
                }
                ++i;
            }
            if (!StringUtils.isNotBlank((CharSequence)cm)) continue;
            sb.append("\n");
        }
        return sb.toString();
    }

    private static List<String> parse(Memo memo) {
        ArrayList<String> ret = new ArrayList<String>();
        BootConfig.lineBreak(memo.title(), null, ret);
        BootConfig.lineBreak(memo.desc(), null, ret);
        BootConfig.lineBreak(memo.format(), "Format: ", ret);
        BootConfig.lineBreak(memo.example(), "Example: ", ret);
        return ret;
    }

    /*
     * WARNING - void declaration
     */
    private static String[] lineBreak(String s, String prefix, List<String> list) {
        if (StringUtils.isBlank((CharSequence)s)) {
            return null;
        }
        String[] ret = s.trim().split("\\r?\\n");
        if (ret != null) {
            for (String string : ret) {
                void var7_11;
                if (string == null) continue;
                if (StringUtils.isBlank((CharSequence)prefix)) {
                    String string2 = string.trim();
                } else {
                    String string3 = prefix + string.trim();
                }
                list.add("# " + (String)var7_11);
            }
        }
        return ret;
    }

    private static int getLength(String s) {
        return StringUtils.isBlank((CharSequence)s) ? 0 : s.trim().length();
    }
}

