/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.boot.instrumentation;

import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.summerboot.jexpress.boot.instrumentation.HealthInspector;
import org.summerboot.jexpress.nio.server.NioConfig;
import org.summerboot.jexpress.nio.server.domain.Err;
import org.summerboot.jexpress.util.BeanUtil;

public class HealthMonitor {
    private static final Logger log = LogManager.getLogger((String)HealthMonitor.class.getName());
    private static final ThreadPoolExecutor POOL_HealthInspector = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(1), Executors.defaultThreadFactory(), new ThreadPoolExecutor.DiscardPolicy());
    public static final String PROMPT = "Self Inspection Result: ";
    private static boolean healthOk;
    private static boolean paused;
    private static String statusReason;
    private static boolean serviceAvaliable;

    private static void startHealthInspectionSingleton(int inspectionIntervalSeconds, HealthInspector healthInspector) {
        if (healthInspector == null || inspectionIntervalSeconds < 1) {
            log.debug(() -> "HealthInspection Skipped: healthInspector=" + healthInspector + ", inspectionIntervalSeconds=" + inspectionIntervalSeconds);
            return;
        }
        long i = HealthInspector.healthInspectorCounter.incrementAndGet();
        if (i > 1L) {
            log.debug(() -> "Duplicated HealthInspection Rejected: total=" + i);
            return;
        }
        Runnable asyncTask = () -> {
            boolean inspectionFailed;
            HealthInspector.healthInspectorCounter.incrementAndGet();
            do {
                StringBuilder sb = new StringBuilder();
                sb.append(System.lineSeparator()).append(PROMPT);
                List<Err> errors = healthInspector.ping(new Object[0]);
                boolean bl = inspectionFailed = errors != null && !errors.isEmpty();
                if (inspectionFailed) {
                    Object inspectionReport;
                    try {
                        inspectionReport = BeanUtil.toJson(errors, true, true);
                    }
                    catch (Throwable ex) {
                        inspectionReport = "total " + ex;
                    }
                    sb.append((String)inspectionReport);
                    sb.append(System.lineSeparator()).append(", will inspect again in ").append(inspectionIntervalSeconds).append(" seconds");
                    log.warn((CharSequence)sb);
                    try {
                        TimeUnit.SECONDS.sleep(inspectionIntervalSeconds);
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                    }
                    continue;
                }
                sb.append("passed");
                HealthMonitor.setHealthStatus(true, sb.toString(), null);
            } while (inspectionFailed);
            HealthInspector.healthInspectorCounter.set(0L);
        };
        if (POOL_HealthInspector.getActiveCount() < 1) {
            try {
                POOL_HealthInspector.execute(asyncTask);
            }
            catch (RejectedExecutionException ex2) {
                log.debug(() -> "Duplicated HealthInspection Rejected: " + ex2);
            }
        } else {
            log.debug("HealthInspection Skipped");
        }
    }

    public static void setHealthStatus(boolean newStatus, String reason, HealthInspector healthInspector) {
        HealthMonitor.setHealthStatus(newStatus, reason, healthInspector, NioConfig.CFG.getHealthInspectionIntervalSeconds());
    }

    public static void setHealthStatus(boolean newStatus, String reason, HealthInspector healthInspector, int healthInspectionIntervalSeconds) {
        boolean serviceStatusChanged = healthOk != newStatus;
        healthOk = newStatus;
        HealthMonitor.updateServiceStatus(serviceStatusChanged, reason);
        if (!healthOk && healthInspector != null) {
            HealthMonitor.startHealthInspectionSingleton(healthInspectionIntervalSeconds, healthInspector);
        }
    }

    public static void setPauseStatus(boolean newStatus, String reason) {
        boolean serviceStatusChanged = paused != newStatus;
        paused = newStatus;
        HealthMonitor.updateServiceStatus(serviceStatusChanged, reason);
    }

    private static void updateServiceStatus(boolean serviceStatusChanged, String reason) {
        statusReason = reason;
        boolean bl = serviceAvaliable = healthOk && !paused;
        if (serviceStatusChanged) {
            log.log(healthOk ? Level.WARN : Level.FATAL, "\n\t server status changed: paused=" + paused + ", OK=" + healthOk + ", serviceAvaliable=" + serviceAvaliable + "\n\t reason: " + reason);
        }
    }

    public static boolean isServicePaused() {
        return paused;
    }

    public static boolean isServiceStatusOk() {
        return healthOk;
    }

    public static boolean isServiceAvaliable() {
        return serviceAvaliable;
    }

    public static String getServiceStatusReason() {
        return statusReason;
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> POOL_HealthInspector.shutdown(), "ShutdownHook.HealthInspector"));
        healthOk = true;
        paused = false;
        serviceAvaliable = true;
    }
}

