/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.i18n;

import java.lang.reflect.Field;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import org.apache.commons.lang3.StringUtils;
import org.summerboot.jexpress.i18n.AppResourceBundle;

public class I18nLabel {
    private final String code;
    private String key;
    private final boolean critical;
    private final String[] values;

    public I18nLabel(String code, boolean critical, String ... values) {
        this.code = code;
        this.values = values;
        this.critical = critical;
        this.key = code;
    }

    public I18nLabel(String ... values) {
        this.code = null;
        this.values = values;
        this.critical = false;
        this.key = this.code;
    }

    public String getCode() {
        return this.code;
    }

    public boolean isCritical() {
        return this.critical;
    }

    public String getKey() {
        return this.key;
    }

    public String format(ResourceBundle rb, String ... args) {
        String error2;
        String string = error2 = rb == null ? this.values[0] : rb.getString(this.key);
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                if (args[i] == null) {
                    args[i] = "";
                }
                error2 = error2.replaceAll("%ARG" + (i + 1) + "%", Matcher.quoteReplacement(args[i]));
            }
        }
        return error2;
    }

    public String format(Locale locale, String ... args) {
        AppResourceBundle rb = locale == null ? null : AppResourceBundle.getAppBundle(locale.toLanguageTag());
        return this.format(rb, args);
    }

    public String format(String languageTag, String ... args) {
        AppResourceBundle rb = AppResourceBundle.getAppBundle(languageTag);
        return this.format(rb, args);
    }

    public static void buildTranslationsMap(String rootPrefix, Class rootI18nClass, int translationIndex, Map<String, String> translationsMapping) {
        Class<?>[] memberInterfaces;
        Field[] fields;
        if (!rootI18nClass.isInterface()) {
            return;
        }
        String sn = rootI18nClass.getSimpleName();
        Object snPrefix = StringUtils.isBlank((CharSequence)rootPrefix) ? sn : rootPrefix + "_" + sn;
        for (Field field : fields = rootI18nClass.getDeclaredFields()) {
            try {
                String value;
                Class<?> type = field.getType();
                if (!I18nLabel.class.equals(type)) continue;
                String verName = (String)snPrefix + "_" + field.getName();
                I18nLabel lb = (I18nLabel)field.get(null);
                lb.key = verName;
                if (translationIndex >= lb.values.length || StringUtils.isBlank((CharSequence)(value = lb.values[translationIndex]))) continue;
                translationsMapping.put(lb.key, value);
            }
            catch (IllegalAccessException | IllegalArgumentException ex) {
                ex.printStackTrace();
            }
        }
        for (Class<?> c : memberInterfaces = rootI18nClass.getDeclaredClasses()) {
            I18nLabel.buildTranslationsMap((String)snPrefix, c, translationIndex, translationsMapping);
        }
    }
}

