/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.integration.db;

import jakarta.persistence.Column;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.PreUpdate;
import jakarta.persistence.Version;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.Objects;

@MappedSuperclass
public abstract class AbstractEntity
implements Serializable {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    protected Long id;
    @Version
    @Column(name="version")
    protected int version;
    @Column(name="createdTs", nullable=false, updatable=false)
    protected OffsetDateTime createdTs = OffsetDateTime.now();
    @Column(name="updatedTs", nullable=false, updatable=true)
    protected OffsetDateTime updatedTs = OffsetDateTime.now();

    protected AbstractEntity() {
    }

    @PreUpdate
    protected void updateTimestamp() {
        this.updatedTs = OffsetDateTime.now();
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public OffsetDateTime getCreatedTs() {
        return this.createdTs;
    }

    public void setCreatedTs(OffsetDateTime createdTs) {
        this.createdTs = createdTs;
    }

    public OffsetDateTime getUpdatedTs() {
        return this.updatedTs;
    }

    public void setUpdatedTs(OffsetDateTime updatedTs) {
        this.updatedTs = updatedTs;
    }

    public int hashCode() {
        int hash = 5;
        hash = 97 * hash + Objects.hashCode(this.id);
        hash = 97 * hash + this.version;
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractEntity other = (AbstractEntity)obj;
        if (this.version != other.version) {
            return false;
        }
        return Objects.equals(this.id, other.id);
    }
}

