/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.integration.db;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonProcessingException;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hibernate.SessionFactory;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.service.ServiceRegistry;
import org.summerboot.jexpress.boot.SummerApplication;
import org.summerboot.jexpress.boot.config.ConfigUtil;
import org.summerboot.jexpress.boot.config.JExpressConfig;
import org.summerboot.jexpress.util.BeanUtil;
import org.summerboot.jexpress.util.FormatterUtil;
import org.summerboot.jexpress.util.ReflectionUtil;

public class JPAHibernateConfig
implements JExpressConfig {
    private static volatile Logger log = null;
    public static final JPAHibernateConfig CFG = new JPAHibernateConfig();
    @JsonIgnore
    private volatile SessionFactory sessionFactory;
    private File cfgFile;
    private final Properties props = new Properties();
    private final Map<String, Object> settings = new HashMap<String, Object>();
    private volatile List<Class<?>> entityClasses = new ArrayList();

    @Override
    public File getCfgFile() {
        return this.cfgFile;
    }

    @Override
    public String name() {
        return "DB Config";
    }

    @Override
    public String info() {
        try {
            return BeanUtil.toJson(this, true, false);
        }
        catch (JsonProcessingException ex) {
            return ex.toString();
        }
    }

    @Override
    public JExpressConfig temp() {
        return new JPAHibernateConfig();
    }

    @Override
    public void load(File cfgFile, boolean isReal) throws IOException, GeneralSecurityException {
        this.load(cfgFile, new String[0]);
    }

    public void load(File cfgFile, String ... packages) throws IOException, GeneralSecurityException {
        if (log == null) {
            log = LogManager.getLogger(this.getClass());
        }
        this.cfgFile = cfgFile.getAbsoluteFile();
        try (FileInputStream is = new FileInputStream(cfgFile);){
            this.props.load(is);
        }
        this.settings.clear();
        ConfigUtil helper = new ConfigUtil(this.cfgFile.getAbsolutePath());
        Set<Object> keys = this.props.keySet();
        keys.forEach(key -> {
            String name = key.toString();
            this.settings.put(name, this.props.getProperty(name));
        });
        this.settings.put("hibernate.connection.password", helper.getAsPassword(this.props, "hibernate.connection.password"));
        String error2 = helper.getError();
        if (error2 != null) {
            throw new IllegalArgumentException(error2);
        }
        String callerRootPackageName = SummerApplication.getCallerRootPackageName();
        String _rootPackageNames = callerRootPackageName + "," + this.props.getProperty("hibernate.loaded_classes", "");
        log.debug("_rootPackageNames={}", (Object)_rootPackageNames);
        String[] rootPackageNames = FormatterUtil.parseCsv(_rootPackageNames);
        List<Object> rootPackageNameList = new ArrayList<String>();
        rootPackageNameList.addAll(Arrays.asList(rootPackageNames));
        rootPackageNameList.addAll(Arrays.asList(packages));
        rootPackageNameList = rootPackageNameList.stream().distinct().collect(Collectors.toList());
        rootPackageNameList.removeAll(Collections.singleton(""));
        rootPackageNameList.removeAll(Collections.singleton(null));
        log.debug("rootPackageNameList:{}", rootPackageNameList);
        for (String string : rootPackageNameList) {
            Set<Class<?>> tempEntityClasses = ReflectionUtil.getAllImplementationsByAnnotation(Entity.class, string);
            this.entityClasses.addAll(tempEntityClasses);
        }
        SessionFactory old = this.sessionFactory;
        StandardServiceRegistryBuilder standardServiceRegistryBuilder = new StandardServiceRegistryBuilder();
        standardServiceRegistryBuilder.applySettings(this.settings);
        StandardServiceRegistry registry = standardServiceRegistryBuilder.build();
        MetadataSources sources = new MetadataSources((ServiceRegistry)registry);
        this.entityClasses.forEach(arg_0 -> ((MetadataSources)sources).addAnnotatedClass(arg_0));
        Metadata metadata = sources.getMetadataBuilder().build();
        this.sessionFactory = metadata.getSessionFactoryBuilder().build();
        if (old != null) {
            log.warn("close current db connection due to config changed");
            try {
                old.close();
            }
            catch (Throwable ex) {
                log.warn("failed to close current db connection", ex);
            }
        }
        if (this.settings.get("hibernate.connection.password") != null) {
            this.settings.put("hibernate.connection.password", "****");
        }
    }

    @Override
    public void shutdown() {
        System.out.println(Thread.currentThread().getName() + ": shutdown DB.SessionFactory");
        if (this.sessionFactory != null) {
            try {
                this.sessionFactory.close();
            }
            catch (Throwable ex) {
                ex.printStackTrace(System.err);
            }
        }
    }

    public Map<String, Object> getSettings() {
        return this.settings;
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public EntityManager em() {
        return this.sessionFactory.createEntityManager();
    }

    public String getProperty(String key) {
        return this.props.getProperty(key);
    }

    public List<Class<?>> getEntityClasses() {
        return this.entityClasses;
    }
}

