/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.integration.smtp;

import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import jakarta.mail.Address;
import jakarta.mail.BodyPart;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.Session;
import jakarta.mail.Transport;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import jakarta.mail.util.ByteArrayDataSource;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.summerboot.jexpress.integration.smtp.SMTPConfig;

public class Email {
    private String from;
    private Set<String> toList;
    private Set<String> ccList;
    private Set<String> bccList;
    private String subject;
    private String body;
    private Format format;
    private List<Attachment> attachments;

    public static Email compose(String subject, String body, Format format) {
        return new Email(subject, body, format);
    }

    private Email(String subject, String body, Format format) {
        this.subject = subject;
        this.body = body;
        this.format = format;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\n\t from=").append(this.from).append("\n\t to=").append(this.toList).append("\n\t cc=").append(this.ccList).append("\n\t bcc=").append(this.bccList).append("\n\t subject=").append(this.subject).append("\n\t format=").append((Object)this.format).append("\n\t body=").append(this.body);
        return sb.toString();
    }

    public String from() {
        return this.from;
    }

    public Email from(String userEmailTitle, String userEmailAddr) {
        this.from = userEmailTitle == null ? userEmailAddr : userEmailTitle + " <" + userEmailAddr + ">";
        return this;
    }

    public Email from(String email) {
        this.from = email;
        return this;
    }

    public Set<String> to() {
        return this.toList;
    }

    public Email to(Collection<String> recipients) {
        if (recipients == null || recipients.isEmpty()) {
            return this;
        }
        this.toList = new HashSet<String>(recipients);
        return this;
    }

    public Email to(String ... recipients) {
        if (recipients != null && recipients.length > 0) {
            this.toList = Set.of(recipients);
        }
        return this;
    }

    public Set<String> cc() {
        return this.ccList;
    }

    public Email cc(Collection<String> recipients) {
        if (recipients == null || recipients.isEmpty()) {
            return this;
        }
        this.ccList = new HashSet<String>(recipients);
        return this;
    }

    public Email cc(String ... recipients) {
        if (recipients != null && recipients.length > 0) {
            this.ccList = Set.of(recipients);
        }
        return this;
    }

    public Set<String> bcc() {
        return this.bccList;
    }

    public Email bcc(Collection<String> recipients) {
        if (recipients == null || recipients.isEmpty()) {
            return this;
        }
        this.bccList = new HashSet<String>(recipients);
        return this;
    }

    public Email bcc(String ... recipients) {
        if (recipients != null && recipients.length > 0) {
            this.bccList = Set.of(recipients);
        }
        return this;
    }

    public String subject() {
        return this.subject;
    }

    public Email subject(String subject) {
        this.subject = subject == null ? "" : subject;
        return this;
    }

    public String body() {
        return this.body;
    }

    public Email body(String body) {
        this.body = body;
        return this;
    }

    public Format format() {
        return this.format;
    }

    public Email format(Format format) {
        this.format = format;
        return this;
    }

    public List<Attachment> attachments() {
        return this.attachments;
    }

    public Email attachment(Attachment att) {
        if (this.attachments == null) {
            this.attachments = new ArrayList<Attachment>();
        }
        this.attachments.add(att);
        return this;
    }

    public Email clearAttachments() {
        this.attachments.clear();
        return this;
    }

    public void send(Session emailSession) throws MessagingException {
        MimeMessage msg = this.buildMimeMessage(emailSession);
        if (msg != null) {
            Transport.send((Message)msg);
        }
    }

    public void send() throws MessagingException {
        MimeMessage msg = this.buildMimeMessage();
        if (msg != null) {
            Transport.send((Message)msg);
        }
    }

    public MimeMessage buildMimeMessage() throws MessagingException {
        return this.buildMimeMessage(SMTPConfig.CFG.getMailSession());
    }

    public MimeMessage buildMimeMessage(Session emailSession) throws MessagingException {
        Email email = this;
        if (emailSession == null || email == null) {
            return null;
        }
        MimeMessage message = new MimeMessage(emailSession);
        if (StringUtils.isBlank((CharSequence)email.from())) {
            email.from(emailSession.getProperty("mail.smtp.userName"), emailSession.getProperty("mail.smtp.user"));
        }
        message.setFrom((Address)new InternetAddress(email.from()));
        if (email.to() != null) {
            for (String to : email.to()) {
                message.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(to));
            }
        }
        if (email.cc() != null) {
            for (String cc : email.cc()) {
                message.addRecipient(Message.RecipientType.CC, (Address)new InternetAddress(cc));
            }
        }
        if (email.bcc() != null) {
            for (String bcc : email.bcc()) {
                message.addRecipient(Message.RecipientType.BCC, (Address)new InternetAddress(bcc));
            }
        }
        message.setSentDate(new Date());
        message.setSubject(email.subject());
        MimeMultipart mimeMultipartList = new MimeMultipart();
        switch (email.format()) {
            case text: {
                MimeBodyPart textBodyPart = new MimeBodyPart();
                mimeMultipartList.addBodyPart((BodyPart)textBodyPart);
                textBodyPart.setText(email.body());
                textBodyPart.setHeader("Content-Transfer-Encoding", "quoted-printable");
                textBodyPart.setHeader("Content-Type", "text/plain; charset=utf-8");
                break;
            }
            case html: {
                MimeBodyPart htmlBodyPart = new MimeBodyPart();
                mimeMultipartList.addBodyPart((BodyPart)htmlBodyPart);
                htmlBodyPart.setContent((Object)email.body(), "text/html; charset=utf-8");
            }
        }
        if (email.attachments() != null) {
            for (Attachment attachement : email.attachments()) {
                MimeBodyPart attachmentBodyPart = new MimeBodyPart();
                mimeMultipartList.addBodyPart((BodyPart)attachmentBodyPart);
                ByteArrayDataSource ds = new ByteArrayDataSource(attachement.getDataStream(), "application/" + attachement.type());
                attachmentBodyPart.setDataHandler(new DataHandler((DataSource)ds));
                attachmentBodyPart.setFileName(attachement.fileName());
                if (attachement.cid() == null) continue;
                attachmentBodyPart.addHeader("Content-ID", "<" + attachement.cid() + ">");
            }
        }
        message.setContent((Multipart)mimeMultipartList);
        return message;
    }

    public void sendA() {
        String regionName = "AWS_SES_Region";
        String accessKy = "AWS_SES_AccessKey";
        String secretKey = "AWS_SES_SecretKey";
    }

    public static enum Format {
        html,
        text;

    }

    public static class Attachment
    implements Serializable {
        private final String type;
        private final byte[] dataStream;
        private final String fileName;
        private String cid;

        public Attachment(String type, byte[] dataStream, String fileName, String cid) {
            this.type = type;
            this.dataStream = dataStream;
            this.fileName = fileName;
            this.cid = cid;
        }

        public String type() {
            return this.type;
        }

        public byte[] getDataStream() {
            return this.dataStream;
        }

        public String fileName() {
            return this.fileName;
        }

        public String cid() {
            return this.cid;
        }

        public Attachment cid(String cid) {
            this.cid = cid;
            return this;
        }
    }
}

