/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.nio.grpc;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import org.summerboot.jexpress.boot.config.BootConfig;
import org.summerboot.jexpress.boot.config.ConfigUtil;
import org.summerboot.jexpress.boot.config.annotation.Config;
import org.summerboot.jexpress.boot.config.annotation.Memo;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
public class GRPCServerConfig
extends BootConfig {
    public static final GRPCServerConfig CFG = new GRPCServerConfig();
    protected static final String ID = "gRpc.server";
    @Memo(title="1. gRpc.server provider")
    @Config(key="gRpc.server.binding.addr")
    private volatile String bindingAddr;
    @Config(key="gRpc.server.binding.port")
    private volatile int bindingPort;
    @Config(key="gRpc.server.pool.BizExecutor.mode", defaultValue="CPU_Bound", desc="valid value = CPU (default), IO, Mixed")
    private volatile ThreadingMode threadingMode = ThreadingMode.CPU_Bound;
    @Config(key="gRpc.server.pool.coreSize", required=false)
    private volatile int poolCoreSize;
    @Config(key="gRpc.server.pool.maxSize", required=false)
    private volatile int poolMaxSizeMaxSize;
    @Config(key="gRpc.server.pool.queueSize", defaultValue="2147483647")
    private volatile int poolQueueSize = Integer.MAX_VALUE;
    @Config(key="gRpc.server.pool.keepAliveSeconds", defaultValue="60")
    private volatile long keepAliveSeconds = 60L;
    @Config(key="nio.server.health.InspectionIntervalSeconds", defaultValue="5")
    private volatile int healthInspectionIntervalSeconds = 5;
    @Memo(title="2. gRpc.server keystore")
    @Config(key="gRpc.server.ssl.KeyStore", StorePwdKey="gRpc.server.ssl.KeyStorePwd", AliasKey="gRpc.server.ssl.KeyAlias", AliasPwdKey="gRpc.server.ssl.KeyPwd", required=false)
    @JsonIgnore
    protected volatile KeyManagerFactory kmf;
    @Memo(title="3. gRpc.server truststore")
    @Config(key="gRpc.server.ssl.TrustStore", StorePwdKey="gRpc.server.ssl.TrustStorePwd", required=false)
    @JsonIgnore
    protected volatile TrustManagerFactory tmf;

    public static void main(String[] args) {
        String t = GRPCServerConfig.generateTemplate(GRPCServerConfig.class);
        System.out.println(t);
    }

    protected GRPCServerConfig() {
    }

    @Override
    @Config(key="gRpc.server.ssl.overrideAuthority", required=false)
    protected void loadCustomizedConfigs(File cfgFile, boolean isReal, ConfigUtil helper, Properties props) throws IOException {
        int cpuCoreSize = Runtime.getRuntime().availableProcessors();
        switch (this.threadingMode) {
            case CPU_Bound: {
                this.poolMaxSizeMaxSize = this.poolCoreSize = cpuCoreSize + 1;
                break;
            }
            case IO_Bound: {
                this.poolMaxSizeMaxSize = this.poolCoreSize = cpuCoreSize * 2 + 1;
                break;
            }
            case Mixed: {
                if (this.poolCoreSize < 1) {
                    this.poolCoreSize = cpuCoreSize * 2 + 1;
                }
                if (this.poolMaxSizeMaxSize < 1) {
                    this.poolMaxSizeMaxSize = cpuCoreSize * 2 + 1;
                }
                if (this.poolMaxSizeMaxSize >= this.poolCoreSize) break;
                this.poolMaxSizeMaxSize = this.poolCoreSize;
            }
        }
    }

    @Override
    public void shutdown() {
    }

    public String getBindingAddr() {
        return this.bindingAddr;
    }

    public int getBindingPort() {
        return this.bindingPort;
    }

    public ThreadingMode getThreadingMode() {
        return this.threadingMode;
    }

    public int getPoolCoreSize() {
        return this.poolCoreSize;
    }

    public int getPoolMaxSizeMaxSize() {
        return this.poolMaxSizeMaxSize;
    }

    public int getPoolQueueSize() {
        return this.poolQueueSize;
    }

    public long getKeepAliveSeconds() {
        return this.keepAliveSeconds;
    }

    public int getHealthInspectionIntervalSeconds() {
        return this.healthInspectionIntervalSeconds;
    }

    public KeyManagerFactory getKmf() {
        return this.kmf;
    }

    public TrustManagerFactory getTmf() {
        return this.tmf;
    }

    public static enum ThreadingMode {
        CPU_Bound,
        IO_Bound,
        Mixed;

    }
}

