/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.nio.server;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.DeserializationFeature;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaders;
import java.io.File;
import java.net.InetSocketAddress;
import java.net.ProxySelector;
import java.net.http.HttpClient;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.commons.lang3.StringUtils;
import org.summerboot.jexpress.boot.config.BootConfig;
import org.summerboot.jexpress.boot.config.ConfigUtil;
import org.summerboot.jexpress.boot.config.annotation.Config;
import org.summerboot.jexpress.boot.config.annotation.Memo;
import org.summerboot.jexpress.boot.instrumentation.HTTPClientStatusListener;
import org.summerboot.jexpress.nio.client.RPCResult;
import org.summerboot.jexpress.nio.server.AbortPolicyWithReport;
import org.summerboot.jexpress.security.SSLUtil;

public class HttpConfig
extends BootConfig {
    public static final HttpConfig CFG = new HttpConfig();
    private static final String HEADER_SERVER_RESPONSE = "server.DefaultResponseHttpHeaders.";
    private static final String HEADER_CLIENT_REQUEST = "httpclient.DefaultReqHttpHeaders.";
    @Memo(title="1. Default Server Response HTTP Headers", desc="put generic HTTP response headers here", format="server.DefaultResponseHttpHeaders.?=?", example="server.DefaultResponseHttpHeaders.Access-Control-Allow-Origin=https://www.summerboot.org\nserver.DefaultResponseHttpHeaders.Access-Control-Allow-Headers=X-Requested-With, Content-Type, Origin, Authorization\nserver.DefaultResponseHttpHeaders.Access-Control-Allow-Methods=PUT,GET,POST,DELETE,OPTIONS,PATCH\nserver.DefaultResponseHttpHeaders.Access-Control-Allow-Credentials=false\nserver.DefaultResponseHttpHeaders.Access-Control-Allow-Credentials=false\nserver.DefaultResponseHttpHeaders.Access-Control-Max-Age=3600\nserver.DefaultResponseHttpHeaders.Content-Security-Policy=default-src 'self';script-src 'self' www.google-analytics.com www.google.com www.gstatic. js.stripe.com ajax.cloudflare.com;style-src 'self' 'unsafe-inline' cdnjs.cloudflare.com;img-src 'self' www.google-analytics.com stats.g.doubleclick.net www.gstatic.com;font-src 'self' cdnjs.cloudflare.com fonts.gstatic.com;base-uri 'self';child-src www.google.com js.stripe.com;form-action 'self';frame-ancestors 'none';report-uri=\"https://www.summerboot.org/report-uri\"\nserver.DefaultResponseHttpHeaders.X-XSS-Protection=1; mode=block\nserver.DefaultResponseHttpHeaders.Strict-Transport-Security=max-age=31536000;includeSubDomains;preload\nserver.DefaultResponseHttpHeaders.X-Frame-Options=sameorigin\nserver.DefaultResponseHttpHeaders.Expect-CT=max-age=86400, enforce, report-uri=\"https://www.summerboot.org/report-uri\"\nserver.DefaultResponseHttpHeaders.X-Content-Type-Options=nosniff\nserver.DefaultResponseHttpHeaders.Feature-Policy=autoplay 'none';camera 'none' ")
    private final HttpHeaders serverDefaultResponseHeaders = new DefaultHttpHeaders(true);
    @Memo(title="2. Web Server Mode")
    @Config(key="server.http.web.docroot", required=false, defaultValue="docroot")
    private volatile String docroot;
    @Config(key="server.http.web.resources", required=false, defaultValue="web-resources/errorpages")
    private volatile String webResources;
    @Config(key="server.http.web.welcomePage", required=false, defaultValue="index.html")
    private volatile String welcomePage;
    @Config(key="server.http.web-server.tempupload", required=false, defaultValue="tempupload")
    private volatile String tempUoloadDir;
    private volatile boolean downloadMode;
    private volatile File rootFolder;
    @Memo(title="3.1 HTTP Client Security")
    @Config(key="httpclient.ssl.protocol", required=false, defaultValue="TLSv1.3")
    private volatile String protocol;
    @JsonIgnore
    @Config(key="httpclient.ssl.KeyStore", StorePwdKey="httpclient.ssl.KeyStorePwd", AliasKey="httpclient.ssl.KeyAlias", AliasPwdKey="httpclient.ssl.KeyPwd", required=false)
    private volatile KeyManagerFactory kmf;
    @JsonIgnore
    @Config(key="httpclient.ssl.TrustStore", StorePwdKey="httpclient.ssl.TrustStorePwd", required=false)
    private volatile TrustManagerFactory tmf;
    @Config(key="httpclient.ssl.HostnameVerification", required=false, defaultValue="false")
    private volatile Boolean hostnameVerification = false;
    @Config(key="httpclient.proxy.host", required=false)
    private volatile String proxyHost;
    private volatile String currentProxyHost;
    @Config(key="httpclient.proxy.port", required=false, defaultValue="8080")
    private volatile int proxyPort;
    private volatile int currentProxyPort;
    @Config(key="httpclient.proxy.userName", required=false)
    private volatile String proxyUserName;
    @JsonIgnore
    @Config(key="httpclient.proxy.userPwd", required=false, validate=Config.Validate.Encrypted)
    private volatile String proxyUserPwd;
    @JsonIgnore
    private volatile String proxyAuthorizationBasicValue;
    @Config(key="httpclient.redirectOption", required=false, defaultValue="NEVER")
    private volatile HttpClient.Redirect redirectOption;
    @Config(key="httpclient.fromJson.failOnUnknownProperties", defaultValue="true")
    private volatile boolean fromJsonFailOnUnknownProperties = true;
    @Memo(title="3.2 HTTP Client Performance")
    private volatile HttpClient httpClient;
    @Config(key="httpclient.timeout.ms", required=false, defaultValue="5000")
    private volatile long httpClientTimeout;
    @Config(key="httpclient.executor.CoreSize", required=false, defaultValue="0", desc="HTTP Client will be disabled when core size is/below 0")
    private volatile int httpClientCoreSize;
    private volatile int currentCore;
    @Config(key="httpclient.executor.MaxSize", required=false, defaultValue="0")
    private volatile int httpClientMaxSize;
    private volatile int currentMax;
    @Config(key="httpclient.executor.QueueSize", required=false, defaultValue="2147483647")
    private volatile int httpClientQueueSize = Integer.MAX_VALUE;
    private volatile int currentQueue;
    private ThreadPoolExecutor tpe;
    @JsonIgnore
    private ScheduledExecutorService ses;
    @Memo(title="3.3 HTTP Client Default Headers", desc="put generic HTTP Client request headers here", format="httpclient.DefaultReqHttpHeaders.?=?", example="httpclient.DefaultReqHttpHeaders.Accept=application/json\nhttpclient.DefaultReqHttpHeaders.Content-Type=application/json;charset=UTF-8\nhttpclient.DefaultReqHttpHeaders.Accept-Language=en-ca")
    private final Map<String, String> httpClientDefaultRequestHeaders = new HashMap<String, String>();
    private HTTPClientStatusListener listener = null;

    public static void main(String[] args) {
        String t = HttpConfig.generateTemplate(HttpConfig.class);
        System.out.println(t);
    }

    @Override
    public void shutdown() {
        String tn = Thread.currentThread().getName();
        if (this.tpe != null && !this.tpe.isShutdown()) {
            System.out.println(tn + ": shutdown tpe: " + this.tpe);
            this.tpe.shutdown();
        } else {
            System.out.println(tn + ": already shutdown tpe: " + this.tpe);
        }
        if (this.ses != null && !this.ses.isShutdown()) {
            System.out.println(tn + ": shutdown ses: " + this.ses);
            this.ses.shutdown();
        }
    }

    public void setStatusListener(HTTPClientStatusListener l) {
        this.listener = l;
    }

    @Override
    protected void loadCustomizedConfigs(File cfgFile, boolean isReal, ConfigUtil helper, Properties props) throws Exception {
        boolean isHttpClientSettingsChanged;
        String error2;
        Set _keys = props.keySet().stream().map(o -> o.toString()).collect(Collectors.toSet());
        ArrayList<String> keys = new ArrayList<String>(_keys);
        Collections.sort(keys);
        this.serverDefaultResponseHeaders.clear();
        this.httpClientDefaultRequestHeaders.clear();
        keys.forEach(name -> {
            if (name.startsWith(HEADER_SERVER_RESPONSE)) {
                String[] names = name.split("\\.");
                String headerName = names[2];
                String headerValue = props.getProperty((String)name);
                this.serverDefaultResponseHeaders.set(headerName, (Object)headerValue);
            } else if (name.startsWith(HEADER_CLIENT_REQUEST)) {
                String[] names = name.split("\\.");
                String headerName = names[2];
                String headerValue = props.getProperty((String)name);
                this.httpClientDefaultRequestHeaders.put(headerName, headerValue);
            }
        });
        this.rootFolder = cfgFile.getParentFile().getParentFile();
        this.docroot = this.rootFolder.getName() + File.separator + this.docroot;
        this.downloadMode = StringUtils.isBlank((CharSequence)this.welcomePage);
        this.tempUoloadDir = this.rootFolder.getAbsolutePath() + File.separator + this.tempUoloadDir;
        RPCResult.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, this.fromJsonFailOnUnknownProperties);
        KeyManager[] keyManagers = this.kmf == null ? null : this.kmf.getKeyManagers();
        TrustManager[] trustManagers = this.tmf == null ? SSLUtil.TRUST_ALL_CERTIFICATES : this.tmf.getTrustManagers();
        SSLContext sslContext = SSLUtil.buildSSLContext(keyManagers, trustManagers, this.protocol);
        if (this.hostnameVerification != null) {
            System.setProperty("jdk.internal.httpclient.disableHostnameVerification", this.hostnameVerification != false ? "false" : "true");
        }
        if (this.httpClientMaxSize < this.httpClientCoreSize) {
            helper.addError("MaxSize should not less than CoreSize");
        }
        if ((error2 = helper.getError()) != null) {
            throw new IllegalArgumentException(error2);
        }
        if (!isReal) {
            return;
        }
        boolean bl = isHttpClientSettingsChanged = this.currentCore != this.httpClientCoreSize || this.currentMax != this.httpClientMaxSize || this.currentQueue != this.httpClientQueueSize || !StringUtils.equals((CharSequence)this.currentProxyHost, (CharSequence)this.proxyHost) || this.currentProxyPort != this.proxyPort;
        if (this.httpClient == null || isHttpClientSettingsChanged) {
            this.currentCore = this.httpClientCoreSize;
            this.currentMax = this.httpClientMaxSize;
            this.currentQueue = this.httpClientQueueSize;
            this.currentProxyHost = this.proxyHost;
            this.currentProxyPort = this.proxyPort;
            ThreadPoolExecutor old = this.tpe;
            ScheduledExecutorService sesold = this.ses;
            if (this.httpClientCoreSize > 0) {
                this.tpe = new ThreadPoolExecutor(this.currentCore, this.currentMax, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(this.currentQueue), Executors.defaultThreadFactory(), new AbortPolicyWithReport("HttpClientExecutor"));
                HttpClient.Builder builder = HttpClient.newBuilder().executor(this.tpe).sslContext(sslContext).version(HttpClient.Version.HTTP_2).followRedirects(this.redirectOption);
                if (StringUtils.isNotBlank((CharSequence)this.proxyHost)) {
                    builder.proxy(ProxySelector.of(new InetSocketAddress(this.proxyHost, this.proxyPort)));
                }
                if (StringUtils.isNotBlank((CharSequence)this.proxyUserName)) {
                    if (this.proxyUserPwd == null) {
                        this.proxyUserPwd = "";
                    }
                    System.setProperty("jdk.http.auth.tunneling.disabledSchemes", "");
                    String plain = this.proxyUserName + ":" + this.proxyUserPwd;
                    String encoded = new String(Base64.getEncoder().encode(plain.getBytes()));
                    this.proxyAuthorizationBasicValue = "Basic " + encoded;
                }
                this.httpClient = builder.build();
                this.ses = Executors.newSingleThreadScheduledExecutor();
                this.ses.scheduleAtFixedRate(() -> {
                    int queue = this.tpe.getQueue().size();
                    int active = this.tpe.getActiveCount();
                    if (active > 0 || queue > 0) {
                        long task = this.tpe.getTaskCount();
                        long completed = this.tpe.getCompletedTaskCount();
                        long pool = this.tpe.getPoolSize();
                        int core = this.tpe.getCorePoolSize();
                        long max = this.tpe.getMaximumPoolSize();
                        long largest = this.tpe.getLargestPoolSize();
                        if (this.listener != null) {
                            this.listener.onHTTPClientAccessReportUpdate(task, completed, queue, active, pool, core, max, largest);
                        }
                        this.log.info(() -> "HTTPClient task=" + task + ", completed=" + completed + ", queue=" + queue + ", active=" + active + ", pool=" + pool + ", core=" + core + ", max=" + max + ", largest=" + largest);
                    }
                }, 0L, 1L, TimeUnit.SECONDS);
            }
            if (old != null) {
                old.shutdown();
            }
            if (sesold != null) {
                sesold.shutdown();
            }
        }
    }

    public File getRootFolder() {
        return this.rootFolder;
    }

    public HttpHeaders getServerDefaultResponseHeaders() {
        return this.serverDefaultResponseHeaders;
    }

    public String getDocroot() {
        return this.docroot;
    }

    public String getWebResources() {
        return this.webResources;
    }

    public String getWelcomePage() {
        return this.welcomePage;
    }

    public boolean isDownloadMode() {
        return this.downloadMode;
    }

    @JsonIgnore
    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public Map<String, String> getHttpClientDefaultRequestHeaders() {
        return this.httpClientDefaultRequestHeaders;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public Boolean isHostnameVerificationEnabled() {
        return this.hostnameVerification;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public String getProxyUserName() {
        return this.proxyUserName;
    }

    public String getProxyUserPwd() {
        return this.proxyUserPwd;
    }

    public String getProxyAuthorizationBasicValue() {
        return this.proxyAuthorizationBasicValue;
    }

    public boolean isFromJsonFailOnUnknownProperties() {
        return this.fromJsonFailOnUnknownProperties;
    }

    public long getHttpClientTimeout() {
        return this.httpClientTimeout;
    }

    public int getHttpClientCoreSize() {
        return this.httpClientCoreSize;
    }

    public int getHttpClientMaxSize() {
        return this.httpClientMaxSize;
    }

    public int getHttpClientQueueSize() {
        return this.httpClientQueueSize;
    }

    public String getHttpClientInfo() {
        return String.valueOf(this.httpClient);
    }

    public String getTpeInfo() {
        return String.valueOf(this.tpe);
    }

    public String getTempUoloadDir() {
        return this.tempUoloadDir;
    }
}

