/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.nio.server;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.name.Names;
import io.netty.channel.ChannelHandler;
import io.netty.handler.ssl.SslProvider;
import java.io.File;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import org.summerboot.jexpress.boot.config.BootConfig;
import org.summerboot.jexpress.boot.config.ConfigUtil;
import org.summerboot.jexpress.boot.config.annotation.Config;
import org.summerboot.jexpress.boot.config.annotation.Memo;
import org.summerboot.jexpress.nio.server.AbortPolicyWithReport;
import org.summerboot.jexpress.nio.server.BootHttpFileUploadHandler;
import org.summerboot.jexpress.nio.server.BootHttpFileUploadRejector;
import org.summerboot.jexpress.nio.server.BootHttpPingHandler;
import org.summerboot.jexpress.nio.server.BootHttpRequestHandler;
import org.summerboot.jexpress.nio.server.IoMultiplexer;
import org.summerboot.jexpress.nio.server.NioServer;
import org.summerboot.jexpress.util.BeanUtil;

public class NioConfig
extends BootConfig {
    public static final NioConfig CFG = new NioConfig();
    @Memo(title="1. NIO Network Listeners", format="ip1:port1, ip2:port2, ..., ipN:portN", example="192.168.1.10:8443, 127.0.0.1:8444, 0.0.0.0:8445")
    @Config(key="nio.server.bindings")
    private volatile Map<String, Integer> bindingAddresses = null;
    @Memo(title="2. NIO Security")
    @JsonIgnore
    @Config(key="nio.server.ssl.KeyStore", StorePwdKey="nio.server.ssl.KeyStorePwd", AliasKey="nio.server.ssl.KeyAlias", AliasPwdKey="nio.server.ssl.KeyPwd", required=false, desc="Use SSL/TLS when key store is provided, use plain Socket if key stroe is not available")
    private volatile KeyManagerFactory kmf = null;
    @JsonIgnore
    @Config(key="nio.server.ssl.TrustStore", StorePwdKey="nio.server.ssl.TrustStorePwd", required=false, desc="trust all clients when truststore is not provided")
    private volatile TrustManagerFactory tmf = null;
    @Config(key="nio.server.ssl.VerifyCertificateHost", defaultValue="false")
    private volatile boolean verifyCertificateHost = false;
    @Config(key="nio.server.ssl.Provider", defaultValue="OPENSSL")
    private volatile SslProvider sslProvider = SslProvider.OPENSSL;
    @Config(key="nio.server.ssl.Protocols", defaultValue="TLSv1.2, TLSv1.3")
    private String[] sslProtocols = new String[]{"TLSv1.2", "TLSv1.3"};
    @Config(key="nio.server.ssl.CipherSuites", required=false, desc="use system default ciphersuites when not specified")
    private String[] sslCipherSuites = null;
    @Memo(title="3.1 Socket controller")
    @Config(key="nio.server.socket.SO_REUSEADDR", defaultValue="true")
    private volatile boolean soReuseAddr = true;
    @Config(key="nio.server.socket.SO_KEEPALIVE", defaultValue="true")
    private volatile boolean soKeepAlive = true;
    @Config(key="nio.server.socket.TCP_NODELAY", defaultValue="true")
    private volatile boolean soTcpNodelay = true;
    @Config(key="nio.server.socket.SO_LINGER", defaultValue="-1")
    private volatile int soLinger = -1;
    @Memo(title="3.2 Socket Performance")
    @Config(key="nio.server.ssl.HandshakeTimeout.second", defaultValue="30")
    private volatile int sslHandshakeTimeout = 30;
    @Config(key="nio.server.socket.CONNECT_TIMEOUT.second", defaultValue="30")
    private volatile int soConnectionTimeout = 30;
    @Config(key="nio.server.socket.SO_BACKLOG", defaultValue="1024")
    private volatile int soBacklog = 1024;
    @Config(key="nio.server.socket.SO_RCVBUF", defaultValue="1048576", desc=" - cat /proc/sys/net/ipv4/tcp_rmem (max 1024k)")
    private volatile int soRcvBuf = 0x100000;
    @Config(key="nio.server.socket.SO_SNDBUF", defaultValue="1048576", desc=" - cat /proc/sys/net/ipv4/tcp_smem (max 1024k)")
    private volatile int soSndBuf = 0x100000;
    @Config(key="nio.server.HttpObjectAggregator.maxContentLength", defaultValue="65536", desc="default - 64kb")
    private volatile int httpObjectAggregatorMaxContentLength = 65536;
    @Memo(title="4.1 Netty controller")
    @Config(key="nio.server.multiplexer", defaultValue="AVAILABLE")
    private volatile IoMultiplexer multiplexer = IoMultiplexer.AVAILABLE;
    @Config(key="nio.server.httpServerCodec.MaxInitialLineLength", defaultValue="4096")
    private volatile int httpServerCodec_MaxInitialLineLength = 4096;
    @Config(key="nio.server.httpServerCodec.MaxHeaderSize", defaultValue="4096")
    private volatile int httpServerCodec_MaxHeaderSize = 4096;
    @Config(key="nio.server.httpServerCodec.MaxChunkSize", defaultValue="4096")
    private volatile int httpServerCodec_MaxChunkSize = 4096;
    @Memo(title="4.2 Netty Performance - NIO and Biz Exector Pool")
    private ThreadPoolExecutor tpe = null;
    @Config(key="nio.server.EventLoopGroup.AcceptorSize", required=false, desc="default AcceptorSize = number of bindings")
    private volatile int nioEventLoopGroupAcceptorSize = 0;
    @Config(key="nio.server.EventLoopGroup.WorkerSize", required=false, desc="default WorkerSize = CPU core x2 +1")
    private volatile int nioEventLoopGroupWorkerSize = 0;
    @Config(key="nio.server.BizExecutor.mode", defaultValue="IO", desc="valid value = CPU, IO (default), Mixed")
    private volatile ThreadingMode bizExecutorThreadingMode = ThreadingMode.IO;
    @Config(key="nio.server.BizExecutor.CoreSize", defaultValue="0", desc="use CPU core + 1 when application is CPU bound\nuse CPU core x 2 + 1 when application is I/O bound\nneed to find the best value based on your performance test result when nio.server.BizExecutor.mode=Mixed")
    private volatile int bizExecutorCoreSize = 0;
    private volatile int currentCore;
    @Config(key="nio.server.BizExecutor.MaxSize", defaultValue="0")
    private volatile int bizExecutorMaxSize = 0;
    private volatile int currentMax;
    @Config(key="nio.server.BizExecutor.QueueSize", defaultValue="2147483647")
    private volatile int bizExecutorQueueSize = Integer.MAX_VALUE;
    private volatile int currentQueue;
    @Config(key="nio.server.BizExecutor.bizTimeoutWarnThreshold", defaultValue="5000")
    private volatile int bizTimeoutWarnThreshold = 5000;
    @Memo(title="4.3 Netty Channel Handler")
    @Config(key="nio.server.ReaderIdleTime", required=false, desc="rec Idle enabled only when value > 0")
    private volatile int readerIdleTime = 0;
    @Config(key="nio.server.WriterIdleTime", required=false, desc="Sent Idle enabled only when value > 0")
    private volatile int writerIdleTime = 0;
    @Config(key="nio.server.health.InspectionIntervalSeconds", defaultValue="5")
    private volatile int healthInspectionIntervalSeconds = 5;
    private static Injector INJECTOR;
    @Config(key="nio.HttpService.enabled", defaultValue="true")
    private volatile boolean httpService = true;
    @Config(key="nio.JAX-RS.fromJson.failOnUnknownProperties", defaultValue="true")
    private volatile boolean fromJsonFailOnUnknownProperties = true;
    @Config(key="nio.JAX-RS.toJson.IgnoreNull", defaultValue="true")
    private volatile boolean toJsonIgnoreNull = true;
    @Config(key="nio.JAX-RS.toJson.Pretty", defaultValue="false")
    private volatile boolean toJsonPretty = false;
    @Config(key="nio.HttpFileUploadHandler", required=false)
    private volatile String fielUploadHandlerAnnotatedName = null;
    @Config(key="nio.HttpPingHandler", defaultValue="org.summerboot.jexpress.nio.server.BootHttpPingHandler")
    private volatile String pingHandlerAnnotatedName = BootHttpPingHandler.class.getName();
    @Config(key="nio.HttpRequestHandler", defaultValue="org.summerboot.jexpress.nio.server.BootHttpRequestHandler")
    private volatile String requestHandlerAnnotatedName = BootHttpRequestHandler.class.getName();
    @Config(key="nio.WebSocket.Compress", defaultValue="false")
    private volatile boolean compressWebSocket = false;
    @Memo(title="5. IO Communication logging filter")
    @Config(key="nio.verbose.filter.usertype", defaultValue="ignore", desc="5.1 caller filter\nvalid value = id, uid, group, role, ignore")
    private volatile VerboseTargetUserType filterUserType = VerboseTargetUserType.ignore;
    @Config(key="nio.verbose.filter.usertype.range", required=false, desc="user range (when type=CallerId): N1 - N2 or N1, N2, ... , Nn \nuser range (when type=CallerName): johndoe, janedoe")
    private volatile String filterUserVaue;
    private volatile Set<String> filterCallerNameSet;
    private volatile Set<Long> filterCallerIdSet;
    private volatile long filterCallerIdFrom;
    private volatile long filterCallerIdTo;
    @Config(key="nio.verbose.filter.codetype", defaultValue="all", desc="valid value = HttpStatusCode, AppErrorCode, all, ignore")
    private volatile VerboseTargetCodeType filterCodeType = VerboseTargetCodeType.all;
    @Config(key="nio.verbose.filter.codetype.range", required=false, desc="5.2 error code filter\ncode range: N1 - N2 or N1, N2, ... , Nn")
    private volatile String filterCodeVaue;
    private volatile Set<Long> filterCodeSet;
    private volatile long filterCodeRangeFrom;
    private volatile long filterCodeRangeTo;
    @Config(key="nio.verbose.aspect.ReqHeader", defaultValue="true")
    private volatile boolean verboseReqHeader = true;
    @Config(key="nio.verbose.aspect.ReqContent", defaultValue="true")
    private volatile boolean verboseReqContent = true;
    @Config(key="nio.verbose.aspect.RespHeader", defaultValue="true")
    private volatile boolean verboseRespHeader = true;
    @Config(key="nio.verbose.aspect.RespContent", defaultValue="true")
    private volatile boolean verboseRespContent = true;
    @Memo(title="6. POI logging filter")
    @Config(key="nio.verbose.ServiceTimePOI.type", defaultValue="all", desc="valid value = filter, all, ignore")
    private volatile VerboseTargetPOIType filterPOIType = VerboseTargetPOIType.all;
    @Config(key="nio.verbose.ServiceTimePOI.filter", defaultValue="auth.begin, auth.end, db.begin, db.end", desc="CSV format")
    private volatile Set<String> filterPOISet;
    private static final BootHttpFileUploadHandler FileUploadRejector;

    public static void main(String[] args) {
        String t = NioConfig.generateTemplate(NioConfig.class);
        System.out.println(t);
    }

    @Override
    public void shutdown() {
        String tn = Thread.currentThread().getName();
        NioServer.shutdown();
        if (this.tpe != null && !this.tpe.isShutdown()) {
            System.out.println(tn + ": shutdown tpe");
            this.tpe.shutdown();
        }
    }

    @Override
    protected void loadCustomizedConfigs(File cfgFile, boolean isReal, ConfigUtil helper, Properties props) throws Exception {
        Long[] a;
        String key;
        int availableProcessors = Runtime.getRuntime().availableProcessors();
        if (this.nioEventLoopGroupAcceptorSize < 1) {
            this.nioEventLoopGroupAcceptorSize = this.bindingAddresses.size();
        }
        if (this.nioEventLoopGroupWorkerSize < 1) {
            this.nioEventLoopGroupWorkerSize = availableProcessors * 2 + 1;
        }
        switch (this.bizExecutorThreadingMode) {
            case CPU: {
                this.bizExecutorCoreSize = availableProcessors + 1;
                this.bizExecutorMaxSize = availableProcessors + 1;
                break;
            }
            case IO: {
                this.bizExecutorCoreSize = availableProcessors * 2 + 1;
                this.bizExecutorMaxSize = availableProcessors * 2 + 1;
                break;
            }
            case Mixed: {
                if (this.bizExecutorCoreSize < 1) {
                    this.bizExecutorCoreSize = availableProcessors * 2 + 1;
                }
                if (this.bizExecutorMaxSize < 1) {
                    this.bizExecutorMaxSize = availableProcessors * 2 + 1;
                }
                if (this.bizExecutorMaxSize >= this.bizExecutorCoreSize) break;
                helper.addError("BizExecutor.MaxSize should not less than BizExecutor.CoreSize");
            }
        }
        if (this.currentCore != this.bizExecutorCoreSize || this.currentMax != this.bizExecutorMaxSize || this.currentQueue != this.bizExecutorQueueSize) {
            this.currentCore = this.bizExecutorCoreSize;
            this.currentMax = this.bizExecutorMaxSize;
            this.currentQueue = this.bizExecutorQueueSize;
            ThreadPoolExecutor old = this.tpe;
            this.tpe = new ThreadPoolExecutor(this.currentCore, this.currentMax, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(this.currentQueue), Executors.defaultThreadFactory(), new AbortPolicyWithReport("NIOBizThreadPoolExecutor"));
            if (old != null) {
                old.shutdown();
            }
        }
        if (INJECTOR != null) {
            if (this.fielUploadHandlerAnnotatedName != null) {
                try {
                    INJECTOR.getInstance(Key.get(ChannelHandler.class, (Annotation)Names.named((String)this.fielUploadHandlerAnnotatedName)));
                }
                catch (Throwable ex) {
                    helper.addError("invalid HttpFileUpload Channel Handler name(" + this.fielUploadHandlerAnnotatedName + "): " + ex.toString());
                }
            }
            if (this.pingHandlerAnnotatedName != null) {
                try {
                    INJECTOR.getInstance(Key.get(ChannelHandler.class, (Annotation)Names.named((String)this.pingHandlerAnnotatedName)));
                }
                catch (Throwable ex) {
                    helper.addError("invalid Ping Channel Handler name(" + this.pingHandlerAnnotatedName + "): " + ex.toString());
                }
            }
            if (this.requestHandlerAnnotatedName != null) {
                try {
                    INJECTOR.getInstance(Key.get(ChannelHandler.class, (Annotation)Names.named((String)this.requestHandlerAnnotatedName)));
                }
                catch (Throwable ex) {
                    helper.addError("invalid Request Channel Handler name(" + this.requestHandlerAnnotatedName + "): " + ex.toString());
                }
            }
        }
        BeanUtil.configure(this.fromJsonFailOnUnknownProperties, this.toJsonPretty, this.toJsonIgnoreNull);
        switch (this.filterUserType) {
            case id: {
                key = "nio.verbose.filter.usertype.range";
                this.filterCallerIdSet = new HashSet<Long>();
                a = helper.getAsRangeLong(props, key, this.filterCallerIdSet);
                if (a == null) break;
                this.filterCallerIdFrom = a[0];
                this.filterCallerIdTo = a[1];
                this.filterCallerIdSet = null;
                break;
            }
            case uid: 
            case group: 
            case role: {
                key = "nio.verbose.filter.usertype.range";
                String[] na = helper.getAsCSV(props, key, null);
                this.filterCallerNameSet = new HashSet<String>();
                this.filterCallerNameSet.addAll(Arrays.asList(na));
            }
        }
        switch (this.filterCodeType) {
            case HttpStatusCode: 
            case AppErrorCode: {
                key = "nio.verbose.filter.codetype.range";
                this.filterCodeSet = new HashSet<Long>();
                a = helper.getAsRangeLong(props, key, this.filterCodeSet);
                if (a == null) break;
                this.filterCodeRangeFrom = a[0];
                this.filterCodeRangeTo = a[1];
                this.filterCodeSet = null;
            }
        }
    }

    ThreadPoolExecutor getBizExecutor() {
        return this.tpe;
    }

    public static void setGuiceInjector(Injector _injector) {
        INJECTOR = _injector;
    }

    @JsonIgnore
    public ChannelHandler getHttpFileUploadHandler() {
        if (this.fielUploadHandlerAnnotatedName == null) {
            return FileUploadRejector;
        }
        return (ChannelHandler)INJECTOR.getInstance(Key.get(ChannelHandler.class, (Annotation)Names.named((String)this.fielUploadHandlerAnnotatedName)));
    }

    @JsonIgnore
    public ChannelHandler getPingHandler() {
        if (this.pingHandlerAnnotatedName == null) {
            return null;
        }
        return (ChannelHandler)INJECTOR.getInstance(Key.get(ChannelHandler.class, (Annotation)Names.named((String)this.pingHandlerAnnotatedName)));
    }

    @JsonIgnore
    public ChannelHandler getRequestHandler() {
        if (this.requestHandlerAnnotatedName == null) {
            return null;
        }
        return (ChannelHandler)INJECTOR.getInstance(Key.get(ChannelHandler.class, (Annotation)Names.named((String)this.requestHandlerAnnotatedName)));
    }

    public boolean isCompressWebSocket() {
        return this.compressWebSocket;
    }

    public Map<String, Integer> getBindingAddresses() {
        return this.bindingAddresses;
    }

    public KeyManagerFactory getKmf() {
        return this.kmf;
    }

    public TrustManagerFactory getTmf() {
        return this.tmf;
    }

    public boolean isVerifyCertificateHost() {
        return this.verifyCertificateHost;
    }

    public SslProvider getSslProvider() {
        return this.sslProvider;
    }

    public String[] getSslProtocols() {
        return this.sslProtocols;
    }

    public String[] getSslCipherSuites() {
        return this.sslCipherSuites;
    }

    public boolean isSoReuseAddr() {
        return this.soReuseAddr;
    }

    public boolean isSoKeepAlive() {
        return this.soKeepAlive;
    }

    public boolean isSoTcpNodelay() {
        return this.soTcpNodelay;
    }

    public int getSoLinger() {
        return this.soLinger;
    }

    public int getSslHandshakeTimeout() {
        return this.sslHandshakeTimeout;
    }

    public int getSoConnectionTimeout() {
        return this.soConnectionTimeout;
    }

    public int getSoBacklog() {
        return this.soBacklog;
    }

    public int getSoRcvBuf() {
        return this.soRcvBuf;
    }

    public int getSoSndBuf() {
        return this.soSndBuf;
    }

    public int getHttpObjectAggregatorMaxContentLength() {
        return this.httpObjectAggregatorMaxContentLength;
    }

    public IoMultiplexer getMultiplexer() {
        return this.multiplexer;
    }

    public int getHttpServerCodec_MaxInitialLineLength() {
        return this.httpServerCodec_MaxInitialLineLength;
    }

    public int getHttpServerCodec_MaxHeaderSize() {
        return this.httpServerCodec_MaxHeaderSize;
    }

    public int getHttpServerCodec_MaxChunkSize() {
        return this.httpServerCodec_MaxChunkSize;
    }

    public int getNioEventLoopGroupAcceptorSize() {
        return this.nioEventLoopGroupAcceptorSize;
    }

    public int getNioEventLoopGroupWorkerSize() {
        return this.nioEventLoopGroupWorkerSize;
    }

    public ThreadingMode getBizExecutorThreadingMode() {
        return this.bizExecutorThreadingMode;
    }

    public int getBizExecutorCoreSize() {
        return this.bizExecutorCoreSize;
    }

    public int getBizExecutorMaxSize() {
        return this.bizExecutorMaxSize;
    }

    public int getBizExecutorQueueSize() {
        return this.bizExecutorQueueSize;
    }

    public int getBizTimeoutWarnThreshold() {
        return this.bizTimeoutWarnThreshold;
    }

    public int getReaderIdleTime() {
        return this.readerIdleTime;
    }

    public int getWriterIdleTime() {
        return this.writerIdleTime;
    }

    public int getHealthInspectionIntervalSeconds() {
        return this.healthInspectionIntervalSeconds;
    }

    public boolean isHttpService() {
        return this.httpService;
    }

    public boolean isFromJsonFailOnUnknownProperties() {
        return this.fromJsonFailOnUnknownProperties;
    }

    public boolean isToJsonIgnoreNull() {
        return this.toJsonIgnoreNull;
    }

    public boolean isToJsonPretty() {
        return this.toJsonPretty;
    }

    public String getFielUploadHandlerAnnotatedName() {
        return this.fielUploadHandlerAnnotatedName;
    }

    public String getPingHandlerAnnotatedName() {
        return this.pingHandlerAnnotatedName;
    }

    public String getRequestHandlerAnnotatedName() {
        return this.requestHandlerAnnotatedName;
    }

    public VerboseTargetUserType getFilterUserType() {
        return this.filterUserType;
    }

    public Set<String> getFilterCallerNameSet() {
        return this.filterCallerNameSet;
    }

    public Set<Long> getFilterCallerIdSet() {
        return this.filterCallerIdSet;
    }

    public long getFilterCallerIdFrom() {
        return this.filterCallerIdFrom;
    }

    public long getFilterCallerIdTo() {
        return this.filterCallerIdTo;
    }

    public VerboseTargetCodeType getFilterCodeType() {
        return this.filterCodeType;
    }

    public Set<Long> getFilterCodeSet() {
        return this.filterCodeSet;
    }

    public long getFilterCodeRangeFrom() {
        return this.filterCodeRangeFrom;
    }

    public long getFilterCodeRangeTo() {
        return this.filterCodeRangeTo;
    }

    public boolean isVerboseReqHeader() {
        return this.verboseReqHeader;
    }

    public boolean isVerboseReqContent() {
        return this.verboseReqContent;
    }

    public boolean isVerboseRespHeader() {
        return this.verboseRespHeader;
    }

    public boolean isVerboseRespContent() {
        return this.verboseRespContent;
    }

    public VerboseTargetPOIType getFilterPOIType() {
        return this.filterPOIType;
    }

    public Set<String> getFilterPOISet() {
        return this.filterPOISet;
    }

    static {
        FileUploadRejector = new BootHttpFileUploadRejector();
    }

    public static enum ThreadingMode {
        CPU,
        IO,
        Mixed;

    }

    public static enum VerboseTargetUserType {
        id,
        uid,
        group,
        role,
        ignore;

    }

    public static enum VerboseTargetCodeType {
        HttpStatusCode,
        AppErrorCode,
        all,
        ignore;

    }

    public static enum VerboseTargetPOIType {
        filter,
        all,
        ignore;

    }
}

