/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.nio.server;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollChannelOption;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.kqueue.KQueue;
import io.netty.channel.kqueue.KQueueServerSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.http2.Http2SecurityUtil;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.SupportedCipherSuiteFilter;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.summerboot.jexpress.boot.BootConstant;
import org.summerboot.jexpress.boot.instrumentation.HealthMonitor;
import org.summerboot.jexpress.boot.instrumentation.NIOStatusListener;
import org.summerboot.jexpress.nio.server.IoMultiplexer;
import org.summerboot.jexpress.nio.server.NioConfig;
import org.summerboot.jexpress.nio.server.NioServerContext;
import org.summerboot.jexpress.nio.server.NioServerHttpInitializer;

public class NioServer {
    private static final Logger log = LogManager.getLogger((String)NioServer.class.getName());
    private static EventLoopGroup bossGroup;
    private static EventLoopGroup workerGroup;
    private static final ScheduledExecutorService QPS_SERVICE;
    private static NIOStatusListener listener;

    public static void setStatusListener(NIOStatusListener l) {
        listener = l;
    }

    public static void bind() throws GeneralSecurityException, IOException, InterruptedException {
        NioServer.bind(NioConfig.CFG.getBindingAddresses());
    }

    public static void bind(Map<String, Integer> bindingAddresses) throws GeneralSecurityException, IOException, InterruptedException {
        Class<NioServerSocketChannel> serverChannelClass;
        ClientAuth clientAuth;
        if (bindingAddresses == null || bindingAddresses.isEmpty()) {
            log.info("Skip NIO server due to no bindingAddresses in config file: " + NioConfig.CFG.getCfgFile());
            return;
        }
        if (NioConfig.CFG.getRequestHandler() == null) {
            log.warn("Skip NIO server due to no RequestHandler in config file: " + NioConfig.CFG.getCfgFile());
            return;
        }
        IoMultiplexer multiplexer = NioConfig.CFG.getMultiplexer();
        log.info("starting... Epoll=" + Epoll.isAvailable() + ", KQueue=" + KQueue.isAvailable() + ", multiplexer=" + multiplexer);
        System.setProperty("io.netty.recycler.maxCapacity", "0");
        System.setProperty("io.netty.allocator.tinyCacheSize", "0");
        System.setProperty("io.netty.allocator.smallCacheSize", "0");
        System.setProperty("io.netty.allocator.normalCacheSize", "0");
        SSLContext jdkSslContext = null;
        SslContext nettySslContext = null;
        KeyManagerFactory kmf = NioConfig.CFG.getKmf();
        TrustManagerFactory tmf = NioConfig.CFG.getTmf();
        ClientAuth clientAuth2 = clientAuth = kmf != null && tmf != null ? ClientAuth.REQUIRE : ClientAuth.NONE;
        if (kmf != null) {
            String[] cipherSuites = NioConfig.CFG.getSslCipherSuites();
            List<String> ciphers = cipherSuites != null && cipherSuites.length > 0 ? Arrays.asList(NioConfig.CFG.getSslCipherSuites()) : Http2SecurityUtil.CIPHERS;
            SslProvider sp = NioConfig.CFG.getSslProvider();
            nettySslContext = SslContextBuilder.forServer((KeyManagerFactory)kmf).trustManager(tmf).clientAuth(clientAuth).sslProvider(sp).sessionTimeout(0L).protocols(NioConfig.CFG.getSslProtocols()).ciphers(ciphers, (CipherSuiteFilter)SupportedCipherSuiteFilter.INSTANCE).build();
            log.info(StringUtils.join((Object[])new String[]{"[" + sp + "] " + Arrays.asList(NioConfig.CFG.getSslProtocols())}) + " (" + NioConfig.CFG.getSslHandshakeTimeout() + "s): " + ciphers);
        }
        int bossSize = NioConfig.CFG.getNioEventLoopGroupAcceptorSize();
        int workerSize = NioConfig.CFG.getNioEventLoopGroupWorkerSize();
        if (Epoll.isAvailable() && (IoMultiplexer.AVAILABLE.equals((Object)multiplexer) || IoMultiplexer.EPOLL.equals((Object)multiplexer))) {
            bossGroup = bossSize < 1 ? new EpollEventLoopGroup() : new EpollEventLoopGroup(bossSize);
            workerGroup = workerSize < 1 ? new EpollEventLoopGroup() : new EpollEventLoopGroup(workerSize);
            serverChannelClass = EpollServerSocketChannel.class;
            multiplexer = IoMultiplexer.EPOLL;
        } else if (KQueue.isAvailable() && (IoMultiplexer.AVAILABLE.equals((Object)multiplexer) || IoMultiplexer.KQUEUE.equals((Object)multiplexer))) {
            bossGroup = bossSize < 1 ? new EpollEventLoopGroup() : new EpollEventLoopGroup(bossSize);
            workerGroup = workerSize < 1 ? new EpollEventLoopGroup() : new EpollEventLoopGroup(workerSize);
            serverChannelClass = KQueueServerSocketChannel.class;
            multiplexer = IoMultiplexer.KQUEUE;
        } else {
            bossGroup = bossSize < 1 ? new NioEventLoopGroup() : new NioEventLoopGroup(bossSize);
            workerGroup = workerSize < 1 ? new NioEventLoopGroup() : new NioEventLoopGroup(workerSize);
            serverChannelClass = NioServerSocketChannel.class;
            multiplexer = IoMultiplexer.JDK;
        }
        ServerBootstrap boot = new ServerBootstrap();
        if (multiplexer == IoMultiplexer.EPOLL) {
            boot.option(EpollChannelOption.SO_REUSEPORT, (Object)true);
        }
        ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)boot.option(ChannelOption.SO_BACKLOG, (Object)NioConfig.CFG.getSoBacklog())).option(ChannelOption.SO_REUSEADDR, (Object)NioConfig.CFG.isSoReuseAddr())).option(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT)).childOption(ChannelOption.SO_REUSEADDR, (Object)NioConfig.CFG.isSoReuseAddr()).childOption(ChannelOption.SO_KEEPALIVE, (Object)NioConfig.CFG.isSoKeepAlive()).childOption(ChannelOption.TCP_NODELAY, (Object)NioConfig.CFG.isSoTcpNodelay()).childOption(ChannelOption.SO_LINGER, (Object)NioConfig.CFG.getSoLinger()).childOption(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)(NioConfig.CFG.getSoConnectionTimeout() * 1000)).childOption(ChannelOption.SO_RCVBUF, (Object)NioConfig.CFG.getSoRcvBuf()).childOption(ChannelOption.SO_SNDBUF, (Object)NioConfig.CFG.getSoSndBuf()).childOption(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT);
        ((ServerBootstrap)boot.group(bossGroup, workerGroup).channel(serverChannelClass)).childHandler((ChannelHandler)new NioServerHttpInitializer(jdkSslContext, nettySslContext, clientAuth.equals((Object)ClientAuth.REQUIRE), NioConfig.CFG));
        for (String bindAddr : bindingAddresses.keySet()) {
            String protocol;
            Object sslMode;
            if (jdkSslContext == null && nettySslContext == null) {
                sslMode = "non-ssl";
                protocol = multiplexer + " http://";
            } else {
                sslMode = "Client Auth: " + clientAuth;
                protocol = multiplexer + " https://";
            }
            int listeningPort = bindingAddresses.get(bindAddr);
            ChannelFuture f = boot.bind(bindAddr, listeningPort).sync();
            f.channel().closeFuture().addListener((GenericFutureListener)((ChannelFutureListener)arg_0 -> NioServer.lambda$bind$0((String)sslMode, arg_0)));
            log.info(() -> NioServer.lambda$bind$1((String)sslMode, protocol, bindAddr, listeningPort));
            if (listener == null) continue;
            listener.onNIOBindNewPort(BootConstant.VERSION, (String)sslMode, protocol, bindAddr, listeningPort, NioServerContext.getWebApiContextRoot());
        }
        AtomicReference<Long> lastBizHitRef = new AtomicReference<Long>();
        lastBizHitRef.set(-1L);
        if (listener != null || log.isDebugEnabled()) {
            int interval = 1;
            QPS_SERVICE.scheduleAtFixedRate(() -> {
                long hps = NioServerContext.COUNTER_HIT.getAndSet(0L);
                long tps = NioServerContext.COUNTER_SENT.getAndSet(0L);
                if (listener == null && !log.isDebugEnabled()) {
                    return;
                }
                long bizHit = NioServerContext.COUNTER_BIZ_HIT.get();
                if ((Long)lastBizHitRef.get() == bizHit && !HealthMonitor.isServicePaused()) {
                    return;
                }
                lastBizHitRef.set(bizHit);
                ThreadPoolExecutor tpe = NioConfig.CFG.getBizExecutor();
                int active = tpe.getActiveCount();
                int queue = tpe.getQueue().size();
                if (hps > 0L || tps > 0L || active > 0 || queue > 0 || HealthMonitor.isServicePaused()) {
                    long totalChannel = NioServerContext.COUNTER_TOTAL_CHANNEL.get();
                    long activeChannel = NioServerContext.COUNTER_ACTIVE_CHANNEL.get();
                    long pool = tpe.getPoolSize();
                    int core = tpe.getCorePoolSize();
                    long max = tpe.getMaximumPoolSize();
                    long largest = tpe.getLargestPoolSize();
                    long task = tpe.getTaskCount();
                    long completed = tpe.getCompletedTaskCount();
                    long pingHit = NioServerContext.COUNTER_PING_HIT.get();
                    long totalHit = bizHit + pingHit;
                    log.debug(() -> "hps=" + hps + ", tps=" + tps + ", activeChannel=" + activeChannel + ", totalChannel=" + totalChannel + ", totalHit=" + totalHit + " (ping" + pingHit + " + biz" + bizHit + "), task=" + task + ", completed=" + completed + ", queue=" + queue + ", active=" + active + ", pool=" + pool + ", core=" + core + ", max=" + max + ", largest=" + largest);
                    if (listener != null) {
                        listener.onNIOAccessReportUpdate(hps, tps, totalHit, pingHit, bizHit, totalChannel, activeChannel, task, completed, queue, active, pool, core, max, largest);
                    }
                }
            }, 0L, interval, TimeUnit.SECONDS);
        }
    }

    static void shutdown() {
        String tn = Thread.currentThread().getName();
        if (bossGroup != null && !bossGroup.isShutdown()) {
            System.out.println(tn + ": shutdown bossGroup");
            bossGroup.shutdownGracefully();
        }
        if (workerGroup != null && !workerGroup.isShutdown()) {
            System.out.println(tn + ": shutdown workerGroup");
            workerGroup.shutdownGracefully();
        }
        if (!QPS_SERVICE.isShutdown()) {
            System.out.println(tn + ": shutdown QPS_SERVICE");
            QPS_SERVICE.shutdownNow();
        }
    }

    private static /* synthetic */ Object lambda$bind$1(String sslMode, String protocol, String bindAddr, int listeningPort) {
        return "Server " + BootConstant.VERSION + " (" + sslMode + ") is listening on " + protocol + bindAddr + ":" + listeningPort + NioServerContext.getWebApiContextRoot();
    }

    private static /* synthetic */ void lambda$bind$0(String sslMode, ChannelFuture f1) throws Exception {
        System.out.println("Server " + BootConstant.VERSION + " (" + sslMode + ") is stopped");
    }

    static {
        QPS_SERVICE = Executors.newSingleThreadScheduledExecutor();
        listener = null;
    }
}

