/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.nio.server;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.websocketx.extensions.compression.WebSocketServerCompressionHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.stream.ChunkedWriteHandler;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.summerboot.jexpress.nio.server.HeartbeatRecIdleStateHandler;
import org.summerboot.jexpress.nio.server.HeartbeatSentIdleStateHandler;
import org.summerboot.jexpress.nio.server.NioConfig;
import org.summerboot.jexpress.nio.server.NioServerContext;

class NioServerHttpInitializer
extends ChannelInitializer<SocketChannel> {
    private static final Logger log = LogManager.getLogger((String)NioServerHttpInitializer.class.getName());
    private final SslContext nettySslContext;
    private final SSLContext jdkSslContext;
    private final boolean verifyClient;
    private final NioConfig cfg;
    private final boolean isHttpService;

    NioServerHttpInitializer(SSLContext jdkSSLContext, SslContext nettySslContext, boolean verifyClient, NioConfig cfg) {
        this.jdkSslContext = jdkSSLContext;
        this.nettySslContext = nettySslContext;
        this.verifyClient = verifyClient;
        this.cfg = cfg;
        this.isHttpService = cfg.isHttpService();
    }

    private void configureSsl(SocketChannel ch, ChannelPipeline p) {
        SslHandler sslHandler = null;
        if (this.nettySslContext != null) {
            sslHandler = this.nettySslContext.newHandler(ch.alloc());
            if (this.cfg.isVerifyCertificateHost()) {
                SSLEngine sslEngine = sslHandler.engine();
                SSLParameters sslParameters = sslEngine.getSSLParameters();
                sslParameters.setEndpointIdentificationAlgorithm("HTTPS");
                sslEngine.setSSLParameters(sslParameters);
            }
        } else if (this.jdkSslContext != null) {
            String[] cipherSuites;
            SSLEngine engine = this.jdkSslContext.createSSLEngine();
            engine.setUseClientMode(false);
            engine.setNeedClientAuth(this.verifyClient);
            engine.setWantClientAuth(this.verifyClient);
            String[] protocols = this.cfg.getSslProtocols();
            if (protocols != null && protocols.length > 0) {
                engine.setEnabledProtocols(protocols);
            }
            if ((cipherSuites = this.cfg.getSslCipherSuites()) != null && cipherSuites.length > 0) {
                engine.setEnabledCipherSuites(cipherSuites);
            }
            sslHandler = new SslHandler(engine);
            long sslHandshakeTimeout = this.cfg.getSslHandshakeTimeout();
            if (sslHandshakeTimeout > 0L) {
                sslHandler.setHandshakeTimeout(sslHandshakeTimeout, TimeUnit.SECONDS);
            }
            if (log.isTraceEnabled()) {
                for (String s : engine.getEnabledProtocols()) {
                    log.trace("\tProtocol = " + s);
                }
                for (String s : engine.getEnabledCipherSuites()) {
                    log.trace("\tCipher = " + s);
                }
            }
        }
        if (sslHandler != null) {
            p.addLast("ssl", (ChannelHandler)sslHandler);
        }
    }

    public void initChannel(SocketChannel ch) {
        ChannelHandler chl;
        long tc = NioServerContext.COUNTER_TOTAL_CHANNEL.incrementAndGet();
        log.debug(() -> tc + "[" + ((Object)((Object)this)).hashCode() + "]" + ch);
        ChannelPipeline p = ch.pipeline();
        this.configureSsl(ch, p);
        if (this.cfg.getReaderIdleTime() > 0) {
            p.addLast("tcp-pong", (ChannelHandler)new HeartbeatRecIdleStateHandler(this.cfg.getReaderIdleTime()));
        }
        if (this.cfg.getWriterIdleTime() > 0) {
            p.addLast("tcp-ping", (ChannelHandler)new HeartbeatSentIdleStateHandler(this.cfg.getWriterIdleTime()));
        }
        if (this.isHttpService) {
            p.addLast("http-codec", (ChannelHandler)new HttpServerCodec(this.cfg.getHttpServerCodec_MaxInitialLineLength(), this.cfg.getHttpServerCodec_MaxHeaderSize(), this.cfg.getHttpServerCodec_MaxChunkSize()));
            chl = this.cfg.getHttpFileUploadHandler();
            if (chl != null) {
                p.addLast("biz-fileUploadHandler", chl);
            }
            p.addLast("http-aggregator", (ChannelHandler)new HttpObjectAggregator(this.cfg.getHttpObjectAggregatorMaxContentLength()));
            p.addLast("http-chunked", (ChannelHandler)new ChunkedWriteHandler());
        }
        if ((chl = this.cfg.getPingHandler()) != null) {
            p.addLast("biz-pingHandler", chl);
        }
        if (this.cfg.isCompressWebSocket()) {
            p.addLast(new ChannelHandler[]{new WebSocketServerCompressionHandler()});
        }
        p.addLast("biz-requestHandler", this.cfg.getRequestHandler());
    }
}

