/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.nio.server;

import com.google.inject.Inject;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.util.ReferenceCountUtil;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.RejectedExecutionException;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.summerboot.jexpress.nio.server.ErrorAuditor;
import org.summerboot.jexpress.nio.server.HttpConfig;
import org.summerboot.jexpress.nio.server.NioConfig;
import org.summerboot.jexpress.nio.server.NioHttpUtil;
import org.summerboot.jexpress.nio.server.NioServerContext;
import org.summerboot.jexpress.nio.server.RequestProcessor;
import org.summerboot.jexpress.nio.server.annotation.Controller;
import org.summerboot.jexpress.nio.server.domain.Err;
import org.summerboot.jexpress.nio.server.domain.ServiceContext;
import org.summerboot.jexpress.nio.server.domain.ServiceError;
import org.summerboot.jexpress.nio.server.ws.rs.JaxRsRequestProcessorManager;

@ChannelHandler.Sharable
public abstract class NioServerHttpRequestHandler
extends SimpleChannelInboundHandler<FullHttpRequest>
implements ErrorAuditor {
    protected Logger log = LogManager.getLogger(this.getClass());
    private final String me = ", hdl=" + this.toString();

    public NioServerHttpRequestHandler() {
        super(FullHttpRequest.class, false);
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        this.log.trace(() -> evt + " - " + this.info(ctx));
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        long tc = NioServerContext.COUNTER_ACTIVE_CHANNEL.incrementAndGet();
        this.log.trace(() -> tc + " - " + this.info(ctx));
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        NioServerContext.COUNTER_ACTIVE_CHANNEL.decrementAndGet();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable ex) {
        if (ex instanceof DecoderException) {
            this.log.warn(ctx.channel().remoteAddress() + ": " + ex);
        } else {
            this.log.warn(ctx.channel().remoteAddress() + ": " + ex, ex);
        }
        if (ex instanceof OutOfMemoryError) {
            ctx.close();
        }
    }

    public void channelReadComplete(ChannelHandlerContext ctx) {
        this.log.trace(() -> this.info(ctx));
        ctx.flush();
    }

    public void channelRead0(ChannelHandlerContext ctx, FullHttpRequest req) {
        long start = System.currentTimeMillis();
        if (!req.decoderResult().isSuccess()) {
            NioHttpUtil.sendError(ctx, HttpResponseStatus.BAD_REQUEST, 4, "failed to decode request", null);
            return;
        }
        NioConfig cfg = NioConfig.CFG;
        NioServerContext.COUNTER_HIT.incrementAndGet();
        long hitIndex = NioServerContext.COUNTER_BIZ_HIT.incrementAndGet();
        long dataSize = req.content().capacity();
        HttpMethod httpMethod = req.method();
        String httpRequestUri = req.uri();
        boolean isKeepAlive = HttpUtil.isKeepAlive((HttpMessage)req);
        String requestMetaInfo = this.requestMetaInfo(ctx, hitIndex, httpMethod, httpRequestUri, isKeepAlive, dataSize);
        this.log.debug(() -> requestMetaInfo);
        HttpHeaders requestHeaders = req.headers();
        String httpPostRequestBody = HttpMethod.POST.equals((Object)httpMethod) || HttpMethod.PUT.equals((Object)httpMethod) || HttpMethod.PATCH.equals((Object)httpMethod) || HttpMethod.DELETE.equals((Object)httpMethod) ? NioHttpUtil.getHttpPostBodyString(req) : null;
        ReferenceCountUtil.release((Object)req);
        QueryStringDecoder queryStringDecoder = new QueryStringDecoder(httpRequestUri, StandardCharsets.UTF_8);
        Runnable asyncTask = () -> {
            block23: {
                long queuingTime = System.currentTimeMillis() - start;
                ServiceContext context = ServiceContext.build(ctx, hitIndex, start, requestHeaders, httpMethod, httpRequestUri, httpPostRequestBody).responseHeaders(HttpConfig.CFG.getServerDefaultResponseHeaders()).clientAcceptContentType(requestHeaders.get((CharSequence)HttpHeaderNames.ACCEPT));
                String acceptCharset = requestHeaders.get((CharSequence)HttpHeaderNames.ACCEPT_CHARSET);
                if (StringUtils.isNotBlank((CharSequence)acceptCharset)) {
                    context.charsetName(acceptCharset);
                }
                long responseContentLength = -1L;
                Throwable ioEx = null;
                long processTime = -1L;
                this.service(ctx, requestHeaders, httpMethod, queryStringDecoder.path(), queryStringDecoder.parameters(), httpPostRequestBody, context);
                processTime = System.currentTimeMillis() - start;
                responseContentLength = NioHttpUtil.sendResponse(ctx, isKeepAlive, context, this);
                context.timestampPOI("service.end");
                long responseTime = System.currentTimeMillis() - start;
                NioServerContext.COUNTER_SENT.incrementAndGet();
                Level level = context.level();
                String report = null;
                if (this.log.isEnabled(level)) {
                    boolean overtime;
                    Object caller = context.caller();
                    ServiceError error2 = context.error();
                    boolean bl = overtime = responseTime > (long)cfg.getBizTimeoutWarnThreshold();
                    if (overtime && level.isLessSpecificThan(Level.WARN)) {
                        level = Level.WARN;
                    }
                    StringBuilder sb = new StringBuilder();
                    sb.append("request_").append(hitIndex).append(".caller=").append((Object)(caller == null ? context.callerId() : caller));
                    sb.append("\n\t").append(requestMetaInfo).append("\n\tresponsed_").append(hitIndex).append("=").append(context.status()).append(", error=").append(error2 == null ? 0 : error2.getErrors().size()).append(", queuing=").append(queuingTime).append("ms, process=").append(processTime);
                    if (overtime) {
                        sb.append("ms, response.ot=");
                    } else {
                        sb.append("ms, response=");
                    }
                    sb.append(responseTime).append("ms, cont.len=").append(responseContentLength).append("bytes");
                    context.reportPOI(cfg, sb);
                    this.verboseClientServerCommunication(cfg, requestHeaders, httpPostRequestBody, context, sb);
                    context.reportMemo(sb);
                    sb.append(System.lineSeparator());
                    report = this.beforeLogging(sb.toString());
                    this.log.log(level, report, context.cause());
                }
                try {
                    this.afterLogging(requestHeaders, httpMethod, httpRequestUri, httpPostRequestBody, context, queuingTime, processTime, responseTime, responseContentLength, report, ioEx);
                }
                catch (Throwable ex) {
                    this.log.error("report failed", ex);
                }
                break block23;
                catch (Throwable ex) {
                    try {
                        ioEx = ex;
                        Err e = new Err(2, null, "Failed to send context to client", ex);
                        context.error(e).status(HttpResponseStatus.INTERNAL_SERVER_ERROR).level(Level.FATAL);
                        responseContentLength = NioHttpUtil.sendResponse(ctx, isKeepAlive, context, this);
                    }
                    catch (Throwable throwable) {
                        long responseTime2 = System.currentTimeMillis() - start;
                        NioServerContext.COUNTER_SENT.incrementAndGet();
                        Level level2 = context.level();
                        String report2 = null;
                        if (this.log.isEnabled(level2)) {
                            boolean overtime;
                            Object caller = context.caller();
                            ServiceError error3 = context.error();
                            boolean bl = overtime = responseTime2 > (long)cfg.getBizTimeoutWarnThreshold();
                            if (overtime && level2.isLessSpecificThan(Level.WARN)) {
                                level2 = Level.WARN;
                            }
                            StringBuilder sb = new StringBuilder();
                            sb.append("request_").append(hitIndex).append(".caller=").append((Object)(caller == null ? context.callerId() : caller));
                            sb.append("\n\t").append(requestMetaInfo).append("\n\tresponsed_").append(hitIndex).append("=").append(context.status()).append(", error=").append(error3 == null ? 0 : error3.getErrors().size()).append(", queuing=").append(queuingTime).append("ms, process=").append(processTime);
                            if (overtime) {
                                sb.append("ms, response.ot=");
                            } else {
                                sb.append("ms, response=");
                            }
                            sb.append(responseTime2).append("ms, cont.len=").append(responseContentLength).append("bytes");
                            context.reportPOI(cfg, sb);
                            this.verboseClientServerCommunication(cfg, requestHeaders, httpPostRequestBody, context, sb);
                            context.reportMemo(sb);
                            sb.append(System.lineSeparator());
                            report2 = this.beforeLogging(sb.toString());
                            this.log.log(level2, report2, context.cause());
                        }
                        try {
                            this.afterLogging(requestHeaders, httpMethod, httpRequestUri, httpPostRequestBody, context, queuingTime, processTime, responseTime2, responseContentLength, report2, ioEx);
                        }
                        catch (Throwable ex2) {
                            this.log.error("report failed", ex2);
                        }
                        throw throwable;
                    }
                    responseTime = System.currentTimeMillis() - start;
                    NioServerContext.COUNTER_SENT.incrementAndGet();
                    level = context.level();
                    report = null;
                    if (this.log.isEnabled(level)) {
                        boolean overtime;
                        Object caller = context.caller();
                        ServiceError error4 = context.error();
                        boolean bl = overtime = responseTime > (long)cfg.getBizTimeoutWarnThreshold();
                        if (overtime && level.isLessSpecificThan(Level.WARN)) {
                            level = Level.WARN;
                        }
                        StringBuilder sb = new StringBuilder();
                        sb.append("request_").append(hitIndex).append(".caller=").append((Object)(caller == null ? context.callerId() : caller));
                        sb.append("\n\t").append(requestMetaInfo).append("\n\tresponsed_").append(hitIndex).append("=").append(context.status()).append(", error=").append(error4 == null ? 0 : error4.getErrors().size()).append(", queuing=").append(queuingTime).append("ms, process=").append(processTime);
                        if (overtime) {
                            sb.append("ms, response.ot=");
                        } else {
                            sb.append("ms, response=");
                        }
                        sb.append(responseTime).append("ms, cont.len=").append(responseContentLength).append("bytes");
                        context.reportPOI(cfg, sb);
                        this.verboseClientServerCommunication(cfg, requestHeaders, httpPostRequestBody, context, sb);
                        context.reportMemo(sb);
                        sb.append(System.lineSeparator());
                        report = this.beforeLogging(sb.toString());
                        this.log.log(level, report, context.cause());
                    }
                    try {
                        this.afterLogging(requestHeaders, httpMethod, httpRequestUri, httpPostRequestBody, context, queuingTime, processTime, responseTime, responseContentLength, report, ioEx);
                    }
                    catch (Throwable ex3) {
                        this.log.error("report failed", ex3);
                    }
                }
            }
        };
        try {
            cfg.getBizExecutor().execute(asyncTask);
        }
        catch (RejectedExecutionException ex) {
            long queuingTime = System.currentTimeMillis() - start;
            ServiceContext context = ServiceContext.build(ctx, hitIndex, start, requestHeaders, httpMethod, httpRequestUri, httpPostRequestBody).responseHeaders(HttpConfig.CFG.getServerDefaultResponseHeaders()).clientAcceptContentType(requestHeaders.get((CharSequence)HttpHeaderNames.ACCEPT));
            Err e = new Err(3, null, "Too many requests", ex);
            context.error(e).status(HttpResponseStatus.TOO_MANY_REQUESTS).level(Level.FATAL);
            long responseContentLength = NioHttpUtil.sendResponse(ctx, isKeepAlive, context, this);
            StringBuilder sb = new StringBuilder();
            sb.append("request_").append(hitIndex).append("=").append(ex.toString()).append("ms\n\t").append(requestMetaInfo).append("\n\tresponsed#").append(hitIndex).append("=").append(context.status()).append(", errorCode=").append(e.getErrorCode()).append(", queuing=").append(queuingTime).append("ms, cont.len=").append(responseContentLength).append("\n\t1req.headers=").append(requestHeaders).append("\n\t4resp.body=").append(context.txt());
            this.log.fatal(sb.toString());
        }
        catch (Throwable ex) {
            long queuingTime = System.currentTimeMillis() - start;
            ServiceContext context = ServiceContext.build(ctx, hitIndex, start, requestHeaders, httpMethod, httpRequestUri, httpPostRequestBody).responseHeaders(HttpConfig.CFG.getServerDefaultResponseHeaders()).clientAcceptContentType(requestHeaders.get((CharSequence)HttpHeaderNames.ACCEPT));
            Err e = new Err(1, null, "NIO unexpected executor failure", ex);
            context.error(e).status(HttpResponseStatus.INTERNAL_SERVER_ERROR).level(Level.FATAL);
            long responseContentLength = NioHttpUtil.sendResponse(ctx, isKeepAlive, context, this);
            StringBuilder sb = new StringBuilder();
            sb.append("request_").append(hitIndex).append("=").append(ex.toString()).append("ms\n\t").append(requestMetaInfo).append("\n\tresponsed#").append(hitIndex).append("=").append(context.status()).append(", errorCode=").append(e.getErrorCode()).append(", queuing=").append(queuingTime).append("ms, cont.len=").append(responseContentLength).append("\n\t1req.headers=").append(requestHeaders).append("\n\t4resp.body=").append(context.txt());
            this.log.fatal(sb.toString());
        }
    }

    private String info(ChannelHandlerContext ctx) {
        return ", chn=" + ctx.channel() + ", ctx=" + ctx.hashCode() + this.me;
    }

    private String requestMetaInfo(ChannelHandlerContext ctx, long hitIndex, HttpMethod httpMethod, String httpRequestUri, boolean isKeepAlive, long dataSize) {
        return "request_" + hitIndex + "=" + httpMethod + " " + httpRequestUri + ", dataSize=" + dataSize + ", KeepAlive=" + isKeepAlive + ", chn=" + ctx.channel() + ", ctx=" + ctx.hashCode() + this.me;
    }

    private void verboseClientServerCommunication(NioConfig cfg, HttpHeaders httpHeaders, String httpPostRequestBody, ServiceContext context, StringBuilder sb) {
        boolean isInFilter = false;
        Object caller = context.caller();
        switch (cfg.getFilterUserType()) {
            case ignore: {
                isInFilter = true;
                break;
            }
            case uid: {
                if (!StringUtils.isNotBlank((CharSequence)context.callerId())) break;
                isInFilter = cfg.getFilterCallerNameSet().contains(context.callerId());
                break;
            }
            case id: {
                if (caller == null || caller.getId() == null) break;
                Long target2 = caller.getId().longValue();
                Set<Long> s = cfg.getFilterCallerIdSet();
                if (s == null) {
                    isInFilter = target2 >= cfg.getFilterCallerIdFrom() && target2 <= cfg.getFilterCallerIdTo();
                    break;
                }
                isInFilter = s.contains(target2);
                break;
            }
            case group: {
                if (caller == null) break;
                isInFilter = cfg.getFilterCallerNameSet().stream().anyMatch(target -> caller.isInGroup((String)target));
                break;
            }
            case role: {
                if (caller == null) break;
                isInFilter = cfg.getFilterCallerNameSet().stream().anyMatch(target -> caller.isInRole((String)target));
            }
        }
        if (!isInFilter) {
            return;
        }
        isInFilter = false;
        Set<Long> s = cfg.getFilterCodeSet();
        block7 : switch (cfg.getFilterCodeType()) {
            case all: {
                isInFilter = true;
                break;
            }
            case ignore: {
                isInFilter = false;
                break;
            }
            case HttpStatusCode: {
                long target3 = context.status().code();
                if (s == null) {
                    isInFilter = target3 >= cfg.getFilterCodeRangeFrom() && target3 <= cfg.getFilterCodeRangeTo();
                    break;
                }
                isInFilter = s.contains(target3);
                break;
            }
            case AppErrorCode: {
                ServiceError e = context.error();
                if (e == null) break;
                for (Err j : e.getErrors()) {
                    long target4 = j.getErrorCode();
                    isInFilter = s == null ? target4 >= cfg.getFilterCodeRangeFrom() && target4 <= cfg.getFilterCodeRangeTo() : s.contains(target4);
                    if (!isInFilter) continue;
                    break block7;
                }
                break;
            }
        }
        if (!isInFilter) {
            return;
        }
        if (!context.privacyReqHeader() && cfg.isVerboseReqHeader()) {
            sb.append("\n\t1.client_req.headers=").append(httpHeaders);
        }
        if (!context.privacyReqContent() && cfg.isVerboseReqContent()) {
            sb.append("\n\t2.client_req.body=").append(httpPostRequestBody);
        }
        if (!context.privacyRespHeader() && cfg.isVerboseRespHeader()) {
            sb.append("\n\t3.server_resp.headers=").append(context.responseHeaders());
        }
        if (!context.privacyRespContent() && cfg.isVerboseRespContent()) {
            sb.append("\n\t4.server_resp.body=").append(context.txt());
        }
    }

    protected abstract void service(ChannelHandlerContext var1, HttpHeaders var2, HttpMethod var3, String var4, Map<String, List<String>> var5, String var6, ServiceContext var7);

    protected abstract String beforeLogging(String var1);

    protected abstract void afterLogging(HttpHeaders var1, HttpMethod var2, String var3, String var4, ServiceContext var5, long var6, long var8, long var10, long var12, String var14, Throwable var15) throws Exception;

    @Inject
    protected void guiceCallback_RegisterControllers(@Controller Map<String, Object> controllers) {
        JaxRsRequestProcessorManager.registerControllers(controllers);
    }

    protected RequestProcessor getRequestProcessor(HttpMethod httptMethod, String httpRequestPath) {
        return JaxRsRequestProcessorManager.getRequestProcessor(httptMethod, httpRequestPath);
    }
}

