/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.nio.server.domain;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.SocketAddress;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.logging.log4j.Level;
import org.summerboot.jexpress.nio.server.HttpConfig;
import org.summerboot.jexpress.nio.server.NioConfig;
import org.summerboot.jexpress.nio.server.NioHttpUtil;
import org.summerboot.jexpress.nio.server.domain.Err;
import org.summerboot.jexpress.nio.server.domain.ServiceError;
import org.summerboot.jexpress.security.auth.Caller;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
public class ServiceContext {
    private final SocketAddress localIP;
    private final SocketAddress remoteIP;
    private final HttpMethod requesMethod;
    private final String requesURI;
    private final HttpHeaders requestHeaders;
    private final String requestBody;
    private final long hit;
    private final long startTs;
    private Caller caller;
    private String callerId;
    private HttpResponseStatus status = HttpResponseStatus.OK;
    private boolean autoConvertBlank200To204 = true;
    private HttpHeaders responseHeaders;
    private String contentType;
    private String clientAcceptContentType;
    private String charsetName;
    private byte[] data;
    private String txt = "";
    private File file;
    private boolean downloadMode = true;
    private String redirect;
    private final List<POI> poi = new ArrayList<POI>();
    private List<Memo> memo;
    private Map<String, Object> attributes;
    private ServiceError serviceError;
    private Throwable cause;
    private Level level = Level.INFO;
    private boolean privacyReqHeader = false;
    private boolean privacyRespHeader = false;
    private boolean privacyReqContent = false;
    private boolean privacyRespContent = false;

    public static ServiceContext build(long hit) {
        return new ServiceContext(null, hit, System.currentTimeMillis(), null, null, null, null);
    }

    public static ServiceContext build(ChannelHandlerContext ctx, long hit, long startTs, HttpHeaders requestHeaders, HttpMethod requesMethod, String requesURI, String requestBody) {
        return new ServiceContext(ctx, hit, startTs, requestHeaders, requesMethod, requesURI, requestBody);
    }

    public String toString() {
        return "ServiceContext{status=" + this.status + ", responseHeaders=" + this.responseHeaders + ", contentType=" + this.contentType + ", data=" + this.data + ", txt=" + this.txt + ", errors=" + this.serviceError + ", level=" + this.level + ", logReqHeader=" + this.privacyReqHeader + ", logRespHeader=" + this.privacyRespHeader + ", logReqContent=" + this.privacyReqContent + ", logRespContent=" + this.privacyRespContent + "}";
    }

    private ServiceContext(ChannelHandlerContext ctx, long hit, long startTs, HttpHeaders requestHeaders, HttpMethod requesMethod, String requesURI, String requestBody) {
        if (ctx != null && ctx.channel() != null) {
            this.localIP = ctx.channel().localAddress();
            this.remoteIP = ctx.channel().remoteAddress();
        } else {
            this.localIP = null;
            this.remoteIP = null;
        }
        this.hit = hit;
        this.startTs = startTs;
        this.requestHeaders = requestHeaders;
        this.requesMethod = requesMethod;
        this.requesURI = requesURI;
        this.requestBody = requestBody;
        this.poi.add(new POI("service.begin"));
    }

    public Object attribute(String key) {
        return this.attributes == null ? null : this.attributes.get(key);
    }

    public ServiceContext attribute(String key, Object value) {
        if (this.attributes == null) {
            if (key == null || value == null) {
                return this;
            }
            this.attributes = new HashMap<String, Object>();
        }
        if (value == null) {
            this.attributes.remove(key);
        } else {
            this.attributes.put(key, value);
        }
        return this;
    }

    public SocketAddress localIP() {
        return this.localIP;
    }

    public SocketAddress remoteIP() {
        return this.remoteIP;
    }

    public long startTimestamp() {
        return this.startTs;
    }

    public ServiceContext reset() {
        this.status = HttpResponseStatus.OK;
        this.data = null;
        this.txt = "";
        this.file = null;
        this.redirect = null;
        this.serviceError = null;
        this.cause = null;
        this.level = Level.INFO;
        this.privacyReqHeader = false;
        this.privacyRespHeader = false;
        this.privacyReqContent = false;
        this.privacyRespContent = false;
        return this;
    }

    public long hit() {
        return this.hit;
    }

    public HttpMethod method() {
        return this.requesMethod;
    }

    public String uri() {
        return this.requesURI;
    }

    public String requestBody() {
        return this.requestBody;
    }

    public HttpResponseStatus status() {
        return this.status;
    }

    public ServiceContext status(HttpResponseStatus status) {
        this.status = status;
        return this;
    }

    public HttpHeaders requestHeaders() {
        return this.requestHeaders;
    }

    public HttpHeaders responseHeaders() {
        return this.responseHeaders;
    }

    public ServiceContext responseHeaders(HttpHeaders headers) {
        if (headers == null || headers.isEmpty()) {
            return this;
        }
        if (this.responseHeaders == null) {
            this.responseHeaders = new DefaultHttpHeaders(true);
        }
        this.responseHeaders.set(headers);
        return this;
    }

    public ServiceContext responseHeader(String key, Object value) {
        if (StringUtils.isBlank((CharSequence)key)) {
            return this;
        }
        if (this.responseHeaders == null) {
            this.responseHeaders = new DefaultHttpHeaders(true);
        }
        if (value == null) {
            this.responseHeaders.remove(key);
        } else {
            this.responseHeaders.set(key, value);
        }
        return this;
    }

    public ServiceContext responseHeader(String key, Iterable<?> values) {
        if (StringUtils.isBlank((CharSequence)key)) {
            return this;
        }
        if (this.responseHeaders == null) {
            this.responseHeaders = new DefaultHttpHeaders(true);
        }
        if (values == null) {
            this.responseHeaders.remove(key);
        } else {
            this.responseHeaders.set(key, values);
        }
        return this;
    }

    public ServiceContext responseHeaders(Map<String, Iterable<?>> hs) {
        if (hs == null) {
            return this;
        }
        if (this.responseHeaders == null) {
            this.responseHeaders = new DefaultHttpHeaders(true);
        }
        hs.keySet().stream().filter(key -> StringUtils.isNotBlank((CharSequence)key)).forEachOrdered(key -> {
            Iterable values = (Iterable)hs.get(key);
            if (values == null) {
                this.responseHeaders.remove(key);
            } else {
                this.responseHeaders.set(key, values);
            }
        });
        return this;
    }

    public String contentType() {
        return this.contentType;
    }

    public ServiceContext contentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public String clientAcceptContentType() {
        return this.clientAcceptContentType;
    }

    public ServiceContext clientAcceptContentType(String clientAcceptContentType) {
        this.clientAcceptContentType = clientAcceptContentType;
        return this;
    }

    public String charsetName() {
        return this.charsetName;
    }

    public ServiceContext charsetName(String charsetName) {
        this.charsetName = charsetName;
        return this;
    }

    public String redirect() {
        return this.redirect;
    }

    public ServiceContext redirect(String redirect) {
        return this.redirect(redirect, HttpResponseStatus.TEMPORARY_REDIRECT);
    }

    public ServiceContext redirect(String redirect, HttpResponseStatus status) {
        this.redirect = redirect;
        this.txt = null;
        this.file = null;
        this.status = status;
        this.responseHeader(HttpHeaderNames.LOCATION.toString(), redirect);
        return this;
    }

    public String txt() {
        return this.txt;
    }

    public ServiceContext txt(String txt) {
        this.txt = txt;
        return this;
    }

    public byte[] data() {
        return this.data;
    }

    public ServiceContext data(byte[] data) {
        this.data = data;
        return this;
    }

    public File file() {
        return this.file;
    }

    public boolean isDownloadMode() {
        return this.downloadMode;
    }

    public ServiceContext downloadMode(boolean downloadMode) {
        this.downloadMode = downloadMode;
        return this;
    }

    public boolean precheckFolder(File folder) {
        this.file = null;
        String filePath = folder.getAbsolutePath();
        String realPath = folder.getAbsoluteFile().toPath().normalize().toString();
        this.memo("folder.view", filePath);
        if (!folder.exists()) {
            Err e = new Err(32, null, "\u26a0", null);
            this.status(HttpResponseStatus.NOT_FOUND).error(e);
            return false;
        }
        if (!NioHttpUtil.sanitizePath(filePath) || !filePath.equals(realPath) || !folder.isDirectory() || folder.isFile() || folder.isHidden() || !folder.canRead()) {
            Err e = new Err(31, null, "\u26a0", null);
            this.status(HttpResponseStatus.FORBIDDEN).error(e);
            return false;
        }
        return true;
    }

    public boolean precheckFile(File file, boolean isDownloadMode) {
        this.file = null;
        String filePath = file.getAbsolutePath();
        String realPath = file.getAbsoluteFile().toPath().normalize().toString();
        this.memo("file." + (isDownloadMode ? "download" : "view"), filePath);
        if (!file.exists()) {
            Err e = new Err(32, null, "\u26a0", null);
            this.status(HttpResponseStatus.NOT_FOUND).error(e);
            return false;
        }
        if (!NioHttpUtil.sanitizePath(filePath) || !filePath.equals(realPath) || file.isDirectory() || !file.isFile() || file.isHidden() || !file.canRead()) {
            Err e = new Err(31, null, "\u26a0", null);
            this.status(HttpResponseStatus.FORBIDDEN).error(e);
            return false;
        }
        return true;
    }

    public ServiceContext file(File file, boolean isDownloadMode) {
        this.downloadMode = isDownloadMode;
        return this.file(file);
    }

    public ServiceContext file(File file) {
        long fileLength;
        if (!this.precheckFile(file, this.downloadMode)) {
            String errorFileName = this.status.code() + (this.downloadMode ? ".txt" : ".html");
            file = new File(HttpConfig.CFG.getDocroot() + File.separator + HttpConfig.CFG.getWebResources() + File.separator + errorFileName).getAbsoluteFile();
        }
        this.txt = null;
        this.redirect = null;
        this.file = file;
        this.contentType = NioHttpUtil.getFileContentType(file);
        if (!this.downloadMode) {
            this.serviceError = null;
        }
        if (this.responseHeaders == null) {
            this.responseHeaders = new DefaultHttpHeaders(true);
        }
        if ((fileLength = file.length()) > Integer.MAX_VALUE) {
            this.responseHeaders.set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)String.valueOf(fileLength));
        } else {
            this.responseHeaders.setInt((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (int)fileLength);
        }
        this.responseHeaders.set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)this.contentType);
        if (this.downloadMode) {
            String fileName = file.getName();
            try {
                fileName = URLEncoder.encode(fileName, "UTF-8").replace("+", "%20");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            this.responseHeaders.set((CharSequence)HttpHeaderNames.CONTENT_DISPOSITION, (Object)("attachment;filename=" + fileName + ";filename*=UTF-8''" + fileName));
        }
        this.status(HttpResponseStatus.OK);
        return this;
    }

    public <T extends Caller> T caller() {
        return (T)this.caller;
    }

    public <T extends Caller> ServiceContext caller(T caller) {
        this.caller = caller;
        return this;
    }

    public String callerId() {
        return this.callerId;
    }

    public ServiceContext callerId(String callerId) {
        this.callerId = callerId;
        return this;
    }

    public ServiceError error() {
        if (this.serviceError == null || this.serviceError.getErrors() == null || this.serviceError.getErrors().isEmpty()) {
            return null;
        }
        return this.serviceError;
    }

    public ServiceContext error(Err error2) {
        if (error2 == null) {
            return this;
        }
        if (this.serviceError == null) {
            this.serviceError = new ServiceError(this.hit);
        }
        this.serviceError.addError(error2);
        Throwable t = error2.getEx();
        if (t != null) {
            this.cause = t;
        }
        if (error2.getEx() != null) {
            this.level = Level.ERROR;
        }
        return this;
    }

    public ServiceContext errors(Collection<Err> es) {
        if (es == null || es.isEmpty()) {
            if (this.serviceError != null && this.serviceError.getErrors() != null) {
                this.serviceError.getErrors().clear();
                this.serviceError = null;
            }
            return this;
        }
        if (this.serviceError == null) {
            this.serviceError = new ServiceError(this.hit);
        }
        this.serviceError.addErrors(es);
        for (Err e : es) {
            Throwable t = e.getEx();
            if (t != null) {
                this.cause = t;
            }
            if (this.cause == null) continue;
            this.level = Level.ERROR;
        }
        return this;
    }

    public ServiceContext cause(Throwable cause) {
        this.cause = cause;
        if (cause != null) {
            Throwable root = ExceptionUtils.getRootCause((Throwable)cause);
            if (root == null || root.equals(cause)) {
                if (this.level.isLessSpecificThan(Level.WARN)) {
                    this.level = Level.WARN;
                }
            } else if (this.level.isLessSpecificThan(Level.ERROR)) {
                this.level = Level.ERROR;
            }
        }
        return this;
    }

    public Throwable cause() {
        return this.cause;
    }

    public Level level() {
        return this.level;
    }

    public ServiceContext level(Level level) {
        this.level = level;
        return this;
    }

    public ServiceContext privacyReqHeader(boolean enabled) {
        this.privacyReqHeader = enabled;
        return this;
    }

    public boolean privacyReqHeader() {
        return this.privacyReqHeader;
    }

    public ServiceContext privacyReqContent(boolean enabled) {
        this.privacyReqContent = enabled;
        return this;
    }

    public boolean privacyReqContent() {
        return this.privacyReqContent;
    }

    public ServiceContext privacyRespHeader(boolean enabled) {
        this.privacyRespHeader = enabled;
        return this;
    }

    public boolean privacyRespHeader() {
        return this.privacyRespHeader;
    }

    public ServiceContext privacyRespContent(boolean enabled) {
        this.privacyRespContent = enabled;
        return this;
    }

    public boolean privacyRespContent() {
        return this.privacyRespContent;
    }

    public ServiceContext timestampPOI(String marker) {
        this.poi.add(new POI(marker));
        return this;
    }

    public List<POI> poi() {
        return this.poi;
    }

    public ServiceContext memo(String id, String desc) {
        if (this.memo == null) {
            this.memo = new ArrayList<Memo>();
        }
        this.memo.add(new Memo(id, desc));
        return this;
    }

    public List<Memo> memo() {
        return this.memo;
    }

    public ServiceContext autoConvertBlank200To204(boolean auto) {
        this.autoConvertBlank200To204 = auto;
        return this;
    }

    public boolean autoConvertBlank200To204() {
        return this.autoConvertBlank200To204;
    }

    public ServiceContext reportMemo(StringBuilder sb) {
        if (this.memo == null || this.memo.isEmpty()) {
            sb.append("\n\tMemo: n/a");
            return this;
        }
        sb.append("\n\n\tMemo: ");
        this.memo.forEach(m -> sb.append("\n\t\t").append(m.id).append("=").append(m.desc));
        return this;
    }

    public ServiceContext reportPOI(StringBuilder sb) {
        return this.reportPOI(null, sb);
    }

    public ServiceContext reportPOI(NioConfig cfg, StringBuilder sb) {
        if (this.poi == null || this.poi.isEmpty()) {
            sb.append("\n\tPOI: n/a");
            return this;
        }
        NioConfig.VerboseTargetPOIType filterType = cfg == null ? NioConfig.VerboseTargetPOIType.all : cfg.getFilterPOIType();
        sb.append("\n\tPOI: ");
        switch (filterType) {
            case all: {
                this.poi.forEach(p -> sb.append(p.name).append("=").append(p.ts - this.startTs).append("ms, "));
                break;
            }
            case filter: {
                Set<String> poiSet = cfg.getFilterPOISet();
                this.poi.stream().filter(p -> poiSet.contains(p.name)).forEachOrdered(p -> sb.append(p.name).append("=").append(p.ts - this.startTs).append("ms, "));
                break;
            }
            case ignore: {
                sb.append("off");
            }
        }
        return this;
    }

    public static class POI {
        public final String name;
        public final long ts = System.currentTimeMillis();

        public POI(String name) {
            this.name = name;
        }
    }

    public static class Memo {
        public final String id;
        public final String desc;

        public Memo(String id, String desc) {
            this.id = id;
            this.desc = desc;
        }
    }
}

