/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.nio.server.ws.rs;

import io.netty.handler.codec.http.HttpMethod;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HEAD;
import jakarta.ws.rs.OPTIONS;
import jakarta.ws.rs.PATCH;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import java.lang.invoke.CallSite;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.summerboot.jexpress.nio.server.RequestProcessor;
import org.summerboot.jexpress.nio.server.annotation.Controller;
import org.summerboot.jexpress.nio.server.ws.rs.JaxRsRequestProcessor;

public class JaxRsRequestProcessorManager {
    private static Map<HttpMethod, Map<String, RequestProcessor>> processorMapString;
    private static Map<HttpMethod, Map<String, RequestProcessor>> processorMapRegex;

    public static void registerControllers(@Controller Map<String, Object> controllers) {
        if (controllers == null || controllers.isEmpty()) {
            return;
        }
        HashMap<HttpMethod, Map<String, RequestProcessor>> stringMap = new HashMap<HttpMethod, Map<String, RequestProcessor>>();
        HashMap<HttpMethod, Map<String, RequestProcessor>> regexMap = new HashMap<HttpMethod, Map<String, RequestProcessor>>();
        HashSet<CallSite> errors = new HashSet<CallSite>();
        for (String name : controllers.keySet()) {
            Method[] methods;
            Object javaInstance = controllers.get(name);
            Class<?> controllerClass = javaInstance.getClass();
            String rootPath = null;
            Path rp = controllerClass.getAnnotation(Path.class);
            if (rp != null) {
                rootPath = rp.value().trim();
            }
            for (Method javaMethod : methods = controllerClass.getDeclaredMethods()) {
                HEAD amh;
                PATCH ampc;
                OPTIONS amo;
                DELETE amd;
                PUT ampt;
                POST amp;
                Object path;
                Path ap = javaMethod.getAnnotation(Path.class);
                if (ap == null || (path = StringUtils.isBlank((CharSequence)rootPath) ? ap.value().trim() : rootPath + ap.value().trim()) == null) continue;
                HashSet<HttpMethod> httpMethods = new HashSet<HttpMethod>();
                GET amg = javaMethod.getAnnotation(GET.class);
                if (amg != null) {
                    httpMethods.add(HttpMethod.GET);
                }
                if ((amp = javaMethod.getAnnotation(POST.class)) != null) {
                    httpMethods.add(HttpMethod.POST);
                }
                if ((ampt = javaMethod.getAnnotation(PUT.class)) != null) {
                    httpMethods.add(HttpMethod.PUT);
                }
                if ((amd = javaMethod.getAnnotation(DELETE.class)) != null) {
                    httpMethods.add(HttpMethod.DELETE);
                }
                if ((amo = javaMethod.getAnnotation(OPTIONS.class)) != null) {
                    httpMethods.add(HttpMethod.OPTIONS);
                }
                if ((ampc = javaMethod.getAnnotation(PATCH.class)) != null) {
                    httpMethods.add(HttpMethod.PATCH);
                }
                if ((amh = javaMethod.getAnnotation(HEAD.class)) != null) {
                    httpMethods.add(HttpMethod.HEAD);
                }
                if (httpMethods.isEmpty()) continue;
                for (HttpMethod httpMethod : httpMethods) {
                    String key;
                    JaxRsRequestProcessor processor;
                    try {
                        processor = new JaxRsRequestProcessor(javaInstance, javaMethod, httpMethod, (String)path);
                    }
                    catch (Throwable ex) {
                        errors.add((CallSite)((Object)("failed to create processor for " + controllerClass.getName() + "." + javaMethod.getName() + "\n\t" + ex.toString())));
                        continue;
                    }
                    HashMap<HttpMethod, Map<String, RequestProcessor>> rootMap = processor.isUsingPathParam() || processor.isUsingMatrixPara() ? regexMap : stringMap;
                    HashMap<String, JaxRsRequestProcessor> subMap = (HashMap<String, JaxRsRequestProcessor>)rootMap.get(httpMethod);
                    if (subMap == null) {
                        subMap = new HashMap<String, JaxRsRequestProcessor>();
                        rootMap.put(httpMethod, subMap);
                    }
                    if (subMap.containsKey(key = processor.getDeclaredPath())) {
                        errors.add((CallSite)((Object)("request already exists: " + httpMethod + " '" + (String)path + "' in " + controllerClass.getName() + "." + javaMethod.getName())));
                        continue;
                    }
                    subMap.put(key, processor);
                }
            }
        }
        if (!errors.isEmpty()) {
            System.err.println("Invalid Java methods: \n" + errors);
            System.exit(1);
        }
        processorMapString = stringMap;
        processorMapRegex = regexMap;
    }

    public static RequestProcessor getRequestProcessor(HttpMethod httptMethod, String httpRequestPath) {
        RequestProcessor processor = null;
        Map<String, RequestProcessor> subMap = processorMapString.get(httptMethod);
        if (subMap != null) {
            processor = subMap.get(httpRequestPath);
        }
        if (processor == null && (subMap = processorMapRegex.get(httptMethod)) != null) {
            for (RequestProcessor p : subMap.values()) {
                if (!p.matches(httpRequestPath)) continue;
                processor = p;
                break;
            }
        }
        return processor;
    }

    private static <T> T create(Class<T> clazz) {
        return (T)Proxy.newProxyInstance(clazz.getClassLoader(), clazz.getInterfaces(), new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                boolean flag = method.isAnnotationPresent(GET.class);
                return null;
            }
        });
    }
}

