/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.security;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.JwtParser;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.security.Keys;
import java.security.Key;
import java.security.KeyPair;
import java.util.Base64;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.summerboot.jexpress.security.EncryptorUtil;

public class JwtUtil {
    public static String buildSigningKey(SignatureAlgorithm signatureAlgorithm) {
        SecretKey signingKey = Keys.secretKeyFor((SignatureAlgorithm)signatureAlgorithm);
        return EncryptorUtil.keyToString(signingKey);
    }

    public static KeyPair buildSigningParsingKeyPair(SignatureAlgorithm signatureAlgorithm) {
        return Keys.keyPairFor((SignatureAlgorithm)signatureAlgorithm);
    }

    public static Key parseSigningKey(String encodedKey) {
        byte[] decodedKey = Base64.getDecoder().decode(encodedKey);
        return Keys.hmacShaKeyFor((byte[])decodedKey);
    }

    @Deprecated
    public static String createJWT_091(SignatureAlgorithm signatureAlgorithm, String keyAlgorithm, String jwtSigningKey, String id, String issuer, String subject, String audience, int ttlSeconds) {
        JwtBuilder builder = Jwts.builder().setId(id).setIssuer(issuer).setSubject(subject).setAudience(audience);
        return JwtUtil.createJWT_091(signatureAlgorithm, keyAlgorithm, jwtSigningKey, builder, TimeUnit.SECONDS, ttlSeconds);
    }

    @Deprecated
    public static String createJWT_091(SignatureAlgorithm signatureAlgorithm, String keyAlgorithm, String jwtSigningKey, JwtBuilder builder, TimeUnit timeUnit, int ttl) {
        byte[] key = Base64.getDecoder().decode(jwtSigningKey);
        return JwtUtil.createJWT_091(signatureAlgorithm, keyAlgorithm, key, builder, timeUnit, ttl);
    }

    @Deprecated
    public static String createJWT_091(SignatureAlgorithm signatureAlgorithm, String keyAlgorithm, byte[] jwtSigningKey, String id, String issuer, String subject, String audience, int ttlSeconds) {
        JwtBuilder builder = Jwts.builder().setId(id).setIssuer(issuer).setSubject(subject).setAudience(audience);
        return JwtUtil.createJWT_091(signatureAlgorithm, keyAlgorithm, jwtSigningKey, builder, TimeUnit.SECONDS, ttlSeconds);
    }

    @Deprecated
    public static String createJWT_091(SignatureAlgorithm signatureAlgorithm, String keyAlgorithm, byte[] jwtSigningKey, JwtBuilder builder, TimeUnit timeUnit, int ttl) {
        SecretKeySpec privateKey = new SecretKeySpec(jwtSigningKey, 0, jwtSigningKey.length, keyAlgorithm);
        return JwtUtil.createJWT_091(signatureAlgorithm, privateKey, builder, timeUnit, ttl);
    }

    @Deprecated
    public static String createJWT_091(SignatureAlgorithm signatureAlgorithm, Key privateKey, String id, String issuer, String subject, String audience, int ttlSeconds) {
        JwtBuilder builder = Jwts.builder().setId(id).setIssuer(issuer).setSubject(subject).setAudience(audience);
        return JwtUtil.createJWT_091(signatureAlgorithm, privateKey, builder, TimeUnit.SECONDS, ttlSeconds);
    }

    @Deprecated
    public static String createJWT_091(SignatureAlgorithm signatureAlgorithm, Key privateKey, JwtBuilder builder, TimeUnit timeUnit, int ttl) {
        JwtUtil.setJwtExpireTime(builder, timeUnit, ttl);
        builder.setIssuedAt(new Date());
        builder.signWith(signatureAlgorithm, privateKey);
        return builder.compact();
    }

    public static String createJWT(String keyAlgorithm, String jwtSigningKey, String id, String issuer, String subject, String audience, int ttlSeconds) {
        JwtBuilder builder = Jwts.builder().setId(id).setIssuer(issuer).setSubject(subject).setAudience(audience);
        return JwtUtil.createJWT(keyAlgorithm, jwtSigningKey, builder, TimeUnit.SECONDS, ttlSeconds);
    }

    public static String createJWT(String keyAlgorithm, String jwtSigningKey, JwtBuilder builder, TimeUnit timeUnit, int ttl) {
        byte[] key = Base64.getDecoder().decode(jwtSigningKey);
        return JwtUtil.createJWT(keyAlgorithm, key, builder, timeUnit, ttl);
    }

    public static String createJWT(String keyAlgorithm, byte[] jwtSigningKey, String id, String issuer, String subject, String audience, int ttlSeconds) {
        JwtBuilder builder = Jwts.builder().setId(id).setIssuer(issuer).setSubject(subject).setAudience(audience);
        return JwtUtil.createJWT(keyAlgorithm, jwtSigningKey, builder, TimeUnit.SECONDS, ttlSeconds);
    }

    public static String createJWT(String keyAlgorithm, byte[] jwtSigningKey, JwtBuilder builder, TimeUnit timeUnit, int ttl) {
        SecretKeySpec privateKey = new SecretKeySpec(jwtSigningKey, 0, jwtSigningKey.length, keyAlgorithm);
        return JwtUtil.createJWT(privateKey, builder, timeUnit, ttl);
    }

    public static void setJwtExpireTime(JwtBuilder builder, TimeUnit timeUnit, int ttl) {
        long expireTimeMilsec;
        if (ttl <= 0) {
            return;
        }
        long ttlMilsec = timeUnit.toMillis(ttl);
        if (ttlMilsec > 0L && (expireTimeMilsec = System.currentTimeMillis() + ttlMilsec) > 0L) {
            Date exp = new Date(expireTimeMilsec);
            builder.setExpiration(exp);
        }
    }

    public static String createJWT(Key privateKey, String id, String issuer, String subject, String audience, int ttlSeconds) {
        JwtBuilder builder = Jwts.builder().setId(id).setIssuer(issuer).setSubject(subject).setAudience(audience);
        return JwtUtil.createJWT(privateKey, builder, TimeUnit.SECONDS, ttlSeconds);
    }

    public static String createJWT(Key privateKey, JwtBuilder builder, TimeUnit timeUnit, int ttl) {
        JwtUtil.setJwtExpireTime(builder, timeUnit, ttl);
        builder.setIssuedAt(new Date());
        builder.signWith(privateKey);
        return builder.compact();
    }

    public static Jws<Claims> parseJWT(Key jwtRootSigningKey, String token) {
        JwtParser parser = Jwts.parserBuilder().setSigningKey(jwtRootSigningKey).build();
        return parser.parseClaimsJws(token);
    }

    public static Jws<Claims> parseJWT(byte[] jwtRootSigningKey, String token) {
        JwtParser parser = Jwts.parserBuilder().setSigningKey(jwtRootSigningKey).build();
        return parser.parseClaimsJws(token);
    }

    public static Jws<Claims> parseJWT(JwtParser parser, String token) {
        return parser.parseClaimsJws(token);
    }
}

