/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.security;

import java.io.FileInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.lang3.StringUtils;

public class SSLUtil {
    public static String DEFAULT_PROTOCOL = "TLSv1.3";
    public static final HostnameVerifier IGNORE_HOST_NAME_VERIFIER = (hostname, session) -> true;
    private static final X509Certificate[] TRUSTED_CERTIFICATE = new X509Certificate[0];
    public static final TrustManager[] TRUST_ALL_CERTIFICATES = new TrustManager[]{new X509TrustManager(){

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return TRUSTED_CERTIFICATE;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] certs, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] certs, String authType) {
        }
    }};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyManagerFactory buildKeyManagerFactory(String keyStorePath, char[] keyStorePwd, String keyAlias, char[] keyPwd) throws GeneralSecurityException, IOException {
        KeyManagerFactory kmf;
        block19: {
            if (StringUtils.isBlank((CharSequence)keyStorePath)) {
                return null;
            }
            kmf = null;
            try {
                try (FileInputStream keystoreIn = new FileInputStream(keyStorePath.trim());){
                    KeyStore ks = KeyStore.getInstance("JKS");
                    ks.load(keystoreIn, keyStorePwd);
                    if (StringUtils.isNotBlank((CharSequence)keyAlias)) {
                        Certificate cert = ks.getCertificate(keyAlias.trim());
                        Key key = ks.getKey(keyAlias, keyPwd);
                        if (cert != null && key != null) {
                            ks.load(null);
                            ks.setCertificateEntry(keyAlias, cert);
                            ks.setKeyEntry(keyAlias, key, keyStorePwd, new Certificate[]{cert});
                        } else {
                            throw new GeneralSecurityException("Alias (" + keyAlias + ") not found in " + keyStorePath);
                        }
                    }
                    kmf = KeyManagerFactory.getInstance("SunX509");
                    kmf.init(ks, keyStorePwd);
                }
                if (keyStorePwd == null) break block19;
            }
            catch (Throwable throwable) {
                int i;
                if (keyStorePwd != null) {
                    for (i = 0; i < keyStorePwd.length; ++i) {
                        keyStorePwd[i] = '\u0000';
                    }
                }
                if (keyPwd != null) {
                    for (i = 0; i < keyPwd.length; ++i) {
                        keyPwd[i] = '\u0000';
                    }
                }
                throw throwable;
            }
            for (int i = 0; i < keyStorePwd.length; ++i) {
                keyStorePwd[i] = '\u0000';
            }
        }
        if (keyPwd != null) {
            for (int i = 0; i < keyPwd.length; ++i) {
                keyPwd[i] = '\u0000';
            }
        }
        return kmf;
    }

    public static KeyManager[] buildKeyManagers(String keyStorePath, char[] keyStorePwd, String keyAlias, char[] keyPwd) throws GeneralSecurityException, IOException {
        if (StringUtils.isBlank((CharSequence)keyStorePath)) {
            return null;
        }
        KeyManagerFactory kmf = SSLUtil.buildKeyManagerFactory(keyStorePath, keyStorePwd, keyAlias, keyPwd);
        return kmf == null ? null : kmf.getKeyManagers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TrustManagerFactory buildTrustManagerFactory(String trustStorePath, char[] trustStorePwd) throws GeneralSecurityException, IOException {
        if (StringUtils.isBlank((CharSequence)trustStorePath)) {
            return null;
        }
        TrustManagerFactory tf = null;
        try {
            try (FileInputStream truststoreIn = new FileInputStream(trustStorePath);){
                KeyStore tks = KeyStore.getInstance("JKS");
                tks.load(truststoreIn, trustStorePwd);
                tf = TrustManagerFactory.getInstance("SunX509");
                tf.init(tks);
            }
            if (trustStorePwd == null) return tf;
        }
        catch (Throwable throwable) {
            if (trustStorePwd == null) throw throwable;
            for (int i = 0; i < trustStorePwd.length; ++i) {
                trustStorePwd[i] = '\u0000';
            }
            throw throwable;
        }
        for (int i = 0; i < trustStorePwd.length; ++i) {
            trustStorePwd[i] = '\u0000';
        }
        return tf;
    }

    public static TrustManager[] buildTrustManagers(String trustStorePath, char[] trustStorePwd) throws GeneralSecurityException, IOException {
        TrustManagerFactory tmf = SSLUtil.buildTrustManagerFactory(trustStorePath, trustStorePwd);
        return tmf == null ? null : tmf.getTrustManagers();
    }

    public static SSLContext buildSSLContext(String keyStorePath, char[] keyStorePwd, String keyAlias, char[] keyPwd, String protocol, String trustStorePath, char[] trustStorePwd) throws GeneralSecurityException, IOException {
        KeyManager[] kms = SSLUtil.buildKeyManagers(keyStorePath, keyStorePwd, keyAlias, keyPwd);
        TrustManager[] tms = SSLUtil.buildTrustManagers(trustStorePath, trustStorePwd);
        return SSLUtil.buildSSLContext(kms, tms, protocol);
    }

    public static SSLContext buildSSLContext(KeyManager[] kms, TrustManager[] tms, String protocol) throws GeneralSecurityException, IOException {
        if (kms == null) {
            return null;
        }
        SSLContext ret = SSLContext.getInstance(protocol);
        ret.init(kms, tms, SecureRandom.getInstanceStrong());
        return ret;
    }

    static enum Caller {
        client,
        server;

    }
}

