/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.security.auth;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.summerboot.jexpress.security.auth.AuthConfig;
import org.summerboot.jexpress.security.auth.Caller;
import org.summerboot.jexpress.security.auth.RoleMapping;
import org.summerboot.jexpress.util.BeanUtil;

public class User
implements Serializable,
Caller,
Comparable<User> {
    protected Long tenantId = 0L;
    protected String tenantName;
    protected Long id = 0L;
    protected String uid;
    @JsonIgnore
    protected String password;
    protected Set<String> groups;
    protected int type = 1;
    protected Map prop = null;

    public User(long tenantId, String tenantName, long id, String uid) {
        this.tenantId = tenantId;
        this.tenantName = tenantName;
        this.id = id;
        this.uid = uid;
    }

    public User(long id, String uid) {
        this.id = id;
        this.uid = uid;
    }

    public String toString() {
        try {
            return BeanUtil.toJson(this);
        }
        catch (JsonProcessingException ex) {
            return "User{id=" + this.id + ", uid=" + this.uid + ", type=" + this.type + ", ex=" + ex + "}";
        }
    }

    @Override
    public Long getTenantId() {
        return this.tenantId;
    }

    @Override
    public String getTenantName() {
        return this.tenantName;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public String getUid() {
        return this.uid;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void addGroup(String group) {
        if (group == null) {
            return;
        }
        if (this.groups == null) {
            this.groups = new HashSet<String>();
        }
        this.groups.add(group);
    }

    @Override
    public boolean isInGroup(String group) {
        return this.groups != null && this.groups.contains(group);
    }

    public void setGroups(Set<String> groups) {
        this.groups = groups;
    }

    @Override
    public Set<String> getGroups() {
        return this.groups;
    }

    @Override
    public boolean isInRole(String role) {
        RoleMapping rm = AuthConfig.CFG.getRole(role);
        if (rm == null) {
            return false;
        }
        if (rm.getUsers().contains(this.uid)) {
            return true;
        }
        return rm.getGroups().stream().anyMatch(group -> this.isInGroup((String)group));
    }

    @Override
    public int getType() {
        return this.type;
    }

    public int hashCode() {
        int hash = 5;
        hash = 59 * hash + Objects.hashCode(this.tenantId);
        hash = 59 * hash + Objects.hashCode(this.id);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        User other = (User)obj;
        if (!Objects.equals(this.tenantId, other.tenantId)) {
            return false;
        }
        return Objects.equals(this.id, other.id);
    }

    @Override
    public int compareTo(User arg0) {
        if (arg0 == null) {
            return 1;
        }
        Long id2 = arg0.getId();
        if (this.id == null) {
            if (id2 == null) {
                return 0;
            }
            return -1;
        }
        if (id2 == null) {
            return 1;
        }
        return this.id.compareTo(id2);
    }

    @Override
    public <T> T getProp(String key, Class<T> type) {
        if (this.prop == null) {
            return null;
        }
        return (T)this.prop.get(key);
    }

    @Override
    public void putProp(String key, Object value) {
        if (this.prop == null) {
            this.prop = new HashMap();
        }
        this.prop.put(key, value);
    }

    @Override
    public void remove(String key) {
        if (this.prop != null) {
            this.prop.remove(key);
        }
    }

    @Override
    public Set<String> propKeySet() {
        if (this.prop == null) {
            return null;
        }
        return this.prop.keySet();
    }
}

