/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.util;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.summerboot.jexpress.security.SecurityUtil;

public class FormatterUtil {
    protected static Logger log = null;
    public static final long INT_MASK = 0xFFFFFFFFL;
    public static final int SHORT_MASK = 65535;
    public static final short BYTE_MASK = 255;
    public static final short NIBBLE_MASK = 15;
    public static final String[] EMPTY_STR_ARRAY = new String[0];
    public static final String REGEX_CSV = "\\s*,\\s*";
    public static final String REGEX_URL = "\\s*/\\s*";
    public static final String REGEX_BINDING_MAP = "\\s*:\\s*";
    public static final String REGEX_EMAIL = "^[a-zA-Z0-9_+&*-]+(?:\\.[a-zA-Z0-9_+&*-]+)*@(?:[a-zA-Z0-9-]+\\.)+[a-zA-Z]{2,7}$";
    public static final Pattern REGEX_EMAIL_PATTERN = Pattern.compile("^[a-zA-Z0-9_+&*-]+(?:\\.[a-zA-Z0-9_+&*-]+)*@(?:[a-zA-Z0-9-]+\\.)+[a-zA-Z]{2,7}$");
    public static Pattern INSIDE_PARENTHESES_VALUE = Pattern.compile("\\(([^)]+)\\)");
    private static final Pattern REGEX_DEC_PATTERN = Pattern.compile("DEC\\(([^)]+)\\)");
    private static final Pattern REGEX_ENC_PATTERN = Pattern.compile("ENC\\(([^)]+)\\)");

    public static String[] parseDsv(String csv, String delimiter) {
        return StringUtils.isBlank((CharSequence)csv) ? EMPTY_STR_ARRAY : csv.trim().split("\\s*" + delimiter + "\\s*");
    }

    public static String[] parseCsv(String csv) {
        return StringUtils.isBlank((CharSequence)csv) ? EMPTY_STR_ARRAY : csv.trim().split(REGEX_CSV);
    }

    public static String[] parseURL(String url) {
        return StringUtils.isBlank((CharSequence)url) ? EMPTY_STR_ARRAY : url.trim().split(REGEX_URL);
    }

    public static String[] parseURL(String url, boolean trim) {
        return StringUtils.isBlank((CharSequence)url) ? EMPTY_STR_ARRAY : (trim ? url.trim().split(REGEX_URL) : url.split(REGEX_URL));
    }

    public static <T> String toCSV(Collection<T> a) {
        return a.stream().map(String::valueOf).collect(Collectors.joining(","));
    }

    public static String[] getEnumNames(Class<? extends Enum<?>> e) {
        return (String[])Arrays.stream(e.getEnumConstants()).map(Enum::name).toArray(String[]::new);
    }

    public static String getInsideParenthesesValue(String value) {
        String ret = value;
        int end = value.lastIndexOf(")");
        if (end >= 0) {
            ret = value.substring(value.indexOf("(") + 1, end);
        }
        return ret;
    }

    public static String updateProtectedLine(String line, boolean encrypt) throws GeneralSecurityException {
        Matcher matcher = encrypt ? REGEX_DEC_PATTERN.matcher(line) : REGEX_ENC_PATTERN.matcher(line);
        ArrayList<String> matches = new ArrayList<String>();
        while (matcher.find()) {
            matches.add(matcher.group(1));
        }
        if (matches.isEmpty()) {
            return null;
        }
        for (String match : matches) {
            String converted;
            if (encrypt) {
                converted = SecurityUtil.encrypt(match, true);
                line = line.replace("DEC(" + match + ")", "ENC(" + converted + ")");
                continue;
            }
            converted = SecurityUtil.decrypt(match, true);
            line = line.replace("ENC(" + match + ")", "DEC(" + converted + ")");
        }
        return line;
    }

    public static String b2n(String s) {
        return StringUtils.isBlank((CharSequence)s) ? null : s.trim();
    }

    public static Map<String, Integer> parseBindingAddresss(String bindAddresses) {
        String[] addrs;
        HashMap<String, Integer> ret = new HashMap<String, Integer>();
        for (String addr : addrs = FormatterUtil.parseCsv(bindAddresses)) {
            String[] ap = addr.trim().split(REGEX_BINDING_MAP);
            ret.put(ap[0], Integer.parseInt(ap[1]));
        }
        return ret;
    }

    public static Map<String, String> parseMap(String mapCVS) {
        String[] mapKeyValues;
        HashMap<String, String> ret = new HashMap<String, String>();
        for (String mapKeyValue : mapKeyValues = FormatterUtil.parseCsv(mapCVS)) {
            String[] ap = mapKeyValue.trim().split(REGEX_BINDING_MAP);
            ret.put(ap[0], ap[1]);
        }
        return ret;
    }

    public static String convertTo(String value, String targetCharsetName) throws UnsupportedEncodingException {
        return new String(value.getBytes(targetCharsetName), targetCharsetName);
    }

    public static String base64MimeEncode(byte[] contentBytes) {
        return Base64.getMimeEncoder().encodeToString(contentBytes);
    }

    public static byte[] base64MimeDecode(String encodedMime) {
        return Base64.getMimeDecoder().decode(encodedMime);
    }

    public static String base64Encode(byte[] contentBytes) {
        return Base64.getEncoder().encodeToString(contentBytes);
    }

    public static byte[] base64Decode(String encodedMime) {
        return Base64.getDecoder().decode(encodedMime);
    }

    public static byte[] toByteArray(BufferedImage bi, String format) throws IOException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            byte[] bytes;
            ImageIO.write((RenderedImage)bi, format, baos);
            byte[] byArray = bytes = baos.toByteArray();
            return byArray;
        }
    }

    public static String toString(ByteBuffer buffer) {
        return FormatterUtil.toString(buffer, true, true, 8, "    ");
    }

    public static String toString(ByteBuffer buffer, boolean showStatus, boolean showHeaderfooter, int showNumberOfBytesPerLine, String delimiter) {
        StringBuilder sb = new StringBuilder();
        if (showStatus) {
            sb.append("ByteBuffer status:").append(" Order=").append(buffer.order()).append(" Position=").append(buffer.position()).append(" Limit=").append(buffer.limit()).append(" Capacity=").append(buffer.capacity()).append(" Remaining=").append(buffer.remaining());
        }
        if (showHeaderfooter) {
            sb.append("\n************** ByteBuffer Contents starts **************\n");
        }
        boolean eol = false;
        if (showNumberOfBytesPerLine > 0) {
            byte[] array = buffer.array();
            for (int i = 0; i < buffer.limit(); ++i) {
                eol = (i + 1) % showNumberOfBytesPerLine == 0;
                sb.append(String.format("0x%02X", array[i])).append(eol ? "\n" : delimiter);
            }
        }
        if (showHeaderfooter) {
            if (!eol) {
                sb.append("\n");
            }
            sb.append("************** ByteBuffer Contents ends **************\n");
        }
        return sb.toString();
    }

    public static byte[] parseHex(String hexString) {
        String evenLengthHexString = hexString.replaceAll("0x", "").replaceAll("[^a-zA-Z0-9]", "");
        int len = evenLengthHexString.length();
        if (len % 2 != 0) {
            throw new IllegalArgumentException("Converted Hex string length=" + len + " and is not an even-length: \n\t arg: " + hexString + "\n\t hex: " + evenLengthHexString);
        }
        String hex = evenLengthHexString.replaceAll("[^a-fA-F0-9]", "");
        if (!evenLengthHexString.equals(hex)) {
            throw new IllegalArgumentException("Invalid Hex string \n\t arg: " + hexString + "\n\t hex: " + evenLengthHexString);
        }
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(evenLengthHexString.charAt(i), 16) << 4) + Character.digit(evenLengthHexString.charAt(i + 1), 16));
        }
        return data;
    }

    public static <T> Set<T> findDuplicates(List<T> listContainingDuplicates) {
        HashSet<T> setToReturn = new HashSet<T>();
        HashSet<T> set1 = new HashSet<T>();
        for (T yourInt : listContainingDuplicates) {
            if (set1.add(yourInt)) continue;
            setToReturn.add(yourInt);
        }
        return setToReturn;
    }

    public static String protectContentNumber(String plain, String keyword, String delimiter, String replaceWith) {
        if (StringUtils.isBlank((CharSequence)plain)) {
            return plain;
        }
        String regex = "(?i)" + keyword + "\\s*" + delimiter + "\\s*\"*[0-9]*";
        String replacement = keyword + delimiter + replaceWith;
        return plain.replaceAll(regex, replacement);
    }

    public static String protectContent(String plain, String keyword, String delimiter, String wrapper, String replaceWith) {
        if (StringUtils.isBlank((CharSequence)plain)) {
            return plain;
        }
        if (wrapper == null) {
            wrapper = "";
        }
        String regex = "(?i)" + keyword + "\\s*" + delimiter + "\\s*" + wrapper + "(\\w*\\s*\\w*(-\\w*)*\\.*!*:*=*\\+*/*@*#*\\$*\\^*&*\\**\\(*\\)*)*" + wrapper;
        String replacement = keyword + delimiter + replaceWith + wrapper;
        if (log == null) {
            log = LogManager.getLogger(FormatterUtil.class);
        }
        log.trace(() -> "replace " + plain + "\n\t regex=" + regex + "\n\t with=" + replacement);
        return plain.replaceAll(regex, replacement);
    }
}

