/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.util;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.util.Calendar;
import java.util.Random;
import org.apache.commons.lang3.StringUtils;

public class TimeUtil {
    public static DateTimeFormatter ISO_ZONED_DATE_TIME3 = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd'T'HH:mm:ss.SSS").parseLenient().appendOffset("+HH:MM", "Z").toFormatter();
    public static DateTimeFormatter UTC_DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    public static ZoneId ZONE_ID_ONTARIO = ZoneId.of("America/Toronto");
    protected static Random RANDOM = new Random();

    public static long getSecondsSinceMidnight(Calendar c) {
        return 3600 * c.get(11) + 60 * c.get(12) + c.get(13);
    }

    public static long getSecondsTillMidnight(Calendar c) {
        return 86400L - TimeUtil.getSecondsSinceMidnight(c);
    }

    public static int[] seconds2DHMS(long totalSeconds) {
        int[] ymdhms = new int[]{0, 0, 0, 0};
        long day = totalSeconds / 86400L;
        long hour = totalSeconds / 3600L % 24L;
        long minute = totalSeconds % 3600L / 60L;
        long second = totalSeconds % 60L;
        ymdhms[3] = (int)day;
        ymdhms[2] = (int)hour;
        ymdhms[1] = (int)minute;
        ymdhms[0] = (int)second;
        return ymdhms;
    }

    public static String seconds2DHMSString(long totalSeconds) {
        int[] ymdhms = TimeUtil.seconds2DHMS(totalSeconds);
        int day = ymdhms[3];
        int hour = ymdhms[2];
        int min = ymdhms[1];
        int sec = ymdhms[0];
        return day + " day" + (day > 1 ? "s " : " ") + hour + " hour" + (hour > 1 ? "s " : " ") + min + " min" + (min > 1 ? "s " : " ") + sec + " sec" + (sec > 1 ? "s " : " ");
    }

    public static String utcDateTimeToLocalDateTime(String utcTime, ZoneId zoneId) {
        if (StringUtils.isBlank((CharSequence)utcTime)) {
            return null;
        }
        return ZonedDateTime.parse(utcTime, UTC_DATE_TIME_FORMATTER).withZoneSameInstant(zoneId).format(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
    }

    public static LocalDateTime toLocalDateTime(long utcTs) {
        return TimeUtil.toLocalDateTime(utcTs, ZoneId.systemDefault());
    }

    public static LocalDateTime toLocalDateTime(long utcTs, ZoneId zoneId) {
        if (zoneId == null) {
            zoneId = ZoneId.systemDefault();
        }
        return Instant.ofEpochMilli(utcTs).atZone(zoneId).toLocalDateTime();
    }

    public static OffsetDateTime toOffsetDateTime(long utcTs, ZoneId zoneId) {
        if (zoneId == null) {
            zoneId = ZoneId.systemDefault();
        }
        return Instant.ofEpochMilli(utcTs).atZone(zoneId).toOffsetDateTime();
    }

    public static int random(int low, int high) {
        int result = RANDOM.nextInt(high - low) + low;
        return result;
    }

    public static double truncatedExponentialBackoffSlots(int retry, int truncatedMaxRetry) {
        if (retry < 1) {
            return 0.0;
        }
        int n = Math.min(retry, truncatedMaxRetry);
        int max = (1 << n) - 1;
        double min = max / 2;
        return Math.random() * ((double)max - min) + min;
    }
}

