/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.boot;

import com.google.inject.Inject;
import com.google.inject.Module;
import java.net.BindException;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Set;
import org.summerboot.jexpress.boot.BootConstant;
import org.summerboot.jexpress.boot.SummerBigBang;
import org.summerboot.jexpress.boot.SummerRunner;
import org.summerboot.jexpress.boot.SummerSingularity;
import org.summerboot.jexpress.boot.config.ConfigChangeListener;
import org.summerboot.jexpress.boot.config.ConfigUtil;
import org.summerboot.jexpress.boot.config.JExpressConfig;
import org.summerboot.jexpress.boot.instrumentation.HealthInspector;
import org.summerboot.jexpress.boot.instrumentation.HealthMonitor;
import org.summerboot.jexpress.boot.instrumentation.jmx.InstrumentationMgr;
import org.summerboot.jexpress.i18n.I18n;
import org.summerboot.jexpress.integration.smtp.PostOffice;
import org.summerboot.jexpress.integration.smtp.SMTPClientConfig;
import org.summerboot.jexpress.nio.server.NioServer;
import org.summerboot.jexpress.nio.server.domain.Err;
import org.summerboot.jexpress.util.BeanUtil;
import org.summerboot.jexpress.util.FormatterUtil;

public abstract class SummerApplication
extends SummerBigBang {
    @Inject
    protected ConfigChangeListener configChangeListener;
    @Inject
    protected InstrumentationMgr instrumentationMgr;
    @Inject
    protected HealthInspector healthInspector;
    @Inject
    protected PostOffice postOffice;

    public static void run() {
        Module userOverrideModule = null;
        SummerApplication.run(userOverrideModule);
    }

    public static void run(Class callerClass, String[] args) {
        Module userOverrideModule = null;
        SummerApplication.run(callerClass, userOverrideModule, args);
    }

    public static void run(Module userOverrideModule) {
        StackTraceElement[] stackTrace;
        String[] mainCommand = System.getProperty("sun.java.command").split(" ");
        String[] args = new String[mainCommand.length - 1];
        String mainClassName = mainCommand[0];
        for (int i = 1; i < mainCommand.length; ++i) {
            args[i - 1] = mainCommand[i];
        }
        Class<?> callerClass = null;
        for (StackTraceElement stackTraceElement : stackTrace = new RuntimeException().getStackTrace()) {
            if (!"main".equals(stackTraceElement.getMethodName())) continue;
            try {
                callerClass = Class.forName(stackTraceElement.getClassName());
                break;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (callerClass == null) {
            try {
                callerClass = Class.forName(mainClassName);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (callerClass == null) {
            throw new RuntimeException("Failed to find the caller class");
        }
        SummerApplication.run(callerClass, userOverrideModule, args);
    }

    public static void run(String[] args) {
        Module userOverrideModule = null;
        SummerApplication.run(userOverrideModule, args);
    }

    public static void run(Module userOverrideModule, String[] args) {
        StackTraceElement[] stackTrace;
        Class<?> callerClass = null;
        for (StackTraceElement stackTraceElement : stackTrace = new RuntimeException().getStackTrace()) {
            if (!"main".equals(stackTraceElement.getMethodName())) continue;
            try {
                callerClass = Class.forName(stackTraceElement.getClassName());
                break;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (callerClass == null) {
            throw new RuntimeException("Failed to find the caller class");
        }
        SummerApplication.run(callerClass, userOverrideModule, args);
    }

    public static void run(Class callerClass, Module userOverrideModule, String[] args) {
        SummerApplication app = new SummerApplication(callerClass, userOverrideModule, args){};
        ((SummerApplication)((SummerBigBang)app.aParallelUniverse()).bigBang(args)).start();
    }

    public static SummerApplication unittest(Class callerClass, Module userOverrideModule, String argsStr) {
        String[] args = argsStr.split(" ");
        return SummerApplication.unittest(callerClass, userOverrideModule, args);
    }

    public static SummerApplication unittest(Class callerClass, Module userOverrideModule, String ... args) {
        SummerApplication app = new SummerApplication(callerClass, userOverrideModule, args){};
        return ((SummerBigBang)app.aParallelUniverse()).bigBang(args);
    }

    private SummerApplication(Class callerClass, Module userOverrideModule, String ... args) {
        super(callerClass, userOverrideModule, args);
    }

    public <T extends SummerApplication> T addPredefinedUseImplTags(Class<? extends Enum<?>> enumClass) {
        return this.addPredefinedUseImplTags(FormatterUtil.getEnumNames(enumClass));
    }

    public <T extends SummerApplication> T addPredefinedUseImplTags(String ... mockItemNames) {
        if (mockItemNames == null || mockItemNames.length < 1) {
            return (T)this;
        }
        this.availableImplTagOptions.addAll(Set.of(mockItemNames));
        this.memo.append("\n\t- availableImplTagOptions=").append(this.availableImplTagOptions);
        return (T)this;
    }

    public <T extends SummerApplication> T bindBootConfig(String configFileName, JExpressConfig config, String checkImplTagUsed, boolean loadWhenImplTagUsed) {
        this.memo.append("\n\t- bindBootConfig: configFileName=").append(configFileName).append(", config=").append(config.getClass().getName()).append(", implTag=").append(checkImplTagUsed).append(", loadWhenImplTagUsed=").append(loadWhenImplTagUsed);
        String key = config.getClass().getSimpleName();
        SummerSingularity.ConfigMetadata metadata = new SummerSingularity.ConfigMetadata(configFileName, config.getClass(), config, checkImplTagUsed, loadWhenImplTagUsed);
        this.scanedJExpressConfigs.put(key, metadata);
        return (T)this;
    }

    @Override
    protected Class getAddtionalI18n() {
        return null;
    }

    public void start() {
        this.memo.append("\n\t- sys.prop.").append("version").append("=").append(System.getProperty("version"));
        this.memo.append("\n\t- sys.prop.").append("appPackage").append("=").append(System.getProperty("appPackage"));
        this.memo.append("\n\t- sys.prop.").append("appappName").append("=").append(System.getProperty("appappName"));
        this.memo.append("\n\t- sys.prop.").append("logDir").append("=").append(System.getProperty("logDir"));
        this.memo.append("\n\t- start: PostOffice=").append(this.postOffice.getClass().getName());
        this.memo.append("\n\t- start: HealthInspector=").append(this.healthInspector.getClass().getName());
        this.memo.append("\n\t- start: InstrumentationMgr=").append(this.instrumentationMgr.getClass().getName());
        log.trace(() -> this.memo.toString());
        SMTPClientConfig smtpCfg = SMTPClientConfig.cfg;
        if (this.postOffice != null) {
            this.postOffice.setAppVersion(this.appVersionLong);
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                if (this.postOffice != null) {
                    this.postOffice.sendAlertSync(smtpCfg.getEmailToAppSupport(), "Shutdown at " + OffsetDateTime.now() + " - " + this.appVersionLong, "EOM", null, false);
                }
            }, "ShutdownHook.BootApp"));
        }
        try {
            if (this.instrumentationMgr != null) {
                this.instrumentationMgr.start("SummerBoot.jExpress 2.2.0");
            }
            StringBuilder sb = new StringBuilder();
            sb.append(System.lineSeparator()).append("\tSelf Inspection Result: ");
            if (this.healthInspector != null) {
                List<Err> errors = this.healthInspector.ping(log);
                if (errors == null || errors.isEmpty()) {
                    sb.append("passed");
                    log.info((CharSequence)sb);
                } else {
                    Object inspectionReport;
                    try {
                        inspectionReport = BeanUtil.toJson(errors, true, true);
                    }
                    catch (Throwable ex) {
                        inspectionReport = "total " + errors.size();
                    }
                    sb.append((String)inspectionReport);
                    HealthMonitor.setHealthStatus(false, sb.toString(), this.healthInspector);
                }
            } else {
                sb.append("skipped");
                log.warn((CharSequence)sb);
            }
            for (SummerRunner summerRunner : this.summerRunners) {
                summerRunner.run(this.cli, this.userSpecifiedConfigDir, this.guiceInjector, this.healthInspector, this.postOffice);
            }
            if (this.configChangeListener != null) {
                ConfigUtil.setConfigChangeListener(this.configChangeListener);
            }
            log.trace("hasControllers=" + this.hasControllers);
            if (this.hasControllers) {
                NioServer.bind();
            }
            log.info(() -> I18n.info.launched.format(this.userSpecifiedResourceBundle, this.appVersionLong + " pid#" + BootConstant.PID));
            String fullConfigInfo = sb.toString();
            if (this.postOffice != null) {
                this.postOffice.sendAlertAsync(smtpCfg.getEmailToAppSupport(), "Started at " + OffsetDateTime.now(), fullConfigInfo, null, false);
            }
        }
        catch (BindException ex) {
            log.fatal("\nIn order to check which application is listening on a port, you can use the following command from the command line:\n\nFor Microsoft Windows:\n    netstat -ano | find \"80\" | find \"LISTEN\"\n    tasklist /fi \"PID eq <pid>\"\n     \nFor Linux:\n    netstat -anpe | grep \"80\" | grep \"LISTEN\" \n", (Throwable)ex);
            System.exit(1);
        }
        catch (Throwable ex) {
            log.fatal(I18n.info.unlaunched.format(this.userSpecifiedResourceBundle, new String[0]), ex);
            System.exit(1);
        }
    }
}

