/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.integration.db;

import com.fasterxml.jackson.annotation.JsonIgnore;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.hibernate.SessionFactory;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.service.ServiceRegistry;
import org.summerboot.jexpress.boot.config.BootConfig;
import org.summerboot.jexpress.boot.config.ConfigUtil;
import org.summerboot.jexpress.util.FormatterUtil;
import org.summerboot.jexpress.util.ReflectionUtil;

public abstract class JPAHibernateConfig
extends BootConfig {
    @JsonIgnore
    private volatile SessionFactory sessionFactory;
    private final Properties props = new Properties();
    private final Map<String, Object> settings = new HashMap<String, Object>();
    private final List<Class<?>> entityClasses = new ArrayList();

    protected JPAHibernateConfig() {
    }

    private JPAHibernateConfig(Object temp) {
    }

    @Override
    public void load(File cfgFile, boolean isReal) throws IOException {
        this.load(cfgFile, new String[0]);
    }

    public void load(File cfgFile, String ... packages) throws IOException {
        if (this.logger == null) {
            this.logger = LogManager.getLogger(this.getClass());
        }
        this.cfgFile = cfgFile.getAbsoluteFile();
        try (FileInputStream is = new FileInputStream(cfgFile);){
            this.props.load(is);
        }
        this.settings.clear();
        ConfigUtil helper = new ConfigUtil(this.cfgFile.getAbsolutePath());
        Set<Object> keys = this.props.keySet();
        keys.forEach(key -> {
            String name = key.toString();
            this.settings.put(name, this.props.getProperty(name));
        });
        this.settings.put("hibernate.connection.password", helper.getAsPassword(this.props, "hibernate.connection.password"));
        String error2 = helper.getError();
        if (error2 != null) {
            throw new IllegalArgumentException(error2);
        }
        String callerRootPackageName = System.getProperty("appPackage");
        String csvPackageNames = this.props.getProperty("hibernate.loaded_classes", "");
        this.scanAnnotation_Entity(callerRootPackageName + "," + csvPackageNames, packages);
        SessionFactory old = this.sessionFactory;
        StandardServiceRegistryBuilder registryBuilder = new StandardServiceRegistryBuilder();
        registryBuilder.applySettings(this.settings);
        StandardServiceRegistry registry = registryBuilder.build();
        MetadataSources sources = new MetadataSources((ServiceRegistry)registry);
        this.entityClasses.forEach(arg_0 -> ((MetadataSources)sources).addAnnotatedClass(arg_0));
        Metadata metadata = sources.getMetadataBuilder().build();
        this.sessionFactory = metadata.getSessionFactoryBuilder().build();
        if (old != null) {
            this.logger.warn("close current db connection due to config changed");
            try {
                old.close();
            }
            catch (Throwable ex) {
                this.logger.warn("failed to close current db connection", ex);
            }
        }
        if (this.settings.get("hibernate.connection.password") != null) {
            this.settings.put("hibernate.connection.password", "****");
        }
    }

    private void scanAnnotation_Entity(String csvPackageNames, String ... packages) {
        this.logger.debug("_rootPackageNames={}", (Object)csvPackageNames);
        String[] rootPackageNames = FormatterUtil.parseCsv(csvPackageNames);
        List<Object> rootPackageNameList = new ArrayList<String>();
        rootPackageNameList.addAll(Arrays.asList(rootPackageNames));
        rootPackageNameList.addAll(Arrays.asList(packages));
        rootPackageNameList = rootPackageNameList.stream().distinct().collect(Collectors.toList());
        rootPackageNameList.removeAll(Collections.singleton(""));
        rootPackageNameList.removeAll(Collections.singleton(null));
        this.logger.debug("rootPackageNameList:{}", rootPackageNameList);
        for (String string : rootPackageNameList) {
            Set<Class<?>> tempEntityClasses = ReflectionUtil.getAllImplementationsByAnnotation(Entity.class, string);
            this.entityClasses.addAll(tempEntityClasses);
        }
    }

    @Override
    public void shutdown() {
        System.out.println(Thread.currentThread().getName() + ": shutdown DB.SessionFactory");
        if (this.sessionFactory != null) {
            try {
                this.sessionFactory.close();
            }
            catch (Throwable ex) {
                ex.printStackTrace(System.err);
            }
        }
    }

    public Map<String, Object> getSettings() {
        return this.settings;
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public EntityManager em() {
        return this.sessionFactory.createEntityManager();
    }

    public String getProperty(String key) {
        return this.props.getProperty(key);
    }

    public List<Class<?>> getEntityClasses() {
        return this.entityClasses;
    }
}

