/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.nio.server;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.multipart.Attribute;
import io.netty.handler.codec.http.multipart.DefaultHttpDataFactory;
import io.netty.handler.codec.http.multipart.DiskAttribute;
import io.netty.handler.codec.http.multipart.DiskFileUpload;
import io.netty.handler.codec.http.multipart.FileUpload;
import io.netty.handler.codec.http.multipart.HttpData;
import io.netty.handler.codec.http.multipart.HttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpPostRequestDecoder;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import io.netty.util.ReferenceCountUtil;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.summerboot.jexpress.nio.server.NioConfig;
import org.summerboot.jexpress.nio.server.NioCounter;
import org.summerboot.jexpress.nio.server.NioHttpUtil;
import org.summerboot.jexpress.nio.server.domain.ServiceContext;
import org.summerboot.jexpress.nio.server.domain.ServiceError;
import org.summerboot.jexpress.nio.server.multipart.MultipartUtil;
import org.summerboot.jexpress.security.auth.Caller;

public abstract class BootHttpFileUploadHandler
extends SimpleChannelInboundHandler<HttpObject> {
    protected static Logger log = LogManager.getLogger((String)BootHttpFileUploadHandler.class.getName());
    private static final boolean AUTO_RELEASE = false;
    private static final boolean USER_DISK = true;
    private static final HttpDataFactory HDF = new DefaultHttpDataFactory(true);
    protected static final NioConfig uploadCfg = NioConfig.cfg;
    private HttpRequest request;
    private boolean isMultipart;
    private HttpPostRequestDecoder httpDecoder;
    private long hitIndex;
    private HttpData partialContent;
    private long fileSizeQuota;
    private Caller caller;
    private Map<String, String> params;

    public BootHttpFileUploadHandler() {
        super(false);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable ex) {
        if (ex instanceof DecoderException) {
            log.warn(ctx.channel().remoteAddress() + " - caller(" + this.caller + "): " + ex);
        } else {
            log.warn(ctx.channel().remoteAddress() + " - caller(" + this.caller + "): " + ex, ex);
        }
        if (ex instanceof OutOfMemoryError) {
            ctx.close();
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        if (this.httpDecoder != null) {
            this.httpDecoder.cleanFiles();
        }
        ctx.fireChannelInactive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void channelRead0(ChannelHandlerContext ctx, HttpObject httpObject) throws Exception {
        if (httpObject instanceof HttpRequest) {
            this.request = (HttpRequest)httpObject;
            this.isMultipart = MultipartUtil.isMultipart(this.request);
            if (this.isMultipart) {
                NioCounter.COUNTER_HIT.incrementAndGet();
                this.hitIndex = NioCounter.COUNTER_BIZ_HIT.incrementAndGet();
                this.fileSizeQuota = this.precheck(ctx, this.request);
                if (this.fileSizeQuota < 1L) {
                    ReferenceCountUtil.release((Object)httpObject);
                    TimeUnit.MILLISECONDS.sleep(1000L);
                    ctx.channel().close();
                    return;
                }
                this.httpDecoder = new HttpPostRequestDecoder(HDF, this.request);
                this.httpDecoder.setDiscardThreshold(0);
            }
        }
        if (!this.isMultipart) {
            ctx.fireChannelRead((Object)httpObject);
            return;
        }
        if (!(httpObject instanceof HttpContent)) return;
        if (this.httpDecoder != null) {
            try {
                HttpContent chunk = (HttpContent)httpObject;
                this.httpDecoder.offer(chunk);
                boolean isOverSized = this.onPartialChunk(ctx, this.fileSizeQuota);
                if (isOverSized) {
                    this.reset();
                    ServiceError e = new ServiceError(7, null, String.valueOf(this.fileSizeQuota), null);
                    NioHttpUtil.sendText(ctx, true, null, HttpResponseStatus.REQUEST_ENTITY_TOO_LARGE, e.toJson(), null, null, true);
                    return;
                }
                if (!(chunk instanceof LastHttpContent)) return;
                this.onLastChunk(ctx);
                return;
            }
            finally {
                ReferenceCountUtil.release((Object)httpObject);
            }
        } else {
            ctx.fireChannelRead((Object)httpObject);
        }
    }

    private void reset() {
        if (this.httpDecoder != null) {
            this.httpDecoder.cleanFiles();
            this.httpDecoder.destroy();
        }
        this.httpDecoder = null;
        this.partialContent = null;
    }

    private boolean onPartialChunk(ChannelHandlerContext ctx, long maxAllowedSize) throws IOException {
        long totalReceivedBytes = 0L;
        try {
            InterfaceHttpData data;
            while (this.httpDecoder.hasNext()) {
                data = this.httpDecoder.next();
                if (data == null) continue;
                if (this.partialContent == data) {
                    log.info(" 100% (FinalSize: " + this.partialContent.length() + ")");
                    this.partialContent = null;
                }
                switch (data.getHttpDataType()) {
                    case Attribute: {
                        Attribute attribute = (Attribute)data;
                        try {
                            String value = attribute.getValue();
                            if (this.params == null) {
                                this.params = new HashMap<String, String>();
                            }
                            this.params.put(attribute.getName(), value);
                        }
                        catch (IOException e1) {
                            log.error("read attribute failed", (Throwable)e1);
                        }
                        break;
                    }
                    case FileUpload: {
                        FileUpload fileUpload = (FileUpload)data;
                        if (!fileUpload.isCompleted()) break;
                        log.debug("file completed " + fileUpload.length());
                        this.onFileUploaded(ctx, fileUpload.getFilename(), fileUpload.getFile(), this.params, this.caller);
                    }
                }
            }
            data = this.httpDecoder.currentPartialHttpData();
            if (data != null && InterfaceHttpData.HttpDataType.FileUpload.equals((Object)data.getHttpDataType()) && this.partialContent == null) {
                this.partialContent = (HttpData)data;
            }
            totalReceivedBytes = this.partialContent == null ? 0L : this.partialContent.length();
        }
        catch (HttpPostRequestDecoder.EndOfDataDecoderException e1) {
            log.debug("\r\n\r\nEND OF CONTENT CHUNK BY CHUNK\r\n\r\n");
        }
        return totalReceivedBytes > maxAllowedSize;
    }

    private void onLastChunk(ChannelHandlerContext ctx) throws IOException {
        this.reset();
    }

    private long precheck(ChannelHandlerContext ctx, HttpRequest req) {
        long contentLength;
        if (!this.isValidRequestPath(req.uri()) || !HttpMethod.POST.equals((Object)req.method())) {
            ServiceError e = new ServiceError(6, null, "invalid request:" + req.method() + " " + req.uri(), null);
            NioHttpUtil.sendText(ctx, true, null, HttpResponseStatus.BAD_REQUEST, e.toJson(), null, null, true);
            return 0L;
        }
        HttpHeaders httpHeaders = req.headers();
        ServiceContext context = ServiceContext.build(this.hitIndex);
        this.caller = this.authenticate(httpHeaders, context);
        if (this.caller == null) {
            ServiceError e = new ServiceError(47, null, "Unauthorized Caller", null);
            NioHttpUtil.sendText(ctx, true, null, HttpResponseStatus.FORBIDDEN, e.toJson(), null, null, true);
            return 0L;
        }
        String cl = httpHeaders.get((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
        try {
            contentLength = Long.parseLong(cl);
        }
        catch (RuntimeException ex) {
            ServiceError e = new ServiceError(6, null, "Invalid header: " + HttpHeaderNames.CONTENT_LENGTH + "=" + cl, (Throwable)ex);
            NioHttpUtil.sendText(ctx, true, null, HttpResponseStatus.BAD_REQUEST, e.toJson(), null, null, true);
            return 0L;
        }
        long maxAllowedSize = this.getCallerFileUploadSizeLimit_Bytes(this.caller);
        if (contentLength > maxAllowedSize) {
            ServiceError e = new ServiceError(7, null, String.valueOf(maxAllowedSize), null);
            NioHttpUtil.sendText(ctx, true, null, HttpResponseStatus.REQUEST_ENTITY_TOO_LARGE, e.toJson(), null, null, true);
            return 0L;
        }
        return maxAllowedSize;
    }

    protected abstract boolean isValidRequestPath(String var1);

    protected abstract Caller authenticate(HttpHeaders var1, ServiceContext var2);

    protected abstract long getCallerFileUploadSizeLimit_Bytes(Caller var1);

    protected abstract void onFileUploaded(ChannelHandlerContext var1, String var2, File var3, Map<String, String> var4, Caller var5);

    static {
        DiskFileUpload.deleteOnExitTemporaryFile = true;
        DiskFileUpload.baseDirectory = uploadCfg.getTempUoloadDir();
        DiskAttribute.deleteOnExitTemporaryFile = true;
        DiskAttribute.baseDirectory = uploadCfg.getTempUoloadDir();
    }
}

