/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.nio.server;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.name.Names;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInboundHandler;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.ssl.SslProvider;
import java.io.File;
import java.lang.annotation.Annotation;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import org.apache.commons.lang3.StringUtils;
import org.summerboot.jexpress.boot.config.BootConfig;
import org.summerboot.jexpress.boot.config.ConfigUtil;
import org.summerboot.jexpress.boot.config.annotation.Config;
import org.summerboot.jexpress.boot.config.annotation.ConfigHeader;
import org.summerboot.jexpress.boot.config.annotation.ImportResource;
import org.summerboot.jexpress.nio.server.AbortPolicyWithReport;
import org.summerboot.jexpress.nio.server.BootHttpFileUploadRejector;
import org.summerboot.jexpress.nio.server.BootHttpPingHandler;
import org.summerboot.jexpress.nio.server.IoMultiplexer;
import org.summerboot.jexpress.nio.server.NioServer;
import org.summerboot.jexpress.util.BeanUtil;

@ImportResource(value="cfg_nio.properties")
public class NioConfig
extends BootConfig {
    public static final NioConfig cfg = new NioConfig();
    @ConfigHeader(title="1. NIO Network Listeners", format="ip1:port1, ip2:port2, ..., ipN:portN", example="192.168.1.10:8443, 127.0.0.1:8444, 0.0.0.0:8445")
    @Config(key="nio.server.bindings", defaultValue="0.0.0.0:8211")
    private volatile Map<String, Integer> bindingAddresses = Map.of("0.0.0.0", 8211);
    @ConfigHeader(title="2. NIO Security")
    @JsonIgnore
    @Config(key="nio.server.ssl.KeyStore", StorePwdKey="nio.server.ssl.KeyStorePwd", AliasKey="nio.server.ssl.KeyAlias", AliasPwdKey="nio.server.ssl.KeyPwd", required=false, desc="Use SSL/TLS when key store is provided, use plain Socket if key stroe is not available")
    private volatile KeyManagerFactory kmf = null;
    @JsonIgnore
    @Config(key="nio.server.ssl.TrustStore", StorePwdKey="nio.server.ssl.TrustStorePwd", required=false, desc="trust all clients when truststore is not provided")
    private volatile TrustManagerFactory tmf = null;
    @Config(key="nio.server.ssl.VerifyCertificateHost")
    private volatile boolean verifyCertificateHost = false;
    @Config(key="nio.server.ssl.Provider")
    private volatile SslProvider sslProvider = SslProvider.OPENSSL;
    @Config(key="nio.server.ssl.Protocols", defaultValue="TLSv1.2, TLSv1.3")
    private String[] sslProtocols = new String[]{"TLSv1.2", "TLSv1.3"};
    @Config(key="nio.server.ssl.CipherSuites", desc="use system default ciphersuites when not specified")
    private String[] sslCipherSuites = null;
    @ConfigHeader(title="3.1 Socket controller")
    @Config(key="nio.server.socket.SO_REUSEADDR")
    private volatile boolean soReuseAddr = true;
    @Config(key="nio.server.socket.SO_KEEPALIVE")
    private volatile boolean soKeepAlive = true;
    @Config(key="nio.server.socket.TCP_NODELAY")
    private volatile boolean soTcpNodelay = true;
    @Config(key="nio.server.socket.SO_LINGER")
    private volatile int soLinger = -1;
    @ConfigHeader(title="3.2 Socket Performance")
    @Config(key="nio.server.ssl.HandshakeTimeout.second")
    private volatile int sslHandshakeTimeout = 30;
    @Config(key="nio.server.socket.CONNECT_TIMEOUT.second")
    private volatile int soConnectionTimeout = 30;
    @Config(key="nio.server.socket.SO_BACKLOG")
    private volatile int soBacklog = 1024;
    @Config(key="nio.server.socket.SO_RCVBUF", desc=" - cat /proc/sys/net/ipv4/tcp_rmem (max 1024k)")
    private volatile int soRcvBuf = 0x100000;
    @Config(key="nio.server.socket.SO_SNDBUF", desc=" - cat /proc/sys/net/ipv4/tcp_smem (max 1024k)")
    private volatile int soSndBuf = 0x100000;
    @Config(key="nio.server.HttpObjectAggregator.maxContentLength", desc="default - 64kb")
    private volatile int httpObjectAggregatorMaxContentLength = 65536;
    @ConfigHeader(title="4.1 Netty controller")
    @Config(key="nio.server.multiplexer")
    private volatile IoMultiplexer multiplexer = IoMultiplexer.AVAILABLE;
    @Config(key="nio.server.httpServerCodec.MaxInitialLineLength")
    private volatile int httpServerCodec_MaxInitialLineLength = 4096;
    @Config(key="nio.server.httpServerCodec.MaxHeaderSize")
    private volatile int httpServerCodec_MaxHeaderSize = 4096;
    @Config(key="nio.server.httpServerCodec.MaxChunkSize")
    private volatile int httpServerCodec_MaxChunkSize = 4096;
    @Config(key="nio.server.EventLoopGroup.AcceptorSize", desc="default AcceptorSize = number of bindings")
    private volatile int nioEventLoopGroupAcceptorSize = 0;
    private final int availableProcessors = Runtime.getRuntime().availableProcessors();
    @Config(key="nio.server.EventLoopGroup.WorkerSize", desc="default WorkerSize = CPU core x2 +1")
    private volatile int nioEventLoopGroupWorkerSize = this.availableProcessors * 2 + 1;
    @Config(key="nio.server.BizExecutor.mode", desc="valid value = CPU, IO (default), Mixed")
    private volatile ThreadingMode bizExecutorThreadingMode = ThreadingMode.IO;
    @Config(key="nio.server.BizExecutor.CoreSize", desc="use CPU core + 1 when application is CPU bound\nuse CPU core x 2 + 1 when application is I/O bound\nneed to find the best value based on your performance test result when nio.server.BizExecutor.mode=Mixed")
    private volatile int bizExecutorCoreSize = this.availableProcessors * 2 + 1;
    private volatile int currentCore;
    @Config(key="nio.server.BizExecutor.MaxSize")
    private volatile int bizExecutorMaxSize = this.availableProcessors * 2 + 1;
    private volatile int currentMax;
    @Config(key="nio.server.BizExecutor.QueueSize")
    private volatile int bizExecutorQueueSize = Integer.MAX_VALUE;
    private volatile int currentQueue;
    @ConfigHeader(title="4.2 Netty Performance - NIO and Biz Exector Pool")
    private ThreadPoolExecutor tpe = new ThreadPoolExecutor(this.bizExecutorCoreSize, this.bizExecutorMaxSize, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(this.bizExecutorQueueSize), Executors.defaultThreadFactory(), new AbortPolicyWithReport("NIOBizThreadPoolExecutor"));
    @Config(key="nio.server.BizExecutor.bizTimeoutWarnThreshold")
    private volatile int bizTimeoutWarnThreshold = 5000;
    @ConfigHeader(title="4.3 Netty Channel Handler")
    @Config(key="nio.server.ReaderIdleTime", desc="rec Idle enabled only when value > 0")
    private volatile int readerIdleTime = 0;
    @Config(key="nio.server.WriterIdleTime", desc="Sent Idle enabled only when value > 0")
    private volatile int writerIdleTime = 0;
    @Config(key="nio.server.health.InspectionIntervalSeconds")
    private volatile int healthInspectionIntervalSeconds = 5;
    @JsonIgnore
    private Injector INJECTOR;
    @Config(key="nio.HttpService.enabled")
    private volatile boolean httpService = true;
    @Config(key="nio.JAX-RS.fromJson.failOnUnknownProperties")
    private volatile boolean fromJsonFailOnUnknownProperties = true;
    @Config(key="nio.JAX-RS.toJson.IgnoreNull")
    private volatile boolean toJsonIgnoreNull = true;
    @Config(key="nio.JAX-RS.toJson.Pretty")
    private volatile boolean toJsonPretty = false;
    @Config(key="nio.HttpFileUploadHandler")
    private volatile String fielUploadHandlerAnnotatedName = null;
    @Config(key="nio.HttpPingHandler")
    private volatile String pingHandlerAnnotatedName = BootHttpPingHandler.class.getName();
    @Config(key="nio.HttpRequestHandler")
    private volatile String requestHandlerAnnotatedName = "BootHttpRequestHandler";
    @Config(key="nio.WebSocket.Compress")
    private volatile boolean compressWebSocket = false;
    @ConfigHeader(title="5. IO Communication logging filter")
    @Config(key="nio.verbose.filter.usertype", desc="5.1 caller filter\nvalid value = id, uid, group, role, ignore")
    private volatile VerboseTargetUserType filterUserType = VerboseTargetUserType.ignore;
    @Config(key="nio.verbose.filter.usertype.range", desc="user range (when type=CallerId): N1 - N2 or N1, N2, ... , Nn \nuser range (when type=CallerName): johndoe, janedoe")
    private volatile String filterUserVaue;
    private volatile Set<String> filterCallerNameSet;
    private volatile Set<Long> filterCallerIdSet;
    private volatile long filterCallerIdFrom;
    private volatile long filterCallerIdTo;
    @Config(key="nio.verbose.filter.codetype", desc="valid value = HttpStatusCode, AppErrorCode, all, ignore")
    private volatile VerboseTargetCodeType filterCodeType = VerboseTargetCodeType.all;
    @Config(key="nio.verbose.filter.codetype.range", desc="5.2 error code filter\ncode range: N1 - N2 or N1, N2, ... , Nn")
    private volatile String filterCodeVaue;
    private volatile Set<Long> filterCodeSet;
    private volatile long filterCodeRangeFrom;
    private volatile long filterCodeRangeTo;
    @Config(key="nio.verbose.aspect.ReqHeader")
    private volatile boolean verboseReqHeader = true;
    @Config(key="nio.verbose.aspect.ReqContent")
    private volatile boolean verboseReqContent = true;
    @Config(key="nio.verbose.aspect.RespHeader")
    private volatile boolean verboseRespHeader = true;
    @Config(key="nio.verbose.aspect.RespContent")
    private volatile boolean verboseRespContent = true;
    @ConfigHeader(title="6. POI logging filter")
    @Config(key="nio.verbose.ServiceTimePOI.type", desc="valid value = filter, all, ignore")
    private volatile VerboseTargetPOIType filterPOIType = VerboseTargetPOIType.all;
    @Config(key="nio.verbose.ServiceTimePOI.filter", defaultValue="auth.begin, auth.end, db.begin, db.end", desc="CSV format")
    private volatile Set<String> filterPOISet;
    private static final String HEADER_SERVER_RESPONSE = "server.DefaultResponseHttpHeaders.";
    @ConfigHeader(title="7. Web Server Mode")
    @Config(key="server.http.web.docroot")
    private volatile String docroot = "docroot";
    @Config(key="server.http.web.resources")
    private volatile String webResources = "web-resources/errorpages";
    @Config(key="server.http.web.welcomePage")
    private volatile String welcomePage = "index.html";
    @Config(key="server.http.web-server.tempupload")
    private volatile String tempUoload = "tempupload";
    private volatile boolean downloadMode;
    private volatile File rootFolder;
    @ConfigHeader(title="8. Default Server Response HTTP Headers", desc="put generic HTTP response headers here", format="server.DefaultResponseHttpHeaders.?=?", example="server.DefaultResponseHttpHeaders.Access-Control-Allow-Origin=https://www.summerboot.org\nserver.DefaultResponseHttpHeaders.Access-Control-Allow-Headers=X-Requested-With, Content-Type, Origin, Authorization\nserver.DefaultResponseHttpHeaders.Access-Control-Allow-Methods=PUT,GET,POST,DELETE,OPTIONS,PATCH\nserver.DefaultResponseHttpHeaders.Access-Control-Allow-Credentials=false\nserver.DefaultResponseHttpHeaders.Access-Control-Allow-Credentials=false\nserver.DefaultResponseHttpHeaders.Access-Control-Max-Age=3600\nserver.DefaultResponseHttpHeaders.Content-Security-Policy=default-src 'self';script-src 'self' www.google-analytics.com www.google.com www.gstatic. js.stripe.com ajax.cloudflare.com;style-src 'self' 'unsafe-inline' cdnjs.cloudflare.com;img-src 'self' www.google-analytics.com stats.g.doubleclick.net www.gstatic.com;font-src 'self' cdnjs.cloudflare.com fonts.gstatic.com;base-uri 'self';child-src www.google.com js.stripe.com;form-action 'self';frame-ancestors 'none';report-uri=\"https://www.summerboot.org/report-uri\"\nserver.DefaultResponseHttpHeaders.X-XSS-Protection=1; mode=block\nserver.DefaultResponseHttpHeaders.Strict-Transport-Security=max-age=31536000;includeSubDomains;preload\nserver.DefaultResponseHttpHeaders.X-Frame-Options=sameorigin\nserver.DefaultResponseHttpHeaders.Expect-CT=max-age=86400, enforce, report-uri=\"https://www.summerboot.org/report-uri\"\nserver.DefaultResponseHttpHeaders.X-Content-Type-Options=nosniff\nserver.DefaultResponseHttpHeaders.Feature-Policy=autoplay 'none';camera 'none' ")
    private final HttpHeaders serverDefaultResponseHeaders = new DefaultHttpHeaders(true);
    private String docrootDir;
    private String tempUoloadDir;
    private static final ChannelInboundHandler DefaultFileUploadRejector = new BootHttpFileUploadRejector();

    public static void main(String[] args) {
        String t = NioConfig.generateTemplate(NioConfig.class);
        System.out.println(t);
    }

    protected NioConfig() {
    }

    @Override
    public void shutdown() {
        String tn = Thread.currentThread().getName();
        NioServer.shutdown();
        if (this.tpe != null && !this.tpe.isShutdown()) {
            System.out.println(tn + ": shutdown tpe");
            this.tpe.shutdown();
        }
    }

    public HttpHeaders getServerDefaultResponseHeaders() {
        return this.serverDefaultResponseHeaders;
    }

    @Override
    protected void loadCustomizedConfigs(File cfgFile, boolean isReal, ConfigUtil helper, Properties props) throws Exception {
        Long[] a;
        String key;
        this.rootFolder = cfgFile.getParentFile().getParentFile();
        this.docrootDir = null;
        this.docrootDir = this.rootFolder.getName() + File.separator + this.docroot;
        this.downloadMode = StringUtils.isBlank((CharSequence)this.welcomePage);
        this.tempUoloadDir = null;
        this.tempUoloadDir = this.rootFolder.getAbsolutePath() + File.separator + this.tempUoload;
        this.serverDefaultResponseHeaders.clear();
        Set _keys = props.keySet().stream().map(o -> o.toString()).collect(Collectors.toSet());
        ArrayList<String> keys = new ArrayList<String>(_keys);
        keys.forEach(name -> {
            if (name.startsWith(HEADER_SERVER_RESPONSE)) {
                String[] names = name.split("\\.");
                String headerName = names[2];
                String headerValue = props.getProperty((String)name);
                this.serverDefaultResponseHeaders.set(headerName, (Object)headerValue);
            }
        });
        if (this.nioEventLoopGroupAcceptorSize < 1) {
            this.nioEventLoopGroupAcceptorSize = this.bindingAddresses.size();
        }
        if (this.nioEventLoopGroupWorkerSize < 1) {
            this.nioEventLoopGroupWorkerSize = this.availableProcessors * 2 + 1;
        }
        switch (this.bizExecutorThreadingMode) {
            case CPU: {
                this.bizExecutorCoreSize = this.availableProcessors + 1;
                this.bizExecutorMaxSize = this.availableProcessors + 1;
                break;
            }
            case IO: {
                this.bizExecutorCoreSize = this.availableProcessors * 2 + 1;
                this.bizExecutorMaxSize = this.availableProcessors * 2 + 1;
                break;
            }
            case Mixed: {
                if (this.bizExecutorCoreSize < 1) {
                    this.bizExecutorCoreSize = this.availableProcessors * 2 + 1;
                }
                if (this.bizExecutorMaxSize < 1) {
                    this.bizExecutorMaxSize = this.availableProcessors * 2 + 1;
                }
                if (this.bizExecutorMaxSize >= this.bizExecutorCoreSize) break;
                helper.addError("BizExecutor.MaxSize should not less than BizExecutor.CoreSize");
            }
        }
        if (this.currentCore != this.bizExecutorCoreSize || this.currentMax != this.bizExecutorMaxSize || this.currentQueue != this.bizExecutorQueueSize) {
            this.currentCore = this.bizExecutorCoreSize;
            this.currentMax = this.bizExecutorMaxSize;
            this.currentQueue = this.bizExecutorQueueSize;
            ThreadPoolExecutor old = this.tpe;
            this.tpe = new ThreadPoolExecutor(this.currentCore, this.currentMax, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(this.currentQueue), Executors.defaultThreadFactory(), new AbortPolicyWithReport("NIOBizThreadPoolExecutor"));
            if (old != null) {
                old.shutdown();
            }
        }
        if (this.INJECTOR != null) {
            if (this.fielUploadHandlerAnnotatedName != null) {
                try {
                    this.INJECTOR.getInstance(Key.get(ChannelHandler.class, (Annotation)Names.named((String)this.fielUploadHandlerAnnotatedName)));
                    Path dir = Paths.get(this.tempUoloadDir, new String[0]).toAbsolutePath();
                    Files.createDirectories(dir, new FileAttribute[0]);
                }
                catch (Throwable ex) {
                    helper.addError("invalid HttpFileUpload Channel Handler name(" + this.fielUploadHandlerAnnotatedName + "): " + ex.toString());
                }
            }
            if (this.pingHandlerAnnotatedName != null) {
                try {
                    this.INJECTOR.getInstance(Key.get(ChannelHandler.class, (Annotation)Names.named((String)this.pingHandlerAnnotatedName)));
                }
                catch (Throwable ex) {
                    helper.addError("invalid Ping Channel Handler name(" + this.pingHandlerAnnotatedName + "): " + ex.toString());
                }
            }
            if (this.requestHandlerAnnotatedName != null) {
                try {
                    this.INJECTOR.getInstance(Key.get(ChannelHandler.class, (Annotation)Names.named((String)this.requestHandlerAnnotatedName)));
                }
                catch (Throwable ex) {
                    helper.addError("invalid Request Channel Handler name(" + this.requestHandlerAnnotatedName + "): " + ex.toString());
                }
            }
        }
        BeanUtil.configure(this.fromJsonFailOnUnknownProperties, this.toJsonPretty, this.toJsonIgnoreNull);
        switch (this.filterUserType) {
            case id: {
                key = "nio.verbose.filter.usertype.range";
                this.filterCallerIdSet = new HashSet<Long>();
                a = helper.getAsRangeLong(props, key, this.filterCallerIdSet);
                if (a == null) break;
                this.filterCallerIdFrom = a[0];
                this.filterCallerIdTo = a[1];
                this.filterCallerIdSet = null;
                break;
            }
            case uid: 
            case group: 
            case role: {
                key = "nio.verbose.filter.usertype.range";
                String[] na = helper.getAsCSV(props, key, null);
                this.filterCallerNameSet = new HashSet<String>();
                this.filterCallerNameSet.addAll(Arrays.asList(na));
            }
        }
        switch (this.filterCodeType) {
            case HttpStatusCode: 
            case AppErrorCode: {
                key = "nio.verbose.filter.codetype.range";
                this.filterCodeSet = new HashSet<Long>();
                a = helper.getAsRangeLong(props, key, this.filterCodeSet);
                if (a == null) break;
                this.filterCodeRangeFrom = a[0];
                this.filterCodeRangeTo = a[1];
                this.filterCodeSet = null;
            }
        }
    }

    ThreadPoolExecutor getBizExecutor() {
        return this.tpe;
    }

    public void setGuiceInjector(Injector _injector) {
        this.INJECTOR = _injector;
    }

    @JsonIgnore
    public ChannelHandler getHttpFileUploadHandler() {
        if (this.fielUploadHandlerAnnotatedName == null) {
            return DefaultFileUploadRejector;
        }
        return (ChannelHandler)this.INJECTOR.getInstance(Key.get(ChannelHandler.class, (Annotation)Names.named((String)this.fielUploadHandlerAnnotatedName)));
    }

    @JsonIgnore
    public ChannelHandler getPingHandler() {
        if (this.pingHandlerAnnotatedName == null) {
            return null;
        }
        return (ChannelHandler)this.INJECTOR.getInstance(Key.get(ChannelHandler.class, (Annotation)Names.named((String)this.pingHandlerAnnotatedName)));
    }

    @JsonIgnore
    public ChannelHandler getRequestHandler() {
        if (this.requestHandlerAnnotatedName == null) {
            return null;
        }
        return (ChannelHandler)this.INJECTOR.getInstance(Key.get(ChannelHandler.class, (Annotation)Names.named((String)this.requestHandlerAnnotatedName)));
    }

    public boolean isCompressWebSocket() {
        return this.compressWebSocket;
    }

    public Map<String, Integer> getBindingAddresses() {
        return this.bindingAddresses;
    }

    public KeyManagerFactory getKmf() {
        return this.kmf;
    }

    public TrustManagerFactory getTmf() {
        return this.tmf;
    }

    public boolean isVerifyCertificateHost() {
        return this.verifyCertificateHost;
    }

    public SslProvider getSslProvider() {
        return this.sslProvider;
    }

    public String[] getSslProtocols() {
        return this.sslProtocols;
    }

    public String[] getSslCipherSuites() {
        return this.sslCipherSuites;
    }

    public boolean isSoReuseAddr() {
        return this.soReuseAddr;
    }

    public boolean isSoKeepAlive() {
        return this.soKeepAlive;
    }

    public boolean isSoTcpNodelay() {
        return this.soTcpNodelay;
    }

    public int getSoLinger() {
        return this.soLinger;
    }

    public int getSslHandshakeTimeout() {
        return this.sslHandshakeTimeout;
    }

    public int getSoConnectionTimeout() {
        return this.soConnectionTimeout;
    }

    public int getSoBacklog() {
        return this.soBacklog;
    }

    public int getSoRcvBuf() {
        return this.soRcvBuf;
    }

    public int getSoSndBuf() {
        return this.soSndBuf;
    }

    public int getHttpObjectAggregatorMaxContentLength() {
        return this.httpObjectAggregatorMaxContentLength;
    }

    public IoMultiplexer getMultiplexer() {
        return this.multiplexer;
    }

    public int getHttpServerCodec_MaxInitialLineLength() {
        return this.httpServerCodec_MaxInitialLineLength;
    }

    public int getHttpServerCodec_MaxHeaderSize() {
        return this.httpServerCodec_MaxHeaderSize;
    }

    public int getHttpServerCodec_MaxChunkSize() {
        return this.httpServerCodec_MaxChunkSize;
    }

    public int getNioEventLoopGroupAcceptorSize() {
        return this.nioEventLoopGroupAcceptorSize;
    }

    public int getNioEventLoopGroupWorkerSize() {
        return this.nioEventLoopGroupWorkerSize;
    }

    public ThreadingMode getBizExecutorThreadingMode() {
        return this.bizExecutorThreadingMode;
    }

    public int getBizExecutorCoreSize() {
        return this.bizExecutorCoreSize;
    }

    public int getBizExecutorMaxSize() {
        return this.bizExecutorMaxSize;
    }

    public int getBizExecutorQueueSize() {
        return this.bizExecutorQueueSize;
    }

    public int getBizTimeoutWarnThreshold() {
        return this.bizTimeoutWarnThreshold;
    }

    public int getReaderIdleTime() {
        return this.readerIdleTime;
    }

    public int getWriterIdleTime() {
        return this.writerIdleTime;
    }

    public int getHealthInspectionIntervalSeconds() {
        return this.healthInspectionIntervalSeconds;
    }

    public boolean isHttpService() {
        return this.httpService;
    }

    public boolean isFromJsonFailOnUnknownProperties() {
        return this.fromJsonFailOnUnknownProperties;
    }

    public boolean isToJsonIgnoreNull() {
        return this.toJsonIgnoreNull;
    }

    public boolean isToJsonPretty() {
        return this.toJsonPretty;
    }

    public String getFielUploadHandlerAnnotatedName() {
        return this.fielUploadHandlerAnnotatedName;
    }

    public String getPingHandlerAnnotatedName() {
        return this.pingHandlerAnnotatedName;
    }

    public String getRequestHandlerAnnotatedName() {
        return this.requestHandlerAnnotatedName;
    }

    public VerboseTargetUserType getFilterUserType() {
        return this.filterUserType;
    }

    public Set<String> getFilterCallerNameSet() {
        return this.filterCallerNameSet;
    }

    public Set<Long> getFilterCallerIdSet() {
        return this.filterCallerIdSet;
    }

    public long getFilterCallerIdFrom() {
        return this.filterCallerIdFrom;
    }

    public long getFilterCallerIdTo() {
        return this.filterCallerIdTo;
    }

    public VerboseTargetCodeType getFilterCodeType() {
        return this.filterCodeType;
    }

    public Set<Long> getFilterCodeSet() {
        return this.filterCodeSet;
    }

    public long getFilterCodeRangeFrom() {
        return this.filterCodeRangeFrom;
    }

    public long getFilterCodeRangeTo() {
        return this.filterCodeRangeTo;
    }

    public boolean isVerboseReqHeader() {
        return this.verboseReqHeader;
    }

    public boolean isVerboseReqContent() {
        return this.verboseReqContent;
    }

    public boolean isVerboseRespHeader() {
        return this.verboseRespHeader;
    }

    public boolean isVerboseRespContent() {
        return this.verboseRespContent;
    }

    public VerboseTargetPOIType getFilterPOIType() {
        return this.filterPOIType;
    }

    public Set<String> getFilterPOISet() {
        return this.filterPOISet;
    }

    public File getRootFolder() {
        return this.rootFolder;
    }

    public String getDocrootDir() {
        return this.docrootDir;
    }

    public String getWebResources() {
        return this.webResources;
    }

    public String getWelcomePage() {
        return this.welcomePage;
    }

    public boolean isDownloadMode() {
        return this.downloadMode;
    }

    public String getTempUoloadDir() {
        return this.tempUoloadDir;
    }

    public static enum ThreadingMode {
        CPU,
        IO,
        Mixed;

    }

    public static enum VerboseTargetUserType {
        id,
        uid,
        group,
        role,
        ignore;

    }

    public static enum VerboseTargetCodeType {
        HttpStatusCode,
        AppErrorCode,
        all,
        ignore;

    }

    public static enum VerboseTargetPOIType {
        filter,
        all,
        ignore;

    }
}

