/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.util.pdf;

import com.openhtmltopdf.outputdevice.helper.BaseRendererBuilder;
import com.openhtmltopdf.pdfboxout.PdfBoxRenderer;
import com.openhtmltopdf.pdfboxout.PdfRendererBuilder;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.apache.pdfbox.pdmodel.encryption.AccessPermission;
import org.apache.pdfbox.pdmodel.encryption.ProtectionPolicy;
import org.apache.pdfbox.pdmodel.encryption.StandardProtectionPolicy;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import org.apache.pdfbox.rendering.ImageType;
import org.apache.pdfbox.rendering.PDFRenderer;

public class PDFBox {
    private static final Map<String, PDFont> FONTS = new HashMap<String, PDFont>();
    private static File[] fontFiles = null;
    private static Map<File, String> fonts = null;
    private static final AccessPermission DEFAULT_AP = PDFBox.buildDefaultAccessPermission();
    private static final int DEFAULT_KEY_LENGTH = 256;

    public static PDFont getFont(String name) {
        return FONTS.get(name);
    }

    public static int loadFonts(File fontCacheDir, File fontDir) throws IOException {
        if (fontCacheDir != null) {
            fontCacheDir.mkdirs();
            System.setProperty("pdfbox.fontcache", fontCacheDir.getAbsolutePath());
        }
        if (fontDir == null) {
            return 0;
        }
        if (!fontDir.isDirectory()) {
            throw new IOException("Not a directory: " + fontDir);
        }
        fontFiles = fontDir.listFiles((dir1, name) -> {
            String lower = name.toLowerCase();
            return lower.endsWith(".ttf") || lower.endsWith(".ttc");
        });
        if (fontFiles != null && fontFiles.length > 0) {
            fonts = new HashMap<File, String>();
            for (File file : fontFiles) {
                String fileName = file.getName();
                String fontFamily = fileName.substring(0, fileName.lastIndexOf("."));
                fonts.put(file.getAbsoluteFile(), fontFamily);
            }
        }
        return fontFiles == null ? 0 : fontFiles.length;
    }

    public static File[] getFontFiles() {
        return fontFiles;
    }

    public static Map<File, String> getFonts() {
        return Map.copyOf(fonts);
    }

    public static int useFonts(PdfRendererBuilder builder, PDDocument doc) throws IOException {
        if (fonts == null || fonts.isEmpty()) {
            return 0;
        }
        for (File fontFile : fonts.keySet()) {
            String fileName;
            String fontFamily = fonts.get(fontFile);
            if (builder != null) {
                builder.useFont(fontFile, fontFamily);
            }
            if (doc == null || (fileName = fontFile.getName()).endsWith(".otf")) continue;
            PDType0Font font = PDType0Font.load((PDDocument)doc, (File)fontFile);
            FONTS.put(fontFamily, (PDFont)font);
        }
        return fontFiles.length;
    }

    public static AccessPermission buildDefaultAccessPermission() {
        AccessPermission ap = new AccessPermission();
        ap.setCanAssembleDocument(false);
        ap.setCanExtractContent(false);
        ap.setCanExtractForAccessibility(true);
        ap.setCanFillInForm(true);
        ap.setCanModify(false);
        ap.setCanModifyAnnotations(true);
        ap.setCanPrint(true);
        ap.setCanPrintDegraded(true);
        ap.setReadOnly();
        return ap;
    }

    public static StandardProtectionPolicy buildStandardProtectionPolicy(String userPwd, String ownerPwd) {
        return PDFBox.buildStandardProtectionPolicy(userPwd, ownerPwd, DEFAULT_AP, 256);
    }

    public static StandardProtectionPolicy buildStandardProtectionPolicy(String userPwd, String ownerPwd, AccessPermission ap, int keyLenth) {
        if (StringUtils.isBlank((CharSequence)ownerPwd)) {
            ownerPwd = RandomStringUtils.randomAlphanumeric((int)10);
        }
        StandardProtectionPolicy spp = new StandardProtectionPolicy(ownerPwd, userPwd, ap);
        spp.setEncryptionKeyLength(keyLenth);
        return spp;
    }

    public static byte[] html2PDF(String html, File baseDir, ProtectionPolicy protectionPolicy, PDDocumentInformation info2, float pdfVersion) throws IOException {
        return PDFBox.html2PDF(html, baseDir, protectionPolicy, info2, pdfVersion, 8.5f, 11.0f, null);
    }

    public static byte[] html2PDF(String html, File baseDir, ProtectionPolicy protectionPolicy, PDDocumentInformation info2, float pdfVersion, float pageWidth, float pageHeight, BaseRendererBuilder.PageSizeUnits units) throws IOException {
        PdfRendererBuilder builder = new PdfRendererBuilder();
        PDFBox.useFonts(builder, null);
        builder.withHtmlContent(html, PDFBox.buildBaseDocumentUri1(baseDir));
        if (info2 != null) {
            builder.withProducer(info2.getProducer());
        }
        builder.useFastMode();
        if (units != null) {
            builder.useDefaultPageSize(pageWidth, pageHeight, units);
        }
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            builder.toStream((OutputStream)baos);
            try (PdfBoxRenderer renderer = builder.buildPdfRenderer();
                 PDDocument doc = renderer.getPdfDocument();){
                if (protectionPolicy == null) {
                    protectionPolicy = PDFBox.buildStandardProtectionPolicy(null, null);
                }
                doc.protect(protectionPolicy);
                doc.setVersion(pdfVersion);
                renderer.layout();
                renderer.createPDF();
            }
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
    }

    private static String buildBaseDocumentUri1(File baseDirectory) throws IOException {
        try {
            return baseDirectory.toURI().toURL().toExternalForm();
        }
        catch (MalformedURLException ex) {
            throw new IOException("Invalid baseDirectory=" + baseDirectory, ex);
        }
    }

    public static List<byte[]> pdf2Images(byte[] pdfData, float dpi, String formatName) throws IOException {
        return PDFBox.pdf2Images(pdfData, dpi, ImageType.RGB, formatName);
    }

    public static List<byte[]> pdf2Images(byte[] pdfData, float dpi, ImageType imageType, String formatName) throws IOException {
        List<BufferedImage> images = PDFBox.pdf2Images(pdfData, dpi, imageType);
        List<byte[]> imageDatas = PDFBox.images2Bytes(images, formatName);
        return imageDatas;
    }

    public static List<byte[]> pdf2Images(File pdfFile, float dpi, ImageType imageType, String formatName) throws IOException {
        List<BufferedImage> images = PDFBox.pdf2Images(pdfFile, dpi, imageType);
        List<byte[]> imageDatas = PDFBox.images2Bytes(images, formatName);
        return imageDatas;
    }

    public static List<BufferedImage> pdf2Images(byte[] pdfData, float dpi, ImageType imageType) throws IOException {
        try (PDDocument document = PDDocument.load((byte[])pdfData);){
            List<BufferedImage> list = PDFBox.pdf2Images(document, dpi, imageType);
            return list;
        }
    }

    public static List<BufferedImage> pdf2Images(File pdfFile, float dpi, ImageType imageType) throws IOException {
        try (PDDocument document = PDDocument.load((File)pdfFile);){
            List<BufferedImage> list = PDFBox.pdf2Images(document, dpi, imageType);
            return list;
        }
    }

    public static List<BufferedImage> pdf2Images(PDDocument document, float dpi, ImageType imageType) throws IOException {
        PDFRenderer renderer = new PDFRenderer(document);
        int totalPages = document.getNumberOfPages();
        ArrayList<BufferedImage> images = new ArrayList<BufferedImage>();
        for (int currentPage = 0; currentPage < totalPages; ++currentPage) {
            BufferedImage image = renderer.renderImageWithDPI(currentPage, dpi, imageType);
            images.add(image);
        }
        return images;
    }

    public static List<byte[]> images2Bytes(List<BufferedImage> images, String formatName) throws IOException {
        ArrayList<byte[]> imageDataList = new ArrayList<byte[]>(images.size());
        for (BufferedImage image : images) {
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                ImageIO.write((RenderedImage)image, formatName, baos);
                byte[] imageData = baos.toByteArray();
                imageDataList.add(imageData);
            }
        }
        return imageDataList;
    }

    public static byte[] writePDF(Writer writer, Object dto, float pdfVersion) throws IOException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            byte[] byArray;
            try (PDDocument doc = new PDDocument();){
                PDFBox.useFonts(null, doc);
                doc.protect((ProtectionPolicy)PDFBox.buildStandardProtectionPolicy(null, null));
                doc.setVersion(pdfVersion);
                writer.write(doc, dto);
                doc.save((OutputStream)baos);
                byArray = baos.toByteArray();
            }
            return byArray;
        }
    }

    public static interface Writer<T> {
        public void write(PDDocument var1, T var2) throws IOException;
    }
}

