/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.integration.smtp;

import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import jakarta.mail.Address;
import jakarta.mail.BodyPart;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.Session;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import jakarta.mail.util.ByteArrayDataSource;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.summerboot.jexpress.integration.smtp.SMTPClientConfig;

@Deprecated
public class EmailBuilder {
    protected static SMTPClientConfig smtpCfg = SMTPClientConfig.cfg;
    private String from;
    private String[] toList;
    private String[] ccList;
    private String[] bccList;
    private String subject;
    private String body;
    private Format format;
    private List<EmailAttachment> attachments;

    public static void config(File cfgFile) throws IOException, GeneralSecurityException {
    }

    public static String configInfo() {
        return smtpCfg.toString();
    }

    public EmailBuilder() {
    }

    public EmailBuilder(String from, String[] to, String[] cc, String[] bcc, String subject, String body, Format format) {
        this.from = from;
        this.toList = to;
        this.ccList = cc;
        this.bccList = bcc;
        this.subject = subject;
        this.body = body;
        this.format = format;
    }

    public void addAttachment(EmailAttachment att) {
        if (this.attachments == null) {
            this.attachments = new ArrayList<EmailAttachment>();
        }
        this.attachments.add(att);
    }

    public void removeAttachments() {
        this.attachments.clear();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\n\t from=").append(this.from).append("\n\t to=").append(Arrays.toString(this.toList)).append("\n\t cc=").append(Arrays.toString(this.ccList)).append("\n\t bcc=").append(Arrays.toString(this.bccList)).append("\n\t subject=").append(this.subject).append("\n\t format=").append((Object)this.format).append("\n\t body=").append(this.body);
        return sb.toString();
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String title, String email) {
        this.from = title == null ? email : title + " <" + email + ">";
    }

    public void setFrom(String email) {
        this.from = email;
    }

    public String[] getToList() {
        return this.toList;
    }

    public void setToList(String ... toList) {
        this.toList = toList;
    }

    public String[] getCcList() {
        return this.ccList;
    }

    public void setCcList(String ... ccList) {
        this.ccList = ccList;
    }

    public String[] getBccList() {
        return this.bccList;
    }

    public void setBccList(String ... bccList) {
        this.bccList = bccList;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public Format getFormat() {
        return this.format;
    }

    public void setFormat(Format format) {
        this.format = format;
    }

    public List<EmailAttachment> getAttachments() {
        return this.attachments;
    }

    public MimeMessage buildMimeMessage() throws MessagingException {
        return this.buildMimeMessage(smtpCfg.getMailSession());
    }

    public MimeMessage buildMimeMessage(Session emailSession) throws MessagingException {
        EmailBuilder email = this;
        if (emailSession == null || email == null) {
            return null;
        }
        MimeMessage message = new MimeMessage(emailSession);
        if (StringUtils.isBlank((CharSequence)email.getFrom())) {
            email.setFrom(emailSession.getProperty("mail.smtp.userName"), emailSession.getProperty("mail.smtp.user"));
        }
        message.setFrom((Address)new InternetAddress(email.getFrom()));
        for (String to : email.getToList()) {
            message.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(to));
        }
        if (email.getCcList() != null) {
            for (String cc : email.getCcList()) {
                message.addRecipient(Message.RecipientType.CC, (Address)new InternetAddress(cc));
            }
        }
        if (email.getBccList() != null) {
            for (String bcc : email.getBccList()) {
                message.addRecipient(Message.RecipientType.BCC, (Address)new InternetAddress(bcc));
            }
        }
        message.setSentDate(new Date());
        message.setSubject(email.getSubject());
        MimeMultipart mimeMultipartList = new MimeMultipart();
        switch (email.getFormat()) {
            case text: {
                MimeBodyPart textBodyPart = new MimeBodyPart();
                mimeMultipartList.addBodyPart((BodyPart)textBodyPart);
                textBodyPart.setText(email.getBody());
                textBodyPart.setHeader("Content-Transfer-Encoding", "quoted-printable");
                textBodyPart.setHeader("Content-Type", "text/plain; charset=utf-8");
                break;
            }
            case html: {
                MimeBodyPart htmlBodyPart = new MimeBodyPart();
                mimeMultipartList.addBodyPart((BodyPart)htmlBodyPart);
                htmlBodyPart.setContent((Object)email.getBody(), "text/html; charset=utf-8");
            }
        }
        if (email.getAttachments() != null) {
            for (EmailAttachment attachement : email.getAttachments()) {
                MimeBodyPart attachmentBodyPart = new MimeBodyPart();
                mimeMultipartList.addBodyPart((BodyPart)attachmentBodyPart);
                ByteArrayDataSource ds = new ByteArrayDataSource(attachement.getDataStream(), "application/" + attachement.getType());
                attachmentBodyPart.setDataHandler(new DataHandler((DataSource)ds));
                attachmentBodyPart.setFileName(attachement.getFileName());
                if (attachement.getCid() == null) continue;
                attachmentBodyPart.addHeader("Content-ID", "<" + attachement.getCid() + ">");
            }
        }
        message.setContent((Multipart)mimeMultipartList);
        return message;
    }

    public static enum Format {
        html,
        text;

    }

    public static class EmailAttachment
    implements Serializable {
        private final String type;
        private final byte[] dataStream;
        private final String fileName;
        private String cid;

        public EmailAttachment(String type, byte[] dataStream, String fileName, String cid) {
            this.type = type;
            this.dataStream = dataStream;
            this.fileName = fileName;
            this.cid = cid;
        }

        public String getType() {
            return this.type;
        }

        public byte[] getDataStream() {
            return this.dataStream;
        }

        public String getFileName() {
            return this.fileName;
        }

        public String getCid() {
            return this.cid;
        }

        public void setCid(String cid) {
            this.cid = cid;
        }
    }
}

