/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.nio.server;

import com.google.inject.Singleton;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.util.ReferenceCountUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.summerboot.jexpress.boot.instrumentation.HealthMonitor;
import org.summerboot.jexpress.nio.server.NioCounter;
import org.summerboot.jexpress.nio.server.NioHttpUtil;

@ChannelHandler.Sharable
@Singleton
public class BootHttpPingHandler
extends SimpleChannelInboundHandler<HttpObject> {
    protected static Logger log = LogManager.getLogger((String)BootHttpPingHandler.class.getName());
    private final String pingURL;

    public BootHttpPingHandler() {
        super(FullHttpRequest.class, false);
        String endpointCfg = System.getProperty("pingURI");
        this.pingURL = StringUtils.isNotBlank((CharSequence)endpointCfg) ? endpointCfg : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void channelRead0(ChannelHandlerContext ctx, HttpObject httpObject) throws Exception {
        HttpRequest req;
        boolean isPingRequest = false;
        if (this.pingURL != null && httpObject instanceof HttpRequest && HttpMethod.GET.equals((Object)(req = (HttpRequest)httpObject).method()) && this.pingURL.equals(req.uri())) {
            isPingRequest = true;
            NioCounter.COUNTER_PING_HIT.incrementAndGet();
            try {
                HttpResponseStatus status = HealthMonitor.isServiceAvaliable() ? HttpResponseStatus.OK : HttpResponseStatus.SERVICE_UNAVAILABLE;
                NioHttpUtil.sendText(ctx, HttpUtil.isKeepAlive((HttpMessage)req), null, status, null, null, null, true);
            }
            finally {
                ReferenceCountUtil.release((Object)req);
            }
        }
        if (!isPingRequest) {
            ctx.fireChannelRead((Object)httpObject);
        }
    }
}

