/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.nio.server;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.netty.handler.codec.http.HttpHeaders;
import org.summerboot.jexpress.integration.cache.AuthTokenCache;
import org.summerboot.jexpress.nio.server.BootHttpRequestHandler;
import org.summerboot.jexpress.nio.server.RequestProcessor;
import org.summerboot.jexpress.nio.server.domain.ServiceContext;
import org.summerboot.jexpress.security.auth.Authenticator;

@Singleton
public class DefaultHttpRequestHandler
extends BootHttpRequestHandler {
    @Inject
    protected AuthTokenCache tokenCache;
    @Inject
    protected Authenticator auth;

    @Override
    protected boolean authenticationCheck(RequestProcessor processor, HttpHeaders httpRequestHeaders, String httpRequestPath, ServiceContext context) throws Exception {
        if (this.auth == null) {
            return true;
        }
        this.auth.verifyBearerToken(httpRequestHeaders, this.tokenCache, null, context);
        return context.caller() != null;
    }

    @Override
    protected boolean preProcess(RequestProcessor processor, HttpHeaders httpRequestHeaders, String httpRequestPath, ServiceContext context) throws Exception {
        return true;
    }
}

