/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.util.annotation;

import com.google.common.base.Preconditions;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import java.util.Arrays;
import java.util.List;
import org.summerboot.jexpress.util.annotation.OneOf;

public class OneOfValidator
implements ConstraintValidator<OneOf, List<String>> {
    private List<String> theOneOfList;

    public void initialize(OneOf constraintAnnotation) {
        this.theOneOfList = Arrays.asList(constraintAnnotation.value());
        Preconditions.checkArgument((boolean)this.theOneOfList.isEmpty(), (Object)"Empty list input found in @OneOf annotation");
    }

    public boolean isValid(List<String> values, ConstraintValidatorContext context) {
        if (values == null || values.isEmpty()) {
            return false;
        }
        boolean isvalid = true;
        for (String value : values) {
            if (!isvalid || this.theOneOfList.contains(value)) continue;
            isvalid = false;
            break;
        }
        return isvalid;
    }
}

