/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.boot;

import com.google.inject.AbstractModule;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.summerboot.jexpress.boot.SummerSingularity;

public class ScanedGuiceModule
extends AbstractModule {
    private final Map<Class, Map<String, List<SummerSingularity.ServiceMetadata>>> scanedServiceBindingMap;
    private final Set<String> userSpecifiedImplTags;
    private final StringBuilder memo;

    public ScanedGuiceModule(Map<Class, Map<String, List<SummerSingularity.ServiceMetadata>>> scanedServiceBindingMap, Set<String> userSpecifiedImplTags, StringBuilder memo) {
        this.scanedServiceBindingMap = scanedServiceBindingMap;
        this.userSpecifiedImplTags = userSpecifiedImplTags;
        this.memo = memo;
    }

    protected boolean isCliUseImplTag(String implTag) {
        return this.userSpecifiedImplTags.contains(implTag);
    }

    public void configure() {
        String ARROW = " --> ";
        for (Class interfaceClass : this.scanedServiceBindingMap.keySet()) {
            Map<String, List<SummerSingularity.ServiceMetadata>> taggeServicedMap = this.scanedServiceBindingMap.get(interfaceClass);
            SummerSingularity.ServiceMetadata defaultImpl = null;
            SummerSingularity.ServiceMetadata tagMatchImpl = null;
            SummerSingularity.ServiceMetadata bindingImpl = null;
            boolean needToBindOneToOne = false;
            for (String uniqueKey : taggeServicedMap.keySet()) {
                SummerSingularity.ServiceMetadata namedBindingImpl;
                SummerSingularity.ServiceMetadata serviceImpl = taggeServicedMap.get(uniqueKey).get(0);
                if (serviceImpl == null) continue;
                String implTag = serviceImpl.getImplTag();
                boolean isCliUseImplTag = this.isCliUseImplTag(implTag);
                this.memo.append("\n\t- Ioc.taggedservice.check: ").append(interfaceClass.getName()).append(", implTag=").append(uniqueKey).append(ARROW).append(serviceImpl).append(", isCliUseImplTag=").append(isCliUseImplTag);
                String named = serviceImpl.getNamed();
                boolean isOnToOne = "".equals(named);
                if (isOnToOne) {
                    needToBindOneToOne = true;
                    if ("".equals(implTag)) {
                        defaultImpl = serviceImpl;
                    }
                    if (!isCliUseImplTag) continue;
                    tagMatchImpl = serviceImpl;
                    continue;
                }
                SummerSingularity.ServiceMetadata namedDefaultImpl = null;
                SummerSingularity.ServiceMetadata namedTagMatchImpl = null;
                if ("".equals(implTag)) {
                    namedDefaultImpl = serviceImpl;
                }
                if (isCliUseImplTag) {
                    namedTagMatchImpl = serviceImpl;
                }
                if ((namedBindingImpl = namedTagMatchImpl != null ? namedTagMatchImpl : namedDefaultImpl) == null) continue;
                Class implClass = namedBindingImpl.getServiceImplClass();
                this.bind(interfaceClass).annotatedWith((Annotation)Names.named((String)named)).to(implClass);
                this.memo.append("\n\t- Ioc.taggedservice.override: ").append(interfaceClass).append(" bind to ").append(implClass).append(", named=").append(named);
            }
            if (!needToBindOneToOne) continue;
            SummerSingularity.ServiceMetadata serviceMetadata = bindingImpl = tagMatchImpl != null ? tagMatchImpl : defaultImpl;
            if (bindingImpl == null) continue;
            Class implClass = bindingImpl.getServiceImplClass();
            this.bind(interfaceClass).to(implClass);
            this.memo.append("\n\t- Ioc.taggedservice.override: ").append(interfaceClass).append(" bind to ").append(implClass);
        }
    }
}

