/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.integration.ldap;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.SocketFactory;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.summerboot.jexpress.security.SSLUtil;

public class LdapSSLConnectionFactory
extends SocketFactory {
    private static final AtomicReference<LdapSSLConnectionFactory> defaultFactory = new AtomicReference();
    private SSLSocketFactory sf;
    public static String TLS_PROTOCOL = "TLSv1.3";
    private static KeyManager[] KMS;
    private static TrustManager[] TMS;

    public static void init(KeyManager[] kms, TrustManager[] tms, String protocol) {
        KMS = kms;
        TMS = tms;
        if (protocol != null) {
            TLS_PROTOCOL = protocol;
        }
    }

    public LdapSSLConnectionFactory() {
        try {
            SSLContext sslCtx = SSLUtil.buildSSLContext(KMS, TMS, TLS_PROTOCOL);
            this.sf = sslCtx.getSocketFactory();
        }
        catch (IOException | GeneralSecurityException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static SocketFactory getDefault() {
        LdapSSLConnectionFactory value = defaultFactory.get();
        if (value == null) {
            defaultFactory.compareAndSet(null, new LdapSSLConnectionFactory());
            return defaultFactory.get();
        }
        return value;
    }

    @Override
    public Socket createSocket(String s, int i) throws IOException {
        return this.sf.createSocket(s, i);
    }

    @Override
    public Socket createSocket(String s, int i, InetAddress inetAddress, int i1) throws IOException {
        return this.sf.createSocket(s, i, inetAddress, i1);
    }

    @Override
    public Socket createSocket(InetAddress inetAddress, int i) throws IOException {
        return this.sf.createSocket(inetAddress, i);
    }

    @Override
    public Socket createSocket(InetAddress inetAddress, int i, InetAddress inetAddress1, int i1) throws IOException {
        return this.sf.createSocket(inetAddress, i, inetAddress1, i1);
    }
}

