/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.nio.client;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.net.http.HttpResponse;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.summerboot.jexpress.nio.server.domain.Err;
import org.summerboot.jexpress.nio.server.domain.ServiceContext;
import org.summerboot.jexpress.nio.server.domain.ServiceErrorConvertible;

public class RPCResult<T, E extends ServiceErrorConvertible> {
    public static final ObjectMapper DefaultJacksonMapper = new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_NULL).setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
    private final HttpResponse httpResponse;
    private final String rpcResponseBody;
    private final int httpStatusCode;
    private final HttpResponseStatus httpStatus;
    private final boolean remoteSuccess;
    private T successResponse;
    private E errorResponse;

    public static void registerModules(Module ... modules) {
        DefaultJacksonMapper.registerModules(modules);
    }

    public static void configure(SerializationFeature f, boolean state) {
        DefaultJacksonMapper.configure(f, state);
    }

    public static void configure(DeserializationFeature f, boolean state) {
        DefaultJacksonMapper.configure(f, state);
    }

    public static void configure(JsonGenerator.Feature f, boolean state) {
        DefaultJacksonMapper.configure(f, state);
    }

    public static void configure(JsonParser.Feature f, boolean state) {
        DefaultJacksonMapper.configure(f, state);
    }

    public static void fromJsonFailOnUnknownProperties(boolean state) {
        RPCResult.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, state);
    }

    public RPCResult(HttpResponse httpResponse, boolean remoteSuccess) {
        this.httpResponse = httpResponse;
        this.rpcResponseBody = httpResponse == null ? null : String.valueOf(httpResponse.body());
        this.httpStatusCode = httpResponse == null ? 0 : httpResponse.statusCode();
        this.httpStatus = HttpResponseStatus.valueOf((int)this.httpStatusCode);
        this.remoteSuccess = remoteSuccess;
    }

    public HttpResponse httpResponse() {
        return this.httpResponse;
    }

    public HttpResponseStatus httpStatus() {
        return this.httpStatus;
    }

    public int httpStatusCode() {
        return this.httpStatusCode;
    }

    public String httpResponseBody() {
        return this.rpcResponseBody;
    }

    public boolean remoteSuccess() {
        return this.remoteSuccess;
    }

    public E errorResponse() {
        return this.errorResponse;
    }

    public T successResponse() {
        return this.successResponse;
    }

    public RPCResult<T, E> update(Class<T> successResponseClass, Class<E> errorResponseClass, ServiceContext context) {
        return this.update(DefaultJacksonMapper, null, successResponseClass, errorResponseClass, context);
    }

    public RPCResult<T, E> update(JavaType successResponseType, Class<E> errorResponseClass, ServiceContext context) {
        return this.update(DefaultJacksonMapper, successResponseType, null, errorResponseClass, context);
    }

    public RPCResult<T, E> update(JavaType successResponseType, Class<T> successResponseClass, Class<E> errorResponseClass, ServiceContext context) {
        return this.update(DefaultJacksonMapper, successResponseType, successResponseClass, errorResponseClass, context);
    }

    public RPCResult<T, E> update(ObjectMapper jacksonMapper, JavaType successResponseType, Class<T> successResponseClass, Class<E> errorResponseClass, ServiceContext context) {
        if (context != null) {
            context.status(this.httpStatus);
        }
        if (this.remoteSuccess) {
            this.successResponse = this.fromJson(jacksonMapper, successResponseType, successResponseClass, context);
        } else {
            this.errorResponse = (ServiceErrorConvertible)this.fromJson(jacksonMapper, null, errorResponseClass, context);
            if (this.errorResponse != null & context != null) {
                if (this.errorResponse.isSingleError()) {
                    Err e = this.errorResponse.toSerivceError();
                    context.error(e);
                } else {
                    List<Err> errors = this.errorResponse.toSerivceErrors();
                    context.errors(errors);
                }
            }
        }
        return this;
    }

    protected <R> R fromJson(ObjectMapper jacksonMapper, JavaType responseType, Class<R> responseClass, ServiceContext context) {
        Object ret;
        if (responseClass == null && responseType == null || StringUtils.isBlank((CharSequence)this.rpcResponseBody)) {
            return null;
        }
        if (jacksonMapper == null) {
            jacksonMapper = DefaultJacksonMapper;
        }
        try {
            ret = responseClass == null ? jacksonMapper.readValue(this.rpcResponseBody, responseType) : jacksonMapper.readValue(this.rpcResponseBody, responseClass);
        }
        catch (Throwable ex) {
            if (context != null) {
                Err e = new Err(25, "Unexpected RPC response format", this.rpcResponseBody, ex);
                context.status(HttpResponseStatus.BAD_GATEWAY).error(e);
            }
            ret = null;
        }
        return (R)ret;
    }

    static {
        RPCResult.registerModules(new Module[]{new JavaTimeModule()});
        RPCResult.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        RPCResult.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        RPCResult.configure(DeserializationFeature.FAIL_ON_IGNORED_PROPERTIES, false);
        RPCResult.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, true);
    }
}

