/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.nio.grpc;

import io.grpc.ManagedChannel;
import io.grpc.netty.shaded.io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder;
import io.grpc.netty.shaded.io.netty.channel.EventLoopGroup;
import io.grpc.netty.shaded.io.netty.channel.epoll.EpollDomainSocketChannel;
import io.grpc.netty.shaded.io.netty.channel.epoll.EpollEventLoopGroup;
import io.grpc.netty.shaded.io.netty.channel.unix.DomainSocketAddress;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContext;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContextBuilder;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslProvider;
import io.grpc.netty.shaded.io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import jakarta.annotation.Nullable;
import java.net.SocketAddress;
import java.net.URI;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManagerFactory;

public abstract class GRPCClient<T extends GRPCClient<T>> {
    protected final URI uri;
    protected final NettyChannelBuilder channelBuilder;
    protected ManagedChannel channel;

    public static NettyChannelBuilder getNettyChannelBuilder(URI uri, @Nullable KeyManagerFactory keyManagerFactory, @Nullable TrustManagerFactory trustManagerFactory, @Nullable String overrideAuthority, @Nullable Iterable<String> ciphers, String ... tlsVersionProtocols) throws SSLException {
        NettyChannelBuilder channelBuilder = null;
        switch (uri.getScheme()) {
            case "unix": {
                channelBuilder = NettyChannelBuilder.forAddress((SocketAddress)new DomainSocketAddress(uri.getPath())).eventLoopGroup((EventLoopGroup)new EpollEventLoopGroup()).channelType(EpollDomainSocketChannel.class).usePlaintext();
                break;
            }
            case "tcp": {
                channelBuilder = NettyChannelBuilder.forAddress((String)uri.getHost(), (int)uri.getPort());
                channelBuilder.usePlaintext();
                break;
            }
            case "tls": {
                channelBuilder = NettyChannelBuilder.forAddress((String)uri.getHost(), (int)uri.getPort());
                SslContextBuilder sslBuilder = GrpcSslContexts.forClient();
                sslBuilder.keyManager(keyManagerFactory);
                if (trustManagerFactory == null) {
                    sslBuilder.trustManager(InsecureTrustManagerFactory.INSTANCE);
                } else {
                    sslBuilder.trustManager(trustManagerFactory);
                    if (overrideAuthority != null) {
                        channelBuilder.overrideAuthority(overrideAuthority);
                    }
                }
                sslBuilder = GrpcSslContexts.configure((SslContextBuilder)sslBuilder, (SslProvider)SslProvider.OPENSSL);
                if (tlsVersionProtocols != null) {
                    sslBuilder.protocols(tlsVersionProtocols);
                }
                if (ciphers != null) {
                    sslBuilder.ciphers(ciphers);
                }
                SslContext sslContext = sslBuilder.build();
                channelBuilder.sslContext(sslContext).useTransportSecurity();
            }
        }
        if (channelBuilder == null) {
            throw new IllegalArgumentException("The URI format should be one of tcp://host:port, tls://host:port, or unix:///path/to/uds.sock");
        }
        return channelBuilder;
    }

    public static NettyChannelBuilder NettyChannelBuilder(URI uri) throws SSLException {
        return GRPCClient.getNettyChannelBuilder(uri, null, null, null, null, new String[0]);
    }

    public GRPCClient(URI uri) throws SSLException {
        this(uri, null, null, null, null, new String[0]);
    }

    public GRPCClient(URI uri, @Nullable KeyManagerFactory keyManagerFactory, @Nullable TrustManagerFactory trustManagerFactory, @Nullable String overrideAuthority, @Nullable Iterable<String> ciphers, String ... tlsVersionProtocols) throws SSLException {
        this(uri, GRPCClient.getNettyChannelBuilder(uri, keyManagerFactory, trustManagerFactory, overrideAuthority, ciphers, tlsVersionProtocols));
    }

    public GRPCClient(URI uri, NettyChannelBuilder channelBuilder) {
        this.uri = uri;
        this.channelBuilder = channelBuilder;
    }

    public T connect() {
        this.disconnect();
        this.channel = this.channelBuilder.build();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                this.channel.shutdownNow();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }, "GRPCClient.shutdown and disconnect from " + this.uri));
        this.onConnected(this.channel);
        return (T)this;
    }

    protected abstract void onConnected(ManagedChannel var1);

    public void disconnect() {
        if (this.channel != null) {
            try {
                this.channel.shutdownNow();
            }
            catch (Throwable throwable) {
            }
            finally {
                this.channel = null;
            }
        }
    }
}

