/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.nio.server;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import jakarta.persistence.PersistenceException;
import java.io.IOException;
import java.net.http.HttpConnectTimeoutException;
import java.net.http.HttpTimeoutException;
import java.nio.channels.UnresolvedAddressException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.RejectedExecutionException;
import javax.naming.NamingException;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.logging.log4j.Level;
import org.summerboot.jexpress.boot.instrumentation.HealthInspector;
import org.summerboot.jexpress.boot.instrumentation.HealthMonitor;
import org.summerboot.jexpress.integration.smtp.PostOffice;
import org.summerboot.jexpress.integration.smtp.SMTPClientConfig;
import org.summerboot.jexpress.nio.server.NioServerHttpRequestHandler;
import org.summerboot.jexpress.nio.server.RequestProcessor;
import org.summerboot.jexpress.nio.server.domain.Err;
import org.summerboot.jexpress.nio.server.domain.ServiceContext;
import org.summerboot.jexpress.util.FormatterUtil;

@Singleton
public abstract class BootHttpRequestHandler
extends NioServerHttpRequestHandler {
    public static final String BINDING_NAME = "BootHttpRequestHandler";
    @Inject
    protected PostOffice po;
    @Inject
    protected HealthInspector healthInspector;
    protected static SMTPClientConfig cmtpCfg = SMTPClientConfig.cfg;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void service(ChannelHandlerContext ctx, HttpHeaders httpRequestHeaders, HttpMethod httptMethod, String httpRequestPath, Map<String, List<String>> queryParams, String httpPostRequestBody, ServiceContext context) {
        RequestProcessor processor = null;
        try {
            processor = this.getRequestProcessor(httptMethod, httpRequestPath);
            if (processor == null && (processor = this.getRequestProcessor(httptMethod, "")) == null) {
                this.onActionNotFound(ctx, httpRequestHeaders, httptMethod, httpRequestPath, queryParams, httpPostRequestBody, context);
                return;
            }
            if (processor.isRoleBased()) {
                context.timestampPOI("auth.begin");
                if (!this.authenticationCheck(processor, httpRequestHeaders, httpRequestPath, context)) {
                    context.status(HttpResponseStatus.UNAUTHORIZED);
                    return;
                }
                if (!processor.authorizationCheck(ctx, httpRequestHeaders, httpRequestPath, queryParams, httpPostRequestBody, context, 46)) {
                    context.status(HttpResponseStatus.FORBIDDEN);
                    return;
                }
            }
            context.timestampPOI("process.begin");
            if (!this.preProcess(processor, httpRequestHeaders, httpRequestPath, context)) {
                return;
            }
            processor.process(ctx, httpRequestHeaders, httpRequestPath, queryParams, httpPostRequestBody, context, 10);
        }
        catch (NamingException ex) {
            this.onNamingException(ex, httptMethod, httpRequestPath, context);
        }
        catch (PersistenceException ex) {
            this.onPersistenceException(ex, httptMethod, httpRequestPath, context);
        }
        catch (HttpConnectTimeoutException ex) {
            this.onHttpConnectTimeoutException(ex, httptMethod, httpRequestPath, context);
        }
        catch (HttpTimeoutException ex) {
            this.onHttpTimeoutException(ex, httptMethod, httpRequestPath, context);
        }
        catch (RejectedExecutionException ex) {
            this.onRejectedExecutionException(ex, httptMethod, httpRequestPath, context);
        }
        catch (IOException | UnresolvedAddressException ex) {
            Throwable rc = ExceptionUtils.getRootCause((Throwable)ex);
            if (rc == null) {
                rc = ex;
            }
            if (rc instanceof RejectedExecutionException) {
                this.onRejectedExecutionException(rc, httptMethod, httpRequestPath, context);
            } else {
                this.onIOException(rc, httptMethod, httpRequestPath, context);
            }
        }
        catch (InterruptedException ex) {
            this.onInterruptedException(ex, httptMethod, httpRequestPath, context);
        }
        catch (Throwable ex) {
            this.onUnexpectedException(ex, processor, ctx, httpRequestHeaders, httptMethod, httpRequestPath, queryParams, httpPostRequestBody, context);
        }
        finally {
            this.afterService(processor, ctx, httpRequestHeaders, httptMethod, httpRequestPath, queryParams, httpPostRequestBody, context);
            context.timestampPOI("process.end");
        }
    }

    protected abstract boolean authenticationCheck(RequestProcessor var1, HttpHeaders var2, String var3, ServiceContext var4) throws Exception;

    protected abstract boolean preProcess(RequestProcessor var1, HttpHeaders var2, String var3, ServiceContext var4) throws Exception;

    protected void onActionNotFound(ChannelHandlerContext ctx, HttpHeaders httpRequestHeaders, HttpMethod httptMethod, String httpRequestPath, Map<String, List<String>> queryParams, String httpPostRequestBody, ServiceContext context) {
        context.status(HttpResponseStatus.NOT_FOUND).error(new Err(44, "path not found", httptMethod + " " + httpRequestPath, null));
    }

    protected void onNamingException(NamingException ex, HttpMethod httptMethod, String httpRequestPath, ServiceContext context) {
        this.nakFatal(context, HttpResponseStatus.INTERNAL_SERVER_ERROR, 52, "Cannot access LDAP", ex, cmtpCfg.getEmailToAppSupport(), httptMethod + " " + httpRequestPath);
    }

    protected void onPersistenceException(PersistenceException ex, HttpMethod httptMethod, String httpRequestPath, ServiceContext context) {
        this.nakFatal(context, HttpResponseStatus.INTERNAL_SERVER_ERROR, 54, "Cannot access database", ex, cmtpCfg.getEmailToAppSupport(), httptMethod + " " + httpRequestPath);
    }

    protected void onHttpConnectTimeoutException(HttpConnectTimeoutException ex, HttpMethod httptMethod, String httpRequestPath, ServiceContext context) {
        this.nak(context, HttpResponseStatus.GATEWAY_TIMEOUT, 24, ex.getMessage());
        context.level(Level.WARN);
    }

    protected void onHttpTimeoutException(HttpTimeoutException ex, HttpMethod httptMethod, String httpRequestPath, ServiceContext context) {
        this.nak(context, HttpResponseStatus.GATEWAY_TIMEOUT, 22, ex.getMessage());
        context.level(Level.WARN);
    }

    protected void onRejectedExecutionException(Throwable ex, HttpMethod httptMethod, String httpRequestPath, ServiceContext context) {
        this.nak(context, HttpResponseStatus.SERVICE_UNAVAILABLE, 23, ex.getMessage());
        context.level(Level.WARN);
    }

    protected void onIOException(Throwable ex, HttpMethod httptMethod, String httpRequestPath, ServiceContext context) {
        HealthMonitor.setHealthStatus(false, ex.toString(), this.getHealthInspector());
        this.nakFatal(context, HttpResponseStatus.SERVICE_UNAVAILABLE, 20, "IO Failure", ex, cmtpCfg.getEmailToAppSupport(), httptMethod + " " + httpRequestPath);
    }

    protected HealthInspector getHealthInspector() {
        return this.healthInspector;
    }

    protected void onInterruptedException(InterruptedException ex, HttpMethod httptMethod, String httpRequestPath, ServiceContext context) {
        Thread.currentThread().interrupt();
        this.nakFatal(context, HttpResponseStatus.INTERNAL_SERVER_ERROR, 21, "Service Interrupted", ex, cmtpCfg.getEmailToDevelopment(), httptMethod + " " + httpRequestPath);
    }

    protected void onUnexpectedException(Throwable ex, RequestProcessor processor, ChannelHandlerContext ctx, HttpHeaders httpRequestHeaders, HttpMethod httptMethod, String httpRequestPath, Map<String, List<String>> queryParams, String httpPostRequestBody, ServiceContext context) {
        this.nakFatal(context, HttpResponseStatus.INTERNAL_SERVER_ERROR, 9, "Unexpected Failure/Bug?", ex, cmtpCfg.getEmailToDevelopment(), httptMethod + " " + httpRequestPath);
    }

    protected void afterService(RequestProcessor processor, ChannelHandlerContext ctx, HttpHeaders httpRequestHeaders, HttpMethod httptMethod, String httpRequestPath, Map<String, List<String>> queryParams, String httpPostRequestBody, ServiceContext context) {
        this.protectAuthToken(processor, httpRequestHeaders);
    }

    protected void protectAuthToken(RequestProcessor processor, HttpHeaders httpRequestHeaders) {
        if (processor != null && processor.isRoleBased()) {
            httpRequestHeaders.set((CharSequence)HttpHeaderNames.AUTHORIZATION, (Object)"***");
        }
    }

    @Override
    protected String beforeLogging(String log) {
        return log;
    }

    @Override
    protected void afterLogging(HttpHeaders httpHeaders, HttpMethod httpMethod, String httpRequestUri, String httpPostRequestBody, ServiceContext context, long queuingTime, long processTime, long responseTime, long responseContentLength, String logContent, Throwable ioEx) throws Exception {
    }

    protected void nak(ServiceContext context, HttpResponseStatus httpResponseStatus, int appErrorCode, String errorMessage) {
        Err e = new Err(appErrorCode, null, errorMessage, null);
        context.status(httpResponseStatus).error(e);
    }

    protected void nakError(ServiceContext context, HttpResponseStatus httpResponseStatus, int appErrorCode, String errorMessage, Throwable ex) {
        Err e = new Err(appErrorCode, null, errorMessage, ex);
        context.status(httpResponseStatus).error(e);
    }

    protected void nakFatal(ServiceContext context, HttpResponseStatus httpResponseStatus, int appErrorCode, String errorMessage, Throwable ex, Collection<String> emailTo, String content) {
        this.nakError(context, httpResponseStatus, appErrorCode, errorMessage, ex);
        context.level(Level.FATAL);
        if (this.po != null) {
            String briefContent = "caller=" + context.callerId() + ", request#" + context.hit() + ": " + content;
            this.po.sendAlertAsync(emailTo, errorMessage, briefContent, ex, true);
        }
    }

    @Override
    public String beforeSendingError(String errorContent) {
        return FormatterUtil.protectContent(errorContent, "java.net.UnknownHostException", ":", null, " ***");
    }
}

