/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.Validation;
import jakarta.validation.ValidatorFactory;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class BeanUtil {
    private static boolean isToJsonIgnoreNull = true;
    private static boolean isToJsonPretty = false;
    protected static final ObjectMapper JacksonMapper = new ObjectMapper();
    protected static final ObjectMapper JacksonMapperIgnoreNull = new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_NULL).setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
    protected static final XmlMapper xmlMapper = new XmlMapper();
    public static final ValidatorFactory ValidatorFactory;

    public static void registerModules(Module ... modules) {
        xmlMapper.registerModules(modules);
        JacksonMapper.registerModules(modules);
        JacksonMapperIgnoreNull.registerModules(modules);
    }

    public static void configure(SerializationFeature f, boolean state) {
        xmlMapper.configure(f, state);
        JacksonMapper.configure(f, state);
        JacksonMapperIgnoreNull.configure(f, state);
    }

    public static void configure(DeserializationFeature f, boolean state) {
        xmlMapper.configure(f, state);
        JacksonMapper.configure(f, state);
        JacksonMapperIgnoreNull.configure(f, state);
    }

    public static void configure(JsonGenerator.Feature f, boolean state) {
        xmlMapper.configure(f, state);
        JacksonMapper.configure(f, state);
        JacksonMapperIgnoreNull.configure(f, state);
    }

    public static void configure(JsonParser.Feature f, boolean state) {
        xmlMapper.configure(f, state);
        JacksonMapper.configure(f, state);
        JacksonMapperIgnoreNull.configure(f, state);
    }

    public static void configure(boolean fromJsonFailOnUnknownProperties, boolean toJsonPretty, boolean toJsonIgnoreNull) {
        BeanUtil.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, fromJsonFailOnUnknownProperties);
        isToJsonPretty = toJsonPretty;
        isToJsonIgnoreNull = toJsonIgnoreNull;
    }

    public static <T> String toJson(T obj) throws JsonProcessingException {
        return BeanUtil.toJson(obj, isToJsonPretty, isToJsonIgnoreNull);
    }

    public static <T> String toJson(T obj, boolean pretty, boolean ignoreNull) throws JsonProcessingException {
        if (obj == null) {
            return "";
        }
        if (pretty) {
            if (ignoreNull) {
                return JacksonMapperIgnoreNull.writerWithDefaultPrettyPrinter().writeValueAsString(obj);
            }
            return JacksonMapper.writerWithDefaultPrettyPrinter().writeValueAsString(obj);
        }
        if (ignoreNull) {
            return JacksonMapperIgnoreNull.writeValueAsString(obj);
        }
        return JacksonMapper.writeValueAsString(obj);
    }

    public static <T> T fromJson(Class<T> c, String json) throws JsonProcessingException {
        if (StringUtils.isBlank((CharSequence)json)) {
            return null;
        }
        return (T)JacksonMapper.readValue(json, c);
    }

    public static <T> T fromJson(JavaType javaType, String json) throws JsonProcessingException {
        if (StringUtils.isBlank((CharSequence)json)) {
            return null;
        }
        return (T)JacksonMapper.readValue(json, javaType);
    }

    public static <T> T fromJson(TypeReference<T> javaType, String json) throws JsonProcessingException {
        if (StringUtils.isBlank((CharSequence)json)) {
            return null;
        }
        return (T)JacksonMapper.readValue(json, javaType);
    }

    public static <R> R fromJson(Class<R> collectionClass, Class<?> genericClass, String json) throws JsonProcessingException {
        if (StringUtils.isBlank((CharSequence)json)) {
            return null;
        }
        if (genericClass == null) {
            return BeanUtil.fromJson(collectionClass, json);
        }
        JavaType javaType = JacksonMapper.getTypeFactory().constructParametricType(collectionClass, new Class[]{genericClass});
        return (R)JacksonMapper.readValue(json, javaType);
    }

    public static <T> T fromXML(Class<T> targetClass, String xml) throws JsonProcessingException {
        return (T)xmlMapper.readValue(xml, targetClass);
    }

    public static String toXML(Object obj) throws JsonProcessingException {
        return xmlMapper.writeValueAsString(obj);
    }

    public static String getBeanValidationResult(Object bean) {
        if (bean == null) {
            return "missing data";
        }
        Set violations = ValidatorFactory.getValidator().validate(bean, new Class[0]);
        if (violations.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(bean.getClass().getSimpleName()).append(" Validation Failed: ");
        for (ConstraintViolation constViolation : violations) {
            sb.append(constViolation.getPropertyPath()).append("=").append(constViolation.getInvalidValue()).append(" - ").append(constViolation.getMessage()).append("; ");
        }
        return sb.toString();
    }

    static {
        BeanUtil.registerModules(new Module[]{new JavaTimeModule()});
        BeanUtil.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        BeanUtil.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        BeanUtil.configure(DeserializationFeature.FAIL_ON_IGNORED_PROPERTIES, false);
        BeanUtil.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, true);
        ValidatorFactory = Validation.buildDefaultValidatorFactory();
    }
}

