/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.util;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.util.Calendar;
import java.util.Random;
import org.apache.commons.lang3.StringUtils;

public class TimeUtil {
    public static DateTimeFormatter ISO_ZONED_DATE_TIME3 = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd'T'HH:mm:ss.SSS").parseLenient().appendOffset("+HH:MM", "Z").toFormatter();
    public static DateTimeFormatter UTC_DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    public static ZoneId ZONE_ID_ONTARIO = ZoneId.of("America/Toronto");
    protected static Random RANDOM = new Random();

    public static long getSecondsSinceMidnight(Calendar c) {
        return 3600 * c.get(11) + 60 * c.get(12) + c.get(13);
    }

    public static long getSecondsTillMidnight(Calendar c) {
        return 86400L - TimeUtil.getSecondsSinceMidnight(c);
    }

    public static int[] seconds2DHMS(long totalSeconds) {
        int[] ymdhms = new int[]{0, 0, 0, 0};
        long day = totalSeconds / 86400L;
        long hour = totalSeconds / 3600L % 24L;
        long minute = totalSeconds % 3600L / 60L;
        long second = totalSeconds % 60L;
        ymdhms[3] = (int)day;
        ymdhms[2] = (int)hour;
        ymdhms[1] = (int)minute;
        ymdhms[0] = (int)second;
        return ymdhms;
    }

    public static String seconds2DHMSString(long totalSeconds) {
        int[] ymdhms = TimeUtil.seconds2DHMS(totalSeconds);
        int day = ymdhms[3];
        int hour = ymdhms[2];
        int min = ymdhms[1];
        int sec = ymdhms[0];
        return day + " day" + (day > 1 ? "s " : " ") + hour + " hour" + (hour > 1 ? "s " : " ") + min + " min" + (min > 1 ? "s " : " ") + sec + " sec" + (sec > 1 ? "s " : " ");
    }

    public static String utcDateTimeToLocalDateTime(String utcTime, ZoneId zoneId) {
        if (StringUtils.isBlank((CharSequence)utcTime)) {
            return null;
        }
        return ZonedDateTime.parse(utcTime, UTC_DATE_TIME_FORMATTER).withZoneSameInstant(zoneId).format(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
    }

    public static LocalDateTime toLocalDateTime(long epochTs) {
        return TimeUtil.toLocalDateTime(epochTs, ZoneId.systemDefault());
    }

    public static LocalDateTime toLocalDateTime(long epochTs, ZoneId zoneId) {
        if (zoneId == null) {
            zoneId = ZoneId.systemDefault();
        }
        return Instant.ofEpochMilli(epochTs).atZone(zoneId).toLocalDateTime();
    }

    public static OffsetDateTime toOffsetDateTime(long epochTs, ZoneId zoneId) {
        if (zoneId == null) {
            zoneId = ZoneId.systemDefault();
        }
        return Instant.ofEpochMilli(epochTs).atZone(zoneId).toOffsetDateTime();
    }

    public static OffsetDateTime toOffsetDateTime(LocalDate localDate, ZoneId zoneId) {
        ZonedDateTime zdt = TimeUtil.toZonedDateTime(localDate, zoneId);
        return zdt.withZoneSameInstant(zoneId).toOffsetDateTime();
    }

    public static ZonedDateTime toZonedDateTime(LocalDate localDate, ZoneId zoneId) {
        LocalDateTime localDateTime = localDate.atStartOfDay();
        return ZonedDateTime.of(localDateTime, ZoneId.systemDefault());
    }

    public static int random(int low, int high) {
        int result = RANDOM.nextInt(high - low) + low;
        return result;
    }

    public static double truncatedExponentialBackoffSlots(int retry, int truncatedMaxRetry) {
        if (retry < 1) {
            return 0.0;
        }
        int n = Math.min(retry, truncatedMaxRetry);
        int max = (1 << n) - 1;
        double min = max / 2;
        return Math.random() * ((double)max - min) + min;
    }

    public static class TimeDto {
        @JsonIgnoreProperties
        private ZoneId zoneId;
        @JsonIgnoreProperties
        private long epochTs;
        @JsonIgnoreProperties
        private Timestamp timestamp;
        @JsonIgnoreProperties
        private LocalDateTime localDateTime;
        @JsonIgnoreProperties
        private OffsetDateTime offsetDateTime;
        @JsonIgnoreProperties
        private ZonedDateTime zonedDateTime;

        public TimeDto() {
        }

        public TimeDto(long epochTs, String zoneIdName) {
            this(epochTs, ZoneId.of(zoneIdName));
        }

        public TimeDto(long epochTs, ZoneId zoneId) {
            this.zoneId = zoneId;
            this.epochTs = epochTs;
            this.timestamp = new Timestamp(epochTs);
            this.localDateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(epochTs), zoneId);
            this.offsetDateTime = Instant.ofEpochMilli(epochTs).atZone(zoneId).toOffsetDateTime();
            this.zonedDateTime = Instant.ofEpochMilli(epochTs).atZone(zoneId);
        }

        public void sync() {
            this.timestamp = new Timestamp(this.epochTs);
            this.localDateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(this.epochTs), this.zoneId);
            this.offsetDateTime = Instant.ofEpochMilli(this.epochTs).atZone(this.zoneId).toOffsetDateTime();
            this.zonedDateTime = Instant.ofEpochMilli(this.epochTs).atZone(this.zoneId);
        }

        public ZoneId getZoneId() {
            return this.zoneId;
        }

        public void setZoneId(ZoneId zoneId) {
            this.zoneId = zoneId;
        }

        public long getEpochTs() {
            return this.epochTs;
        }

        public void setEpochTs(long epochTs) {
            this.epochTs = epochTs;
        }

        public Timestamp getTimestamp() {
            return this.timestamp;
        }

        public void setTimestamp(Timestamp timestamp) {
            this.timestamp = timestamp;
        }

        public LocalDateTime getLocalDateTime() {
            return this.localDateTime;
        }

        public void setLocalDateTime(LocalDateTime localDateTime) {
            this.localDateTime = localDateTime;
        }

        public OffsetDateTime getOffsetDateTime() {
            return this.offsetDateTime;
        }

        public void setOffsetDateTime(OffsetDateTime offsetDateTime) {
            this.offsetDateTime = offsetDateTime;
        }

        public ZonedDateTime getZonedDateTime() {
            return this.zonedDateTime;
        }

        public void setZonedDateTime(ZonedDateTime zonedDateTime) {
            this.zonedDateTime = zonedDateTime;
        }
    }
}

