/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.integration.ldap;

import java.io.Closeable;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.Control;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LdapAgent
implements Closeable {
    private static final Logger log = LogManager.getLogger(LdapAgent.class);
    private static final String DN = "dn";
    protected final Properties cfg;
    protected final String baseDN;
    protected final boolean isAD;
    protected final String tenantGroupName;
    protected LdapContext m_ctx = null;
    private static final int SALT_LENGTH = 4;

    public static Properties buildCfg(String host, int port, boolean isSSL, String ldapSSLConnectionFactoryClassName, String sslProtocol, String bindingUserDN, String bindingPassword) {
        Properties tempCfg = new Properties();
        tempCfg.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        String providerUrl = isSSL ? "ldaps://" + host + ":" + port : "ldap://" + host + ":" + port;
        tempCfg.put("java.naming.provider.url", providerUrl);
        if (StringUtils.isNotBlank((CharSequence)bindingUserDN)) {
            tempCfg.put("java.naming.security.principal", bindingUserDN);
        }
        if (StringUtils.isNotBlank((CharSequence)bindingPassword)) {
            tempCfg.put("java.naming.security.authentication", "simple");
            tempCfg.put("java.naming.security.credentials", bindingPassword);
        }
        if (isSSL) {
            tempCfg.put("java.naming.security.protocol", sslProtocol);
            if (ldapSSLConnectionFactoryClassName != null) {
                tempCfg.put("java.naming.ldap.factory.socket", ldapSSLConnectionFactoryClassName);
            }
        }
        return tempCfg;
    }

    public LdapAgent(Properties cfg, String baseDN, boolean isAD, String tenantGroupName) throws NamingException, IOException {
        this.cfg = cfg;
        this.baseDN = baseDN;
        this.isAD = isAD;
        this.tenantGroupName = tenantGroupName;
        this.connect();
    }

    public String getBaseDN() {
        return this.baseDN;
    }

    public String getTenantGroupName() {
        return this.tenantGroupName;
    }

    @Override
    public void close() throws IOException {
        if (this.m_ctx != null) {
            log.debug("processing...");
            try {
                this.m_ctx.close();
            }
            catch (NamingException ex) {
                log.error("failed to close LDAP ctx", (Throwable)ex);
            }
            finally {
                this.m_ctx = null;
            }
            log.debug("success");
        }
    }

    private void connect() throws NamingException, IOException {
        this.close();
        log.debug(this.baseDN + ", isAD=" + this.isAD);
        this.m_ctx = new InitialLdapContext(this.cfg, null);
        log.debug("success");
    }

    public String getDN(String username) throws NamingException {
        String[] dn = this.queryPersonDN(this.isAD ? "sAMAccountName" : "uid", username);
        if (dn == null || dn.length < 1) {
            return null;
        }
        return dn[0];
    }

    public String[] queryPersonDN(String key, String username) throws NamingException {
        List<Attributes> attrs = this.queryPerson(key, username);
        int size = attrs.size();
        String[] ret = new String[size];
        for (int i = 0; i < size; ++i) {
            ret[i] = this.getAttr(attrs.get(i), DN);
        }
        return ret;
    }

    public List<Attributes> queryPerson(String key, String value) throws NamingException {
        String objectClass = this.isAD ? "organizationalPerson" : "inetOrgPerson";
        String sFilter = "(&(objectClass=" + objectClass + ")&(" + key + "=" + value + "))";
        return this.query(sFilter);
    }

    public List<Attributes> getUserRoleGroups(String userDN) throws NamingException {
        String sFilter = this.isAD ? "(&(objectClass=group)(member=" + userDN + "))" : "(&(objectClass=groupOfUniqueNames)(uniqueMember=" + userDN + "))";
        List<Attributes> roles = this.query(sFilter);
        return roles;
    }

    public List<Attributes> query(String sFilter) throws NamingException {
        log.debug(() -> "base=" + this.baseDN + ", filter=" + sFilter);
        ArrayList<Attributes> ret = new ArrayList<Attributes>();
        SearchControls ctlsUser = new SearchControls();
        ctlsUser.setSearchScope(2);
        NamingEnumeration<SearchResult> results = this.m_ctx.search(this.baseDN, sFilter, ctlsUser);
        while (results.hasMore()) {
            SearchResult sr = results.next();
            String dn = sr.getNameInNamespace();
            Attributes attr = this.m_ctx.getAttributes(dn);
            ret.add(attr);
            attr.put(DN, dn);
        }
        return ret;
    }

    public String getAttr(Attributes attrs, String id) throws NamingException {
        Attribute attr;
        String ret = null;
        if (attrs != null && id != null && (attr = attrs.get(id)) != null) {
            ret = attr.getAll().next().toString();
        }
        return ret;
    }

    private List<String>[] parseAddedAndRemoved(List<Attributes> currentGroup, String[] newGroup) throws NamingException {
        ArrayList addedList = newGroup == null ? new ArrayList() : new ArrayList<String>(Arrays.asList(newGroup));
        ArrayList<String> removedList = new ArrayList<String>();
        List[] ret = new List[]{addedList, removedList};
        for (Attributes attrs : currentGroup) {
            String currentGroupDN = this.getAttr(attrs, DN);
            boolean found = false;
            for (String newGroupDn : addedList) {
                if (!newGroupDn.equals(currentGroupDN)) continue;
                found = true;
                break;
            }
            if (found) {
                addedList.remove(currentGroupDN);
                continue;
            }
            removedList.add(currentGroupDN);
        }
        return ret;
    }

    public static String hashMD5Password(String password, String algorithm) throws GeneralSecurityException {
        MessageDigest digest = MessageDigest.getInstance(algorithm);
        digest.update(password.getBytes(StandardCharsets.UTF_8));
        byte[] md5 = digest.digest();
        String md5Password = Base64.getEncoder().encodeToString(md5);
        return md5Password;
    }

    public static String generateSSHA(String password) throws NoSuchAlgorithmException {
        return LdapAgent.generateSSHA(password, "SHA3-256");
    }

    public static String generateSSHA(String _password, String algorithm) throws NoSuchAlgorithmException {
        byte[] password = _password.getBytes(StandardCharsets.UTF_8);
        SecureRandom secureRandom = new SecureRandom();
        byte[] salt = new byte[4];
        secureRandom.nextBytes(salt);
        MessageDigest crypt = MessageDigest.getInstance(algorithm);
        crypt.reset();
        crypt.update(password);
        crypt.update(salt);
        byte[] hash = crypt.digest();
        byte[] hashPlusSalt = new byte[hash.length + salt.length];
        System.arraycopy(hash, 0, hashPlusSalt, 0, hash.length);
        System.arraycopy(salt, 0, hashPlusSalt, hash.length, salt.length);
        return Base64.getEncoder().encodeToString(hashPlusSalt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void authenticate(String dn, String currentPassword) throws NamingException {
        try {
            this.m_ctx.addToEnvironment("java.naming.security.principal", dn);
            this.m_ctx.addToEnvironment("java.naming.security.credentials", currentPassword);
            this.m_ctx.reconnect(null);
            Control[] controls = this.m_ctx.getResponseControls();
            if (controls != null) {
                for (Control control : controls) {
                    log.debug("  Control: " + control.getID() + " | crit: " + control.isCritical() + " | val: '" + new String(control.getEncodedValue()) + "'");
                }
            }
        }
        finally {
            this.m_ctx.removeFromEnvironment("java.naming.security.principal");
            this.m_ctx.removeFromEnvironment("java.naming.security.credentials");
        }
    }

    public void changePassword(String uid, String currentPassword, String newPassword) throws NamingException, GeneralSecurityException {
        String dn = this.getDN(uid);
        if (currentPassword != null) {
            this.authenticate(dn, currentPassword);
        }
        Object pwd = this.cfg.get("java.naming.security.credentials");
        String rootCredential = String.valueOf(pwd);
        this.authenticate("cn=root," + this.baseDN, rootCredential);
        BasicAttribute ba = new BasicAttribute("userPassword", LdapAgent.generateSSHA(newPassword));
        ModificationItem[] mods = new ModificationItem[]{new ModificationItem(2, ba)};
        this.m_ctx.modifyAttributes(dn, mods);
    }

    public static String n2q(String s) {
        return StringUtils.isBlank((CharSequence)s) ? "?" : s;
    }

    public String createUser(String uid, String pwd, String company, String org, Map<String, String> profile) throws NamingException, GeneralSecurityException {
        String userDN = this.getDN(uid);
        if (userDN != null) {
            throw new NamingException(uid + " exists");
        }
        userDN = "uid=" + uid + ",ou=" + org + ",o=" + company + ",ou=" + this.tenantGroupName + "," + this.baseDN;
        BasicAttributes entry = new BasicAttributes();
        BasicAttribute oc = new BasicAttribute("objectClass");
        entry.put(oc);
        oc.add("top");
        oc.add("person");
        oc.add("inetOrgPerson");
        oc.add("organizationalPerson");
        entry.put(new BasicAttribute("uid", uid));
        entry.put(new BasicAttribute("userPassword", LdapAgent.generateSSHA(pwd)));
        if (profile != null) {
            profile.forEach((key, value) -> entry.put(new BasicAttribute((String)key, LdapAgent.n2q(value))));
        }
        try {
            this.m_ctx.createSubcontext(userDN, (Attributes)entry);
        }
        catch (NameAlreadyBoundException nameAlreadyBoundException) {
            // empty catch block
        }
        return userDN;
    }

    public String createEntry(String dn, Set<String> objectClasses, Map<String, String> attributes) throws NamingException {
        BasicAttributes entry = new BasicAttributes();
        BasicAttribute oc = new BasicAttribute("objectClass");
        entry.put(oc);
        objectClasses.forEach(objectClass -> oc.add(objectClass));
        attributes.forEach((key, value) -> entry.put(new BasicAttribute((String)key, LdapAgent.n2q(value))));
        try {
            this.m_ctx.createSubcontext(dn, (Attributes)entry);
        }
        catch (NameAlreadyBoundException nameAlreadyBoundException) {
            // empty catch block
        }
        return dn;
    }

    public void updateEntryAttrs(String userDN, Map<String, String> attributes) throws GeneralSecurityException, NamingException {
        if (log.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append("\n\tuserDN=").append(userDN);
            attributes.forEach((key, value) -> sb.append("\n\t ").append((String)key).append("=").append((String)value));
            log.debug((CharSequence)sb);
        }
        ArrayList modList = new ArrayList();
        attributes.forEach((key, value) -> modList.add(new ModificationItem(2, new BasicAttribute((String)key, value))));
        int size = modList.size();
        if (size > 0) {
            ModificationItem[] mods = new ModificationItem[size];
            this.m_ctx.modifyAttributes(userDN, modList.toArray(mods));
        }
    }

    public void deleteUser(String uid) throws NamingException, GeneralSecurityException {
        log.debug(uid);
        List<Attributes> attrs = this.queryPerson("uid", uid);
        for (Attributes arrt : attrs) {
            String userDN = this.getAttr(arrt, DN);
            this.updateUserGroups(userDN, new String[0]);
            this.m_ctx.unbind(userDN);
        }
    }

    public void deleteEntry(String dn) throws NamingException, GeneralSecurityException {
        log.debug(dn);
        if (dn != null) {
            this.updateUserGroups(dn, new String[0]);
            this.m_ctx.unbind(dn);
        }
    }

    public void updateUserGroups(String userDN, String ... newGroupDnList) throws GeneralSecurityException, NamingException {
        ModificationItem[] mods;
        List<String>[] ret = this.parseAddedAndRemoved(this.getUserRoleGroups(userDN), newGroupDnList);
        List<String> addedList = ret[0];
        List<String> removedList = ret[1];
        for (String toBeRemovedGroupDn : removedList) {
            log.debug(userDN + ".remove=" + toBeRemovedGroupDn);
            mods = new ModificationItem[]{new ModificationItem(3, new BasicAttribute("uniqueMember", userDN))};
            try {
                this.m_ctx.modifyAttributes(toBeRemovedGroupDn, mods);
            }
            catch (Throwable ex) {
                throw new GeneralSecurityException(ex.getMessage() + "\n\tremove: " + userDN + "\n\tfrom: " + toBeRemovedGroupDn, ex);
            }
        }
        for (String groupDN : addedList) {
            log.debug(userDN + ".add=" + groupDN);
            mods = new ModificationItem[]{new ModificationItem(1, new BasicAttribute("uniqueMember", userDN))};
            try {
                this.m_ctx.modifyAttributes(groupDN, mods);
            }
            catch (Throwable ex) {
                throw new GeneralSecurityException(ex.getMessage() + "\n\tadd: " + userDN + "\n\tto: " + groupDN, ex);
            }
        }
    }

    public List<Attributes> queryOrganization(String o) throws NamingException {
        String sFilter = StringUtils.isBlank((CharSequence)o) ? "(&(objectClass=organization)&(ou:dn:=" + this.tenantGroupName + "))" : "(&(objectClass=organization)&(ou:dn:=" + this.tenantGroupName + ")&(o:dn:=" + o + "))";
        return this.query(sFilter);
    }

    public List<Attributes> queryOrganizationUnit(String o, String ou) throws NamingException {
        String sFilter = StringUtils.isBlank((CharSequence)ou) ? "(&(objectClass=organizationalUnit)&(ou:dn:=" + this.tenantGroupName + ")&(o:dn:=" + o + "))" : "(&(objectClass=organizationalUnit)&(ou:dn:=" + this.tenantGroupName + ")&(o:dn:=" + o + ")&(ou:dn:=" + ou + "))";
        return this.query(sFilter);
    }

    public List<Attributes> queryOrganizationUnitUsers(String o, String ou) throws NamingException {
        String sFilter = StringUtils.isBlank((CharSequence)ou) ? "(&(objectClass=inetOrgPerson)&(ou:dn:=" + this.tenantGroupName + ")&(o:dn:=" + o + "))" : "(&(objectClass=inetOrgPerson)&(ou:dn:=" + this.tenantGroupName + ")&(o:dn:=" + o + ")&(ou:dn:=" + ou + "))";
        return this.query(sFilter);
    }

    public List<String> queryGroupUsers(String cn) throws NamingException {
        ArrayList<String> uids = new ArrayList<String>();
        String sFilter = "(&(objectClass=groupOfUniqueNames)&(ou:dn:=groups)(cn=" + cn + "))";
        List<Attributes> groupAttrs = this.query(sFilter);
        for (Attributes groupAttr : groupAttrs) {
            Attribute a = groupAttr.get("uniqueMember");
            for (int i = 0; i < a.size(); ++i) {
                uids.add((String)a.get(i));
            }
        }
        return uids;
    }
}

