/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.util;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.summerboot.jexpress.util.ReflectionUtil;

public class ApplicationUtil {
    public static Map<Object, Set<String>> checkDuplicateFields(Class errorCodeClass, Class fieldClass) throws IllegalArgumentException, IllegalAccessException {
        HashMap<Object, Set<String>> duplicates = new HashMap<Object, Set<String>>();
        HashMap errorCodes = new HashMap();
        ReflectionUtil.loadFields(errorCodeClass, fieldClass, errorCodes, true);
        HashMap temp = new HashMap();
        errorCodes.keySet().forEach(varName -> {
            Object errorCode = errorCodes.get(varName);
            String duplicated = temp.put(errorCode, varName);
            if (duplicated != null) {
                HashSet<String> names = (HashSet<String>)duplicates.get(errorCode);
                if (names == null) {
                    names = new HashSet<String>();
                    duplicates.put(errorCode, names);
                }
                names.add((String)varName);
                names.add(duplicated);
            }
        });
        return duplicates;
    }

    public static String getServerName(boolean exitWhenFail) {
        block2: {
            try {
                System.setProperty("hostName", InetAddress.getLocalHost().getHostName());
            }
            catch (UnknownHostException ex) {
                System.setProperty("hostName", null);
                ex.printStackTrace(System.err);
                if (!exitWhenFail) break block2;
                System.exit(-1);
            }
        }
        return System.getProperty("hostName");
    }

    public static Set<String> getClassNamesFromJarFile(File jarFile) throws IOException {
        HashSet<String> classNames = new HashSet<String>();
        JarFile jar = new JarFile(jarFile);
        Enumeration<JarEntry> jarEntries = jar.entries();
        while (jarEntries.hasMoreElements()) {
            JarEntry jarEntry = jarEntries.nextElement();
            String entryName = jarEntry.getName();
            if (!entryName.endsWith(".class")) continue;
            String className = entryName.replace(".class", "").replaceAll("/", ".");
            classNames.add(className);
        }
        return classNames;
    }

    public static Set<Class<?>> loadClassFromJarFile(File jarFile, boolean failOnUndefinedClasses) throws IOException {
        URL url = jarFile.getAbsoluteFile().toURI().toURL();
        URL[] urls = new URL[]{url};
        URLClassLoader urlClassLoader = new URLClassLoader(urls, Thread.currentThread().getContextClassLoader());
        HashSet classes = new HashSet();
        StringBuilder sb = new StringBuilder();
        boolean onError = false;
        Set<String> classNames = ApplicationUtil.getClassNamesFromJarFile(jarFile);
        for (String className : classNames) {
            try {
                Class<?> loadedClass = urlClassLoader.loadClass(className);
                classes.add(loadedClass);
            }
            catch (ClassNotFoundException | NoClassDefFoundError ex) {
                onError = true;
                sb.append("\n\t").append(ex.toString());
            }
        }
        if (onError && failOnUndefinedClasses) {
            throw new NoClassDefFoundError(sb.toString());
        }
        return classes;
    }
}

