/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.boot.instrumentation.jmx;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.lang.management.ManagementFactory;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.summerboot.jexpress.boot.instrumentation.NIOStatusListener;
import org.summerboot.jexpress.boot.instrumentation.jmx.InstrumentationMgr;
import org.summerboot.jexpress.boot.instrumentation.jmx.ServerStatusMBean;
import org.summerboot.jexpress.nio.server.NioServer;

@Singleton
public class InstrumentationMgrImpl
implements InstrumentationMgr {
    private MBeanServer mBeanServer;
    private ObjectName mbeanName;
    @Inject
    private ServerStatusMBean mbean;
    @Inject
    private NIOStatusListener nioListener;

    @Override
    public void start(String beanName) throws MalformedObjectNameException, InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        NioServer.setStatusListener(this.nioListener);
        this.mBeanServer = ManagementFactory.getPlatformMBeanServer();
        this.mbeanName = new ObjectName(beanName + ":name=Status");
        this.mBeanServer.registerMBean(this.mbean, this.mbeanName);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            System.out.println(Thread.currentThread().getName() + ": shutdown JMX");
            this.shutdown();
        }, "ShutdownHook.JMX"));
    }

    @Override
    public void shutdown() {
        try {
            this.mBeanServer.unregisterMBean(this.mbeanName);
        }
        catch (InstanceNotFoundException | MBeanRegistrationException jMException) {
            // empty catch block
        }
    }
}

