/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.integration.smtp;

import com.fasterxml.jackson.annotation.JsonIgnore;
import jakarta.mail.Authenticator;
import jakarta.mail.PasswordAuthentication;
import jakarta.mail.Session;
import java.io.File;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.summerboot.jexpress.boot.config.BootConfig;
import org.summerboot.jexpress.boot.config.ConfigUtil;
import org.summerboot.jexpress.boot.config.annotation.Config;
import org.summerboot.jexpress.boot.config.annotation.ConfigHeader;
import org.summerboot.jexpress.boot.config.annotation.ImportResource;

@ImportResource(value="cfg_smtp.properties")
public class SMTPClientConfig
extends BootConfig {
    public static final SMTPClientConfig cfg = new SMTPClientConfig();
    @JsonIgnore
    private volatile Session mailSession;
    @ConfigHeader(title="1. SMTP Settings")
    @JsonIgnore
    @Config(key="mail.smtp.host")
    protected volatile String smtpHost = "smtp.gmail.com";
    @JsonIgnore
    @Config(key="mail.smtp.port", desc="Port 25: The original standard SMTP port\nPort 587: The standard secure SMTP port")
    protected volatile int smtpPort = 587;
    @JsonIgnore
    @Config(key="mail.smtp.auth")
    protected volatile boolean smtpAuth = true;
    @JsonIgnore
    @Config(key="mail.smtp.starttls.enable")
    protected volatile boolean smtpStarttls = true;
    @JsonIgnore
    @Config(key="mail.smtp.userName", desc="Display name")
    protected volatile String smtpUserDisplayName = "John Doe";
    @JsonIgnore
    @Config(key="mail.smtp.user", desc="Email account")
    protected volatile String smtpUser = "johndoe@???.com";
    @JsonIgnore
    @Config(key="mail.smtp.pwd", validate=Config.Validate.Encrypted)
    protected volatile String smtpPassword;
    @ConfigHeader(title="2. Alert Recipients", format="CSV format", example="johndoe@test.com, janedoe@test.com")
    @Config(key="email.to.AppSupport", validate=Config.Validate.EmailRecipients, desc="The default alert email recipients")
    protected volatile Set<String> emailToAppSupport;
    @Config(key="email.to.Development", validate=Config.Validate.EmailRecipients, desc="use AppSupport if not provided")
    protected volatile Set<String> emailToDevelopment;
    @Config(key="email.to.ReportViewer", validate=Config.Validate.EmailRecipients, desc="use AppSupport if not provided")
    protected volatile Set<String> emailToReportViewer;
    @Config(key="debouncing.emailalert_minute", desc="Alert message with the same title will not be sent out within this minutes")
    protected volatile int emailAlertDebouncingInterval = 30;
    private Properties mailSessionProp;

    public static void main(String[] args) {
        String t = SMTPClientConfig.generateTemplate(SMTPClientConfig.class);
        System.out.println(t);
    }

    private SMTPClientConfig() {
    }

    @Override
    public void shutdown() {
    }

    @Override
    protected void loadCustomizedConfigs(File cfgFile, boolean isReal, ConfigUtil helper, Properties props) {
        String error2;
        if (this.emailToAppSupport == null) {
            this.emailToAppSupport = new HashSet<String>();
        }
        if (this.emailToDevelopment == null) {
            this.emailToDevelopment = new HashSet<String>(this.emailToAppSupport);
        }
        if (this.emailToDevelopment.isEmpty()) {
            this.emailToDevelopment.addAll(this.emailToAppSupport);
        }
        if (this.emailToReportViewer == null) {
            this.emailToReportViewer = new HashSet<String>(this.emailToAppSupport);
        }
        if (this.emailToReportViewer.isEmpty()) {
            this.emailToReportViewer.addAll(this.emailToAppSupport);
        }
        if ((error2 = helper.getError()) != null) {
            throw new IllegalArgumentException(error2);
        }
        this.mailSession = Session.getInstance((Properties)props, (Authenticator)new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(SMTPClientConfig.this.smtpUser, SMTPClientConfig.this.smtpPassword);
            }
        });
        this.mailSessionProp = this.mailSession.getProperties();
    }

    public Session getMailSession() {
        return this.mailSession;
    }

    public Set<String> getEmailToAppSupport() {
        return this.emailToAppSupport;
    }

    public Set<String> getEmailToDevelopment() {
        return this.emailToDevelopment;
    }

    public Set<String> getEmailToReportViewer() {
        return this.emailToReportViewer;
    }

    public int getEmailAlertDebouncingInterval() {
        return this.emailAlertDebouncingInterval;
    }
}

