/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.security.auth;

import com.google.inject.Singleton;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.JwtException;
import io.jsonwebtoken.Jwts;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.IOException;
import java.security.Key;
import java.util.Date;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.naming.NamingException;
import org.apache.commons.lang3.StringUtils;
import org.summerboot.jexpress.integration.cache.AuthTokenCache;
import org.summerboot.jexpress.nio.server.domain.Err;
import org.summerboot.jexpress.nio.server.domain.ServiceContext;
import org.summerboot.jexpress.security.JwtUtil;
import org.summerboot.jexpress.security.auth.AuthConfig;
import org.summerboot.jexpress.security.auth.Authenticator;
import org.summerboot.jexpress.security.auth.AuthenticatorListener;
import org.summerboot.jexpress.security.auth.Caller;
import org.summerboot.jexpress.security.auth.User;
import org.summerboot.jexpress.util.FormatterUtil;

@Singleton
public abstract class BootAuthenticator
implements Authenticator {
    protected AuthenticatorListener listener;
    protected AuthConfig authCfg = AuthConfig.cfg;

    @Override
    public void setListener(AuthenticatorListener listener) {
        this.listener = listener;
    }

    @Override
    public String authenticate(String uid, String pwd, int validForMinutes, ServiceContext context) throws IOException, NamingException {
        context.privacyReqContent(true);
        context.timestampPOI("ldap.begin");
        Caller caller = this.login(uid, pwd, this.listener);
        context.timestampPOI("ldap.end");
        if (caller == null) {
            context.status(HttpResponseStatus.UNAUTHORIZED);
            return null;
        }
        JwtBuilder builder = this.toJwt(caller);
        Key signingKey = this.authCfg.getJwtSigningKey();
        String token = JwtUtil.createJWT(signingKey, builder, TimeUnit.MINUTES, validForMinutes);
        if (this.listener != null) {
            this.listener.onLoginSuccess(caller.getUid(), token);
        }
        context.caller(caller).status(HttpResponseStatus.CREATED).privacyRespHeader(true);
        return token;
    }

    protected abstract Caller login(String var1, String var2, AuthenticatorListener var3) throws IOException, NamingException;

    @Override
    public JwtBuilder toJwt(Caller caller) {
        Set<String> keys;
        String groupsCsv;
        String jti = String.valueOf(caller.getId());
        String issuer = this.authCfg.getJwtIssuer();
        String subject = caller.getUid();
        Set<String> groups = caller.getGroups();
        String audience = groupsCsv = groups == null || groups.size() < 1 ? null : groups.stream().collect(Collectors.joining(","));
        Claims claims = Jwts.claims();
        claims.setId(jti).setIssuer(issuer).setSubject(subject).setAudience(audience);
        if (caller.getTenantId() != null) {
            claims.put((Object)"tenantId", (Object)caller.getTenantId());
        }
        if (caller.getTenantName() != null) {
            claims.put((Object)"tenantName", (Object)caller.getTenantName());
        }
        if ((keys = caller.propKeySet()) != null) {
            for (String key : keys) {
                Object v = caller.getProp(key, Object.class);
                claims.put((Object)key, v);
            }
        }
        JwtBuilder builder = Jwts.builder().setClaims(claims);
        return builder;
    }

    @Override
    public Caller fromJwt(Claims claims) {
        Set keys;
        Long id;
        String jti = claims.getId();
        String issuer = claims.getIssuer();
        String subject = claims.getSubject();
        String audience = claims.getAudience();
        Long tenantId = (Long)claims.get("tenantId", Long.class);
        String tenantName = (String)claims.get("tenantName", String.class);
        String uid = subject;
        try {
            id = Long.valueOf(jti);
        }
        catch (Throwable ex) {
            id = null;
        }
        User caller = new User(tenantId, tenantName, id, uid);
        String userGroups = audience;
        if (StringUtils.isNotBlank((CharSequence)userGroups)) {
            String[] groups = FormatterUtil.parseCsv(userGroups);
            for (String group : groups) {
                caller.addGroup(group);
            }
        }
        if ((keys = claims.keySet()) != null) {
            for (String key : keys) {
                Object v = claims.get((Object)key);
                caller.putProp(key, v);
            }
        }
        caller.remove("aud");
        caller.remove("exp");
        caller.remove("jti");
        caller.remove("iat");
        caller.remove("iss");
        caller.remove("nbf");
        caller.remove("sub");
        caller.remove("tenantId");
        caller.remove("tenantName");
        return caller;
    }

    @Override
    public String getBearerToken(HttpHeaders httpRequestHeaders) {
        String authToken = httpRequestHeaders.get((CharSequence)HttpHeaderNames.AUTHORIZATION);
        if (StringUtils.isBlank((CharSequence)authToken) || !authToken.startsWith("Bearer ")) {
            return null;
        }
        String[] a = authToken.split(" ");
        if (a.length < 2) {
            return null;
        }
        authToken = a[1];
        if (StringUtils.isBlank((CharSequence)authToken)) {
            return null;
        }
        return authToken;
    }

    public Caller verifyBearerToken(HttpHeaders httpRequestHeaders, AuthTokenCache cache, Integer errorCode, ServiceContext context) {
        String authToken = this.getBearerToken(httpRequestHeaders);
        return this.verifyToken(authToken, cache, errorCode, context);
    }

    public Caller verifyToken(String authToken, AuthTokenCache cache, Integer errorCode, ServiceContext context) {
        Caller caller = null;
        if (authToken == null) {
            Err e = new Err(errorCode != null ? errorCode : 41, "AUTH_REQUIRE_TOKEN", "Missing AuthToken", null);
            context.error(e).status(HttpResponseStatus.UNAUTHORIZED);
        } else {
            try {
                Claims claims = (Claims)JwtUtil.parseJWT(this.authCfg.getJwtParser(), authToken).getBody();
                String jti = claims.getId();
                context.callerId(jti);
                if (cache != null && cache.isOnBlacklist(jti)) {
                    Err e = new Err(errorCode != null ? errorCode : 43, "AUTH_EXPIRED_TOKEN", "Blacklisted AuthToken", null);
                    context.error(e).status(HttpResponseStatus.UNAUTHORIZED);
                } else {
                    caller = this.fromJwt(claims);
                    if (this.listener != null && !this.listener.verify(caller, claims)) {
                        Err e = new Err(errorCode != null ? errorCode : 42, "AUTH_INVALID_TOKEN", "Rejected AuthToken", null);
                        context.error(e).status(HttpResponseStatus.UNAUTHORIZED);
                        caller = null;
                    }
                }
            }
            catch (ExpiredJwtException ex) {
                Err e = new Err(errorCode != null ? errorCode : 43, "AUTH_EXPIRED_TOKEN", "Expired AuthToken", null);
                context.error(e).status(HttpResponseStatus.UNAUTHORIZED);
            }
            catch (JwtException ex) {
                Err e = new Err(errorCode != null ? errorCode : 42, "AUTH_INVALID_TOKEN - " + ((Object)((Object)ex)).getClass().getSimpleName(), "Invalid AuthToken - " + ex.getMessage(), null);
                context.error(e).status(HttpResponseStatus.UNAUTHORIZED);
            }
        }
        context.caller(caller);
        return caller;
    }

    @Override
    public void logout(HttpHeaders httpRequestHeaders, AuthTokenCache cache, ServiceContext context) {
        String authToken = this.getBearerToken(httpRequestHeaders);
        this.logout(authToken, cache, context);
    }

    @Override
    public void logout(String authToken, AuthTokenCache cache, ServiceContext context) {
        try {
            Claims claims = (Claims)JwtUtil.parseJWT(this.authCfg.getJwtParser(), authToken).getBody();
            String jti = claims.getId();
            String uid = claims.getSubject();
            Date exp = claims.getExpiration();
            long expireInMilliseconds = exp.getTime() - System.currentTimeMillis();
            if (cache != null) {
                cache.putOnBlacklist(jti, authToken, expireInMilliseconds);
            }
            if (this.listener != null) {
                this.listener.onLogout(jti, authToken, expireInMilliseconds);
            }
        }
        catch (ExpiredJwtException claims) {
        }
        catch (JwtException ex) {
            context.status(HttpResponseStatus.FORBIDDEN);
            return;
        }
        context.status(HttpResponseStatus.NO_CONTENT);
    }
}

