/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.util.barcode;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.Writer;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.MatrixToImageConfig;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.summerboot.jexpress.util.FormatterUtil;

public class BarcodeUtil {
    public static final int ARGB_BLACK = -16777216;
    public static final int ARGB_WHITE = -1305;
    public static final int ARGB_TRANSPARENT = 0xFFFFFF;
    public static final Map<EncodeHintType, ?> DEFAULT_COFNIG = Map.of(EncodeHintType.CHARACTER_SET, StandardCharsets.UTF_8, EncodeHintType.MARGIN, 0);

    public static String generateBase64Image(String barcodeText, BarcodeFormat barcodeFormat, int widthPixels, int heightPixels, Map<EncodeHintType, ?> cfg, String imageFormat, int onColor, int offColor) throws IOException {
        BitMatrix bitMatrix = BarcodeUtil.generateBarcode(barcodeText, barcodeFormat, widthPixels, heightPixels, cfg);
        byte[] data = BarcodeUtil.toByteArray(bitMatrix, imageFormat, onColor, offColor);
        return FormatterUtil.base64MimeEncode(data);
    }

    public static BitMatrix generateBarcode(String barcodeText, BarcodeFormat format, int widthPixels, int heightPixels, Map<EncodeHintType, ?> cfg) throws IOException {
        MultiFormatWriter writer = new MultiFormatWriter();
        return BarcodeUtil.generateBarcode(barcodeText, (Writer)writer, format, widthPixels, heightPixels, cfg);
    }

    public static BitMatrix generateBarcode(String barcodeText, Writer writer, BarcodeFormat format, int widthPixels, int heightPixels, Map<EncodeHintType, ?> cfg) throws IOException {
        try {
            return writer.encode(barcodeText, format, widthPixels, heightPixels, cfg);
        }
        catch (WriterException ex) {
            throw new IOException(writer.toString() + "(" + format + ")", ex);
        }
    }

    public static byte[] toByteArray(BitMatrix matrix, String imageFormat, int onColor, int offColor) throws IOException {
        byte[] bytes;
        MatrixToImageConfig config = new MatrixToImageConfig(onColor, offColor);
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            MatrixToImageWriter.writeToStream((BitMatrix)matrix, (String)imageFormat, (OutputStream)baos, (MatrixToImageConfig)config);
            bytes = baos.toByteArray();
        }
        return bytes;
    }

    public static BufferedImage toBufferedImage(BitMatrix matrix, int onColor, int offColor) {
        MatrixToImageConfig config = new MatrixToImageConfig(onColor, offColor);
        return MatrixToImageWriter.toBufferedImage((BitMatrix)matrix, (MatrixToImageConfig)config);
    }
}

