/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.boot;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.multibindings.MapBinder;
import com.google.inject.name.Names;
import io.netty.channel.ChannelHandler;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.summerboot.jexpress.boot.annotation.Controller;
import org.summerboot.jexpress.boot.config.ConfigChangeListener;
import org.summerboot.jexpress.boot.config.ConfigChangeListenerImpl;
import org.summerboot.jexpress.boot.instrumentation.BootHealthInspectorImpl;
import org.summerboot.jexpress.boot.instrumentation.HTTPClientStatusListener;
import org.summerboot.jexpress.boot.instrumentation.HealthInspector;
import org.summerboot.jexpress.boot.instrumentation.NIOStatusListener;
import org.summerboot.jexpress.boot.instrumentation.jmx.InstrumentationMgr;
import org.summerboot.jexpress.boot.instrumentation.jmx.InstrumentationMgrImpl;
import org.summerboot.jexpress.boot.instrumentation.jmx.ServerStatus;
import org.summerboot.jexpress.boot.instrumentation.jmx.ServerStatusMBean;
import org.summerboot.jexpress.integration.cache.AuthTokenCache;
import org.summerboot.jexpress.integration.cache.AuthTokenCacheLocalImpl;
import org.summerboot.jexpress.integration.smtp.BootPostOfficeImpl;
import org.summerboot.jexpress.integration.smtp.PostOffice;
import org.summerboot.jexpress.nio.server.BootHttpPingHandler;
import org.summerboot.jexpress.nio.server.BootHttpRequestHandler;
import org.summerboot.jexpress.nio.server.BootNioExceptionHandler;
import org.summerboot.jexpress.nio.server.BootNioLifecycleHandler;
import org.summerboot.jexpress.nio.server.NioExceptionHandler;
import org.summerboot.jexpress.nio.server.NioLifecycle;
import org.summerboot.jexpress.security.auth.Authenticator;
import org.summerboot.jexpress.security.auth.AuthenticatorMockImpl;
import org.summerboot.jexpress.util.ReflectionUtil;

public class BootGuiceModule
extends AbstractModule {
    private final Object caller;
    private final Class callerClass;
    private final String callerRootPackageName;
    private final Set<String> userSpecifiedImplTags;
    private final StringBuilder memo;

    public BootGuiceModule(Object caller, Class callerClass, Set<String> userSpecifiedImplTags, StringBuilder memo) {
        this.caller = caller;
        this.callerClass = callerClass == null ? caller.getClass() : callerClass;
        this.callerRootPackageName = ReflectionUtil.getRootPackageName(this.callerClass);
        this.userSpecifiedImplTags = userSpecifiedImplTags;
        this.memo = memo;
    }

    protected boolean isCliUseImplTag(String implTag) {
        return this.userSpecifiedImplTags.contains(implTag);
    }

    public void configure() {
        String ARROW = " --> ";
        this.bind(NIOStatusListener.class).to(ServerStatus.class);
        this.memo.append("\n\t- Ioc.bind: ").append(NIOStatusListener.class.getName()).append(ARROW).append(ServerStatus.class.getName());
        this.bind(HTTPClientStatusListener.class).to(ServerStatus.class);
        this.memo.append("\n\t- Ioc.bind: ").append(HTTPClientStatusListener.class.getName()).append(ARROW).append(ServerStatus.class.getName());
        this.bind(ServerStatusMBean.class).to(ServerStatus.class);
        this.memo.append("\n\t- Ioc.bind: ").append(ServerStatusMBean.class.getName()).append(ARROW).append(ServerStatus.class.getName());
        this.bind(InstrumentationMgr.class).to(InstrumentationMgrImpl.class);
        this.memo.append("\n\t- Ioc.bind: ").append(InstrumentationMgr.class.getName()).append(ARROW).append(InstrumentationMgrImpl.class.getName());
        this.bind(ConfigChangeListener.class).to(ConfigChangeListenerImpl.class);
        this.memo.append("\n\t- Ioc.bind: ").append(ConfigChangeListener.class.getName()).append(ARROW).append(ConfigChangeListenerImpl.class.getName());
        this.bind(ChannelHandler.class).annotatedWith((Annotation)Names.named((String)BootHttpPingHandler.class.getName())).to(BootHttpPingHandler.class);
        this.memo.append("\n\t- Ioc.bind: ").append(ChannelHandler.class.getName()).append(ARROW).append(BootHttpPingHandler.class.getName()).append(", named=").append(BootHttpPingHandler.class.getName());
        this.bind(HealthInspector.class).to(BootHealthInspectorImpl.class);
        this.memo.append("\n\t- Ioc.bind: ").append(HealthInspector.class.getName()).append(ARROW).append(BootHealthInspectorImpl.class.getName());
        this.bind(AuthTokenCache.class).to(AuthTokenCacheLocalImpl.class);
        this.memo.append("\n\t- Ioc.bind: ").append(AuthTokenCache.class.getName()).append(ARROW).append(AuthTokenCacheLocalImpl.class.getName());
        this.bind(Authenticator.class).to(AuthenticatorMockImpl.class);
        this.memo.append("\n\t- Ioc.bind: ").append(Authenticator.class.getName()).append(ARROW).append(AuthenticatorMockImpl.class.getName());
        this.bind(NioExceptionHandler.class).to(BootNioExceptionHandler.class);
        this.memo.append("\n\t- Ioc.bind: ").append(NioExceptionHandler.class.getName()).append(ARROW).append(BootNioExceptionHandler.class.getName());
        this.bind(NioLifecycle.class).to(BootNioLifecycleHandler.class);
        this.memo.append("\n\t- Ioc.bind: ").append(NioLifecycle.class.getName()).append(ARROW).append(BootNioLifecycleHandler.class.getName());
        this.bind(PostOffice.class).to(BootPostOfficeImpl.class);
        this.memo.append("\n\t- Ioc.bind: ").append(PostOffice.class.getName()).append(ARROW).append(BootPostOfficeImpl.class.getName());
        this.bind(ChannelHandler.class).annotatedWith((Annotation)Names.named((String)"BootHttpRequestHandler")).to(BootHttpRequestHandler.class);
        this.memo.append("\n\t- Ioc.bind: ").append(ChannelHandler.class.getName()).append(ARROW).append(BootHttpRequestHandler.class.getName()).append(", named=").append("BootHttpRequestHandler");
        this.scanAnnotation_BindInstance(this.binder(), Controller.class, this.callerRootPackageName);
        if (this.caller != null) {
            this.requestInjection(this.caller);
            this.memo.append("\n\t- Ioc.bind: ").append(this.caller);
        }
    }

    protected void scanAnnotation_BindInstance(Binder binder, Class<? extends Annotation> annotation, String ... rootPackageNames) {
        MapBinder mapbinder = MapBinder.newMapBinder((Binder)binder, String.class, Object.class, annotation);
        HashSet classesAll = new HashSet();
        for (String rootPackageName : rootPackageNames) {
            Set<Class<?>> classes = ReflectionUtil.getAllImplementationsByAnnotation(annotation, rootPackageName);
            for (Class<?> c2 : classes) {
                int mod;
                Controller a = (Controller)c2.getAnnotation(annotation);
                String implTag = a.implTag();
                if (StringUtils.isNotBlank((CharSequence)implTag) && !this.isCliUseImplTag(implTag) || Modifier.isAbstract(mod = c2.getModifiers()) || Modifier.isInterface(mod)) continue;
                classesAll.add(c2);
            }
        }
        classesAll.forEach(c -> mapbinder.addBinding((Object)c.getName()).to(c));
    }
}

