/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.boot;

import com.google.inject.AbstractModule;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.summerboot.jexpress.boot.SummerSingularity;

public class ScanedGuiceModule
extends AbstractModule {
    private final Map<Class, Map<String, List<SummerSingularity.ServiceMetadata>>> scanedServiceBindingMap;
    private final Set<String> userSpecifiedImplTags;
    private final StringBuilder memo;

    public ScanedGuiceModule(Map<Class, Map<String, List<SummerSingularity.ServiceMetadata>>> scanedServiceBindingMap, Set<String> userSpecifiedImplTags, StringBuilder memo) {
        this.scanedServiceBindingMap = scanedServiceBindingMap;
        this.userSpecifiedImplTags = userSpecifiedImplTags;
        this.memo = memo;
    }

    protected boolean isCliUseImplTag(String implTag) {
        return this.userSpecifiedImplTags.contains(implTag);
    }

    public void configure() {
        String ARROW = " --> ";
        for (Class interfaceClass : this.scanedServiceBindingMap.keySet()) {
            SummerSingularity.ServiceMetadata bindingImpl;
            Map<String, List<SummerSingularity.ServiceMetadata>> taggeServicedMap = this.scanedServiceBindingMap.get(interfaceClass);
            SummerSingularity.ServiceMetadata defaultImpl = null;
            SummerSingularity.ServiceMetadata tagMatchImpl = null;
            HashMap<String, SummerSingularity.ServiceMetadata> namedServiceImpls = new HashMap<String, SummerSingularity.ServiceMetadata>();
            for (String uniqueKey : taggeServicedMap.keySet()) {
                SummerSingularity.ServiceMetadata serviceImpl = taggeServicedMap.get(uniqueKey).get(0);
                if (serviceImpl == null) continue;
                String implTag = serviceImpl.getImplTag();
                boolean isCliUseImplTag = this.isCliUseImplTag(implTag);
                this.memo.append("\n\t- Ioc.taggedservice.check: ").append(interfaceClass.getName()).append(", implTag=").append(uniqueKey).append(ARROW).append(serviceImpl).append(", isCliUseImplTag=").append(isCliUseImplTag);
                String named = serviceImpl.getNamed();
                boolean notNamed = "".equals(named);
                if (notNamed) {
                    if ("".equals(implTag)) {
                        defaultImpl = serviceImpl;
                    }
                    if (!isCliUseImplTag) continue;
                    tagMatchImpl = serviceImpl;
                    continue;
                }
                if ("".equals(implTag) && !namedServiceImpls.containsKey(named)) {
                    namedServiceImpls.put(named, serviceImpl);
                }
                if (!isCliUseImplTag) continue;
                namedServiceImpls.put(named, serviceImpl);
            }
            SummerSingularity.ServiceMetadata serviceMetadata = bindingImpl = tagMatchImpl != null ? tagMatchImpl : defaultImpl;
            if (bindingImpl != null) {
                Class implClass_NotNamed = bindingImpl.getServiceImplClass();
                this.bind(interfaceClass).to(implClass_NotNamed);
                this.memo.append("\n\t- Ioc.taggedservice.override: ").append(interfaceClass).append(" bind to ").append(implClass_NotNamed);
            }
            for (String named : namedServiceImpls.keySet()) {
                bindingImpl = (SummerSingularity.ServiceMetadata)namedServiceImpls.get(named);
                Class implClass_Named = bindingImpl.getServiceImplClass();
                this.bind(interfaceClass).annotatedWith((Annotation)Names.named((String)named)).to(implClass_Named);
                this.memo.append("\n\t- Ioc.taggedservice.override: ").append(interfaceClass).append(" bind to ").append(implClass_Named).append(", named=").append(named);
            }
        }
    }
}

