/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.integration.smtp;

import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.summerboot.jexpress.boot.SummerApplication;
import org.summerboot.jexpress.integration.smtp.Email;
import org.summerboot.jexpress.integration.smtp.PostOffice;
import org.summerboot.jexpress.integration.smtp.SMTPClientConfig;
import org.summerboot.jexpress.nio.server.domain.Err;

@Singleton
public class BootPostOfficeImpl
implements PostOffice {
    private static final ExecutorService POSTOFFICE = BootPostOfficeImpl.buildPostffice();
    protected static SMTPClientConfig smtpCfg = SMTPClientConfig.cfg;
    private String appVersion = "SummerBoot.jExpress 2.3.0";
    protected Logger log = LogManager.getLogger(this.getClass());
    protected final Map<String, Long> debouncingData = new ConcurrentHashMap<String, Long>();

    protected static ExecutorService buildPostffice() {
        ThreadPoolExecutor postoffice = new ThreadPoolExecutor(2, 2, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        Runtime.getRuntime().addShutdownHook(new Thread(() -> postoffice.shutdown(), "ShutdownHook.PostOffice"));
        return postoffice;
    }

    @Override
    public void setAppVersion(String appVersion) {
        this.appVersion = appVersion;
    }

    protected String updateAlertTitle(String title) {
        return "Alert@" + SummerApplication.HOST + " " + this.appVersion + " - " + title;
    }

    protected String updateAlertContent(String content, Throwable cause) {
        if (cause == null) {
            return content;
        }
        return content + "\n\n" + ExceptionUtils.getStackTrace((Throwable)cause);
    }

    @Override
    public void sendAlertAsync(Collection<String> to, String title, String content, Throwable cause, boolean debouncing) {
        this.sendAlert(to, title, content, cause, debouncing, true);
    }

    @Override
    public void sendAlertSync(Collection<String> to, String title, String content, Throwable cause, boolean debouncing) {
        this.sendAlert(to, title, content, cause, debouncing, false);
    }

    protected void sendAlert(Collection<String> to, String title, String content, Throwable cause, boolean debouncing, boolean async) {
        if (to == null || to.isEmpty()) {
            return;
        }
        Runnable postman = () -> {
            if (debouncing) {
                Object key = title;
                Throwable rootCause = ExceptionUtils.getRootCause((Throwable)cause);
                if (rootCause != null) {
                    key = (String)key + rootCause.getClass().getName();
                }
                if (this.debounced((String)key, smtpCfg.getEmailAlertDebouncingInterval())) {
                    return;
                }
            }
            Email email = Email.compose(this.updateAlertTitle(title), this.updateAlertContent(content, cause), Email.Format.text).to(to);
            try {
                email.send(smtpCfg.getMailSession());
            }
            catch (Throwable ex) {
                this.log.fatal("Failed to send email: " + ExceptionUtils.getRootCause((Throwable)ex).toString());
            }
        };
        if (async) {
            POSTOFFICE.execute(postman);
        } else {
            postman.run();
        }
    }

    @Override
    public boolean sendEmailAsync(Collection<String> to, String title, String content, boolean isHTMLFormat) {
        return this.sendEmail(to, title, content, isHTMLFormat, true);
    }

    @Override
    public boolean sendEmailSync(Collection<String> to, String title, String content, boolean isHTMLFormat) {
        return this.sendEmail(to, title, content, isHTMLFormat, false);
    }

    protected boolean sendEmail(Collection<String> to, String title, String content, boolean isHTMLFormat, boolean async) {
        boolean success = false;
        Email email = Email.compose(title, content, isHTMLFormat ? Email.Format.html : Email.Format.text).to(to);
        if (to != null && !to.isEmpty()) {
            try {
                if (async) {
                    Runnable postman = () -> {
                        try {
                            email.send(smtpCfg.getMailSession());
                        }
                        catch (Throwable ex) {
                            this.log.fatal("Failed to send email: " + ExceptionUtils.getRootCause((Throwable)ex).toString());
                        }
                    };
                    POSTOFFICE.execute(postman);
                } else {
                    email.send(smtpCfg.getMailSession());
                }
                success = true;
            }
            catch (Throwable ex) {
                this.log.fatal("Failed to send email: " + ExceptionUtils.getRootCause((Throwable)ex).toString());
            }
        } else {
            this.log.error(() -> "unknown recipient: " + email);
        }
        return success;
    }

    protected boolean debounced(String key, int ttlMinute) {
        long now = System.currentTimeMillis();
        long ttl = now + (long)(ttlMinute * 60000);
        this.clean(now);
        Long existingTTL = this.debouncingData.putIfAbsent(key, ttl);
        return existingTTL != null;
    }

    protected void clean(long now) {
        this.debouncingData.keySet().forEach(key -> {
            Long existingTTL = this.debouncingData.get(key);
            if (existingTTL == null || existingTTL < now) {
                this.debouncingData.remove(key);
            }
        });
    }

    public List<Err> ping(String ... emails) {
        Set<String> r = Set.of(emails);
        Err e = null;
        boolean success = this.sendEmailSync(r, "[Ping] " + this.appVersion, "just to test if you can receive this email.", false);
        if (!success) {
            e = new Err(53, null, "Mail Access Error - failed to send test email to app support", null);
        }
        ArrayList errors = null;
        if (e != null) {
            errors = new ArrayList();
            errors.add(e);
        }
        return errors;
    }
}

