/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.nio.grpc;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import org.summerboot.jexpress.boot.config.BootConfig;
import org.summerboot.jexpress.boot.config.ConfigUtil;
import org.summerboot.jexpress.boot.config.annotation.Config;
import org.summerboot.jexpress.boot.config.annotation.ConfigHeader;
import org.summerboot.jexpress.boot.config.annotation.ImportResource;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
@ImportResource(value="cfg_grpc.properties")
public class GRPCServerConfig
extends BootConfig {
    protected static final String ID = "gRpc.server";
    public static final GRPCServerConfig cfg = new GRPCServerConfig();
    private final int availableProcessors = Runtime.getRuntime().availableProcessors();
    @ConfigHeader(title="1. gRpc.server provider")
    @Config(key="gRpc.server.binding.addr")
    private volatile String bindingAddr = "127.0.0.1";
    @Config(key="gRpc.server.binding.port")
    private volatile int bindingPort = 8424;
    @Config(key="gRpc.server.pool.BizExecutor.mode", desc="valid value = CPU (default), IO, Mixed")
    private volatile ThreadingMode threadingMode = ThreadingMode.CPU;
    @Config(key="gRpc.server.pool.coreSize")
    private volatile int poolCoreSize = this.availableProcessors + 1;
    @Config(key="gRpc.server.pool.maxSize")
    private volatile int poolMaxSizeMaxSize = this.availableProcessors + 1;
    @Config(key="gRpc.server.pool.queueSize")
    private volatile int poolQueueSize = Integer.MAX_VALUE;
    @Config(key="gRpc.server.pool.keepAliveSeconds")
    private volatile long keepAliveSeconds = 60L;
    @Config(key="nio.server.health.InspectionIntervalSeconds")
    private volatile int healthInspectionIntervalSeconds = 5;
    @ConfigHeader(title="2. gRpc.server keystore")
    @Config(key="gRpc.server.ssl.KeyStore", StorePwdKey="gRpc.server.ssl.KeyStorePwd", AliasKey="gRpc.server.ssl.KeyAlias", AliasPwdKey="gRpc.server.ssl.KeyPwd")
    @JsonIgnore
    protected volatile KeyManagerFactory kmf;
    @ConfigHeader(title="3. gRpc.server truststore")
    @Config(key="gRpc.server.ssl.TrustStore", StorePwdKey="gRpc.server.ssl.TrustStorePwd")
    @JsonIgnore
    protected volatile TrustManagerFactory tmf;

    public static void main(String[] args) {
        String t = GRPCServerConfig.generateTemplate(GRPCServerConfig.class);
        System.out.println(t);
    }

    protected GRPCServerConfig() {
    }

    @Override
    @Config(key="gRpc.server.ssl.overrideAuthority")
    protected void loadCustomizedConfigs(File cfgFile, boolean isReal, ConfigUtil helper, Properties props) throws IOException {
        int cpuCoreSize = Runtime.getRuntime().availableProcessors();
        switch (this.threadingMode) {
            case CPU: {
                this.poolMaxSizeMaxSize = this.poolCoreSize = cpuCoreSize + 1;
                break;
            }
            case IO: {
                this.poolMaxSizeMaxSize = this.poolCoreSize = cpuCoreSize * 2 + 1;
                break;
            }
            case Mixed: {
                if (this.poolCoreSize < 1) {
                    this.poolCoreSize = cpuCoreSize * 2 + 1;
                }
                if (this.poolMaxSizeMaxSize < 1) {
                    this.poolMaxSizeMaxSize = cpuCoreSize * 2 + 1;
                }
                if (this.poolMaxSizeMaxSize >= this.poolCoreSize) break;
                this.poolMaxSizeMaxSize = this.poolCoreSize;
            }
        }
    }

    @Override
    public void shutdown() {
    }

    public String getBindingAddr() {
        return this.bindingAddr;
    }

    public int getBindingPort() {
        return this.bindingPort;
    }

    public ThreadingMode getThreadingMode() {
        return this.threadingMode;
    }

    public int getPoolCoreSize() {
        return this.poolCoreSize;
    }

    public int getPoolMaxSizeMaxSize() {
        return this.poolMaxSizeMaxSize;
    }

    public int getPoolQueueSize() {
        return this.poolQueueSize;
    }

    public long getKeepAliveSeconds() {
        return this.keepAliveSeconds;
    }

    public int getHealthInspectionIntervalSeconds() {
        return this.healthInspectionIntervalSeconds;
    }

    public KeyManagerFactory getKmf() {
        return this.kmf;
    }

    public TrustManagerFactory getTmf() {
        return this.tmf;
    }

    public static enum ThreadingMode {
        CPU,
        IO,
        Mixed;

    }
}

