/*
 * Decompiled with CFR 0.152.
 */
package org.summerboot.jexpress.nio.server;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import jakarta.persistence.PersistenceException;
import java.io.IOException;
import java.net.http.HttpConnectTimeoutException;
import java.net.http.HttpTimeoutException;
import java.nio.channels.UnresolvedAddressException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.RejectedExecutionException;
import javax.naming.NamingException;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.summerboot.jexpress.integration.cache.AuthTokenCache;
import org.summerboot.jexpress.integration.smtp.SMTPClientConfig;
import org.summerboot.jexpress.nio.server.NioExceptionHandler;
import org.summerboot.jexpress.nio.server.NioLifecycle;
import org.summerboot.jexpress.nio.server.NioServerHttpRequestHandler;
import org.summerboot.jexpress.nio.server.RequestProcessor;
import org.summerboot.jexpress.nio.server.domain.ServiceContext;
import org.summerboot.jexpress.security.auth.Authenticator;

@Singleton
public class BootHttpRequestHandler
extends NioServerHttpRequestHandler {
    public static final String BINDING_NAME = "BootHttpRequestHandler";
    @Inject
    protected Authenticator authenticator;
    @Inject
    protected NioExceptionHandler nioExceptionHandler;
    @Inject
    protected AuthTokenCache tokenCache;
    @Inject
    protected NioLifecycle nioLifecycleHandler;
    protected static SMTPClientConfig cmtpCfg = SMTPClientConfig.cfg;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void service(ChannelHandlerContext ctx, HttpHeaders httpRequestHeaders, HttpMethod httptMethod, String httpRequestPath, Map<String, List<String>> queryParams, String httpPostRequestBody, ServiceContext context) {
        RequestProcessor processor = null;
        try {
            processor = this.getRequestProcessor(httptMethod, httpRequestPath);
            if (processor == null && (processor = this.getRequestProcessor(httptMethod, "")) == null) {
                this.nioExceptionHandler.onActionNotFound(ctx, httpRequestHeaders, httptMethod, httpRequestPath, queryParams, httpPostRequestBody, context);
                return;
            }
            if (processor.isRoleBased()) {
                context.timestampPOI("auth.begin");
                if (!this.authenticationCheck(processor, httpRequestHeaders, httpRequestPath, context)) {
                    context.status(HttpResponseStatus.UNAUTHORIZED);
                    return;
                }
                if (!processor.authorizationCheck(ctx, httpRequestHeaders, httpRequestPath, queryParams, httpPostRequestBody, context, 46)) {
                    context.status(HttpResponseStatus.FORBIDDEN);
                    return;
                }
            }
            context.timestampPOI("process.begin");
            if (this.authenticator != null && !this.authenticator.preAccessCheck(processor, httpRequestHeaders, httpRequestPath, context)) {
                return;
            }
            if (!this.nioLifecycleHandler.preProcess(processor, httpRequestHeaders, httpRequestPath, context)) {
                return;
            }
            processor.process(ctx, httpRequestHeaders, httpRequestPath, queryParams, httpPostRequestBody, context, 10);
        }
        catch (NamingException ex) {
            this.nioExceptionHandler.onNamingException(ex, httptMethod, httpRequestPath, context);
        }
        catch (PersistenceException ex) {
            this.nioExceptionHandler.onPersistenceException(ex, httptMethod, httpRequestPath, context);
        }
        catch (HttpConnectTimeoutException ex) {
            this.nioExceptionHandler.onHttpConnectTimeoutException(ex, httptMethod, httpRequestPath, context);
        }
        catch (HttpTimeoutException ex) {
            this.nioExceptionHandler.onHttpTimeoutException(ex, httptMethod, httpRequestPath, context);
        }
        catch (RejectedExecutionException ex) {
            this.nioExceptionHandler.onRejectedExecutionException(ex, httptMethod, httpRequestPath, context);
        }
        catch (IOException | UnresolvedAddressException ex) {
            Throwable cause = ExceptionUtils.getRootCause((Throwable)ex);
            if (cause == null) {
                cause = ex;
            }
            if (cause instanceof RejectedExecutionException) {
                this.nioExceptionHandler.onRejectedExecutionException(ex, httptMethod, httpRequestPath, context);
            } else {
                this.nioExceptionHandler.onIOException(ex, httptMethod, httpRequestPath, context);
            }
        }
        catch (InterruptedException ex) {
            this.nioExceptionHandler.onInterruptedException(ex, httptMethod, httpRequestPath, context);
        }
        catch (Throwable ex) {
            this.nioExceptionHandler.onUnexpectedException(ex, processor, ctx, httpRequestHeaders, httptMethod, httpRequestPath, queryParams, httpPostRequestBody, context);
        }
        finally {
            this.nioLifecycleHandler.afterService(processor, ctx, httpRequestHeaders, httptMethod, httpRequestPath, queryParams, httpPostRequestBody, context);
            context.timestampPOI("process.end");
        }
    }

    protected boolean authenticationCheck(RequestProcessor processor, HttpHeaders httpRequestHeaders, String httpRequestPath, ServiceContext context) throws Exception {
        if (this.authenticator == null) {
            return true;
        }
        this.authenticator.verifyBearerToken(httpRequestHeaders, this.tokenCache, null, context);
        return context.caller() != null;
    }

    @Override
    protected String beforeLogging(String log) {
        return this.nioLifecycleHandler.beforeLogging(log);
    }

    @Override
    protected void afterLogging(HttpHeaders httpHeaders, HttpMethod httpMethod, String httpRequestUri, String httpPostRequestBody, ServiceContext context, long queuingTime, long processTime, long responseTime, long responseContentLength, String logContent, Throwable ioEx) throws Exception {
        this.nioLifecycleHandler.afterLogging(httpHeaders, httpMethod, httpRequestUri, httpPostRequestBody, context, queuingTime, processTime, responseTime, responseContentLength, logContent, ioEx);
    }

    @Override
    public String beforeSendingError(String errorContent) {
        return this.nioLifecycleHandler.beforeSendingError(errorContent);
    }
}

